/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.remoteservices.hello.consumer;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.examples.remoteservices.hello.HelloMessage;
import org.eclipse.ecf.examples.remoteservices.hello.IHello;
import org.eclipse.ecf.examples.remoteservices.hello.IHelloAsync;
import org.eclipse.ecf.internal.examples.remoteservices.hello.consumer.Activator;
import org.eclipse.ecf.osgi.services.distribution.IDistributionConstants;
import org.eclipse.ecf.remoteservice.IAsyncCallback;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.RemoteServiceHelper;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HelloConsumerApplication
implements IApplication,
IDistributionConstants,
ServiceTrackerCustomizer {
    public static final String CONSUMER_NAME = "org.eclipse.ecf.examples.remoteservices.hello.consumer";
    private BundleContext bundleContext;
    private ServiceTracker containerFactoryServiceTracker;
    private String containerType = "ecf.r_osgi.peer";
    private final Object appLock = new Object();
    private boolean done = false;
    private ServiceTracker helloServiceTracker;
    private ServiceRegistration discoveryListenerRegistration;
    private ServiceRegistration distributionListenerRegistration;

    public Object start(IApplicationContext appContext) throws Exception {
        this.bundleContext = Activator.getContext();
        this.processArgs(appContext);
        this.getContainerFactory().createContainer(this.containerType);
        this.helloServiceTracker = new ServiceTracker(this.bundleContext, this.createRemoteFilter(), (ServiceTrackerCustomizer)this);
        this.helloServiceTracker.open();
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    private Filter createRemoteFilter() throws InvalidSyntaxException {
        return this.bundleContext.createFilter("(&(objectClass=" + IHello.class.getName() + ")(" + "service.imported" + "=*))");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.helloServiceTracker != null) {
            this.helloServiceTracker.close();
            this.helloServiceTracker = null;
        }
        if (this.containerFactoryServiceTracker != null) {
            this.containerFactoryServiceTracker.close();
            this.containerFactoryServiceTracker = null;
        }
        if (this.discoveryListenerRegistration != null) {
            this.discoveryListenerRegistration.unregister();
            this.discoveryListenerRegistration = null;
        }
        if (this.distributionListenerRegistration != null) {
            this.distributionListenerRegistration.unregister();
            this.distributionListenerRegistration = null;
        }
        this.bundleContext = null;
        Object object = this.appLock;
        synchronized (object) {
            this.done = true;
            this.appLock.notifyAll();
        }
    }

    private IContainerFactory getContainerFactory() {
        if (this.containerFactoryServiceTracker == null) {
            this.containerFactoryServiceTracker = new ServiceTracker(this.bundleContext, IContainerFactory.class.getName(), null);
            this.containerFactoryServiceTracker.open();
        }
        return (IContainerFactory)this.containerFactoryServiceTracker.getService();
    }

    private void processArgs(IApplicationContext appContext) {
        String[] originalArgs = (String[])appContext.getArguments().get("application.args");
        if (originalArgs == null) {
            return;
        }
        int i = 0;
        while (i < originalArgs.length) {
            if (originalArgs[i].equals("-containerType")) {
                this.containerType = originalArgs[i + 1];
                ++i;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForDone() {
        Object object = this.appLock;
        synchronized (object) {
            while (true) {
                if (this.done) {
                    return;
                }
                try {
                    this.appLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public Object addingService(ServiceReference reference) {
        System.out.println("IHello service proxy being added");
        IHello proxy = (IHello)this.bundleContext.getService(reference);
        System.out.println("STARTING remote call via proxy...");
        proxy.hello("org.eclipse.ecf.examples.remoteservices.hello.consumer via proxy");
        System.out.println("COMPLETED remote call via proxy");
        System.out.println();
        System.out.println("STARTING remote call via proxy...");
        proxy.helloMessage(new HelloMessage("org.eclipse.ecf.examples.remoteservices.hello.consumer via proxy", "howdy"));
        System.out.println("COMPLETED remote call via proxy");
        System.out.println();
        if (proxy instanceof IHelloAsync) {
            Object result;
            IHelloAsync helloA = (IHelloAsync)proxy;
            IAsyncCallback<String> callback = new IAsyncCallback<String>(){

                public void onSuccess(String result) {
                    System.out.println("COMPLETED remote call with callback SUCCESS with result=" + result);
                    System.out.println();
                }

                public void onFailure(Throwable t) {
                    System.out.println("COMPLETED remote call with callback FAILED with exception=" + t);
                    System.out.println();
                }
            };
            System.out.println("STARTING async remote call via callback...");
            helloA.helloAsync("org.eclipse.ecf.examples.remoteservices.hello.consumer via async proxy with listener", (IAsyncCallback)callback);
            System.out.println("LOCAL async invocation complete");
            System.out.println();
            System.out.println("STARTING async remote call via future...");
            IFuture future = helloA.helloAsync("org.eclipse.ecf.examples.remoteservices.hello.consumer via async proxy with future");
            System.out.println("LOCAL async future invocation complete");
            System.out.println();
            try {
                while (!future.isDone()) {
                    System.out.println("LOCAL future not yet done...so we're doing other stuff while waiting for future to be done");
                    Thread.sleep(200L);
                }
                result = future.get();
                System.out.println("COMPLETED remote call with future SUCCEEDED with result=" + result);
                System.out.println();
            }
            catch (OperationCanceledException e) {
                System.out.println("COMPLETED remote call with callback CANCELLED with exception=" + (Object)((Object)e));
                System.out.println();
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                System.out.println("COMPLETED remote call with callback INTERRUPTED with exception=" + e);
                System.out.println();
                e.printStackTrace();
            }
            System.out.println("STARTING async remote call via callback...");
            helloA.helloMessageAsync(new HelloMessage("org.eclipse.ecf.examples.remoteservices.hello.consumer via async proxy with listener", "howdy"), (IAsyncCallback)callback);
            System.out.println("LOCAL async invocation complete");
            System.out.println();
            System.out.println("STARTING async remote call via future...");
            future = helloA.helloMessageAsync(new HelloMessage("org.eclipse.ecf.examples.remoteservices.hello.consumer via async proxy with future", "howdy"));
            System.out.println("LOCAL async future invocation complete");
            System.out.println();
            try {
                while (!future.isDone()) {
                    System.out.println("LOCAL future not yet done...so we're doing other stuff while waiting for future to be done");
                    Thread.sleep(200L);
                }
                result = future.get();
                System.out.println("COMPLETED remote call with future SUCCEEDED with result=" + result);
                System.out.println();
            }
            catch (OperationCanceledException e) {
                System.out.println("COMPLETED remote call with callback CANCELLED with exception=" + (Object)((Object)e));
                System.out.println();
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                System.out.println("COMPLETED remote call with callback INTERRUPTED with exception=" + e);
                System.out.println();
                e.printStackTrace();
            }
        }
        IRemoteService remoteService = (IRemoteService)reference.getProperty("service.imported");
        Assert.isNotNull((Object)remoteService);
        remoteService = ((IRemoteServiceProxy)proxy).getRemoteService();
        Assert.isNotNull((Object)remoteService);
        System.out.println("STARTING async remote call via future...");
        IFuture future = RemoteServiceHelper.futureExec((IRemoteService)remoteService, (String)"hello", (Object[])new Object[]{"org.eclipse.ecf.examples.remoteservices.hello.consumer future"});
        System.out.println("LOCAL async future invocation complete");
        try {
            while (!future.isDone()) {
                System.out.println("LOCAL future not yet done...so we're doing other stuff while waiting for future to be done");
                Thread.sleep(200L);
            }
            Object result = future.get();
            System.out.println("COMPLETED remote call with future SUCCEEDED with result=" + result);
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return proxy;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        System.out.println("IHello Service proxy removed");
    }
}

