/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jmdns;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.internal.provider.jmdns.JMDNSDebugOptions;
import org.eclipse.ecf.provider.jmdns.container.JMDNSDiscoveryContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class JMDNSPlugin
implements BundleActivator {
    public static final String NAME = "ecf.discovery.jmdns";
    private static JMDNSPlugin plugin;
    private BundleContext context = null;
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.jmdns";
    private ServiceTracker adapterManagerTracker = null;
    private ServiceRegistration serviceRegistration;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private final DiscoveryServiceFactory serviceFactory = new DiscoveryServiceFactory();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public JMDNSPlugin() {
        plugin = this;
    }

    public IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.adapterManagerTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.IAdapterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        return adapterManager;
    }

    public void start(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        Properties props = new Properties();
        props.put("org.eclipse.ecf.discovery.containerName", NAME);
        props.put("service.ranking", new Integer(750));
        String[] stringArray = new String[3];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.discovery.service.IDiscoveryService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.discovery.IDiscoveryLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.ecf.discovery.IDiscoveryAdvertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[2] = clazz3.getName();
        String[] clazzes = stringArray;
        this.serviceRegistration = this.context.registerService(clazzes, (Object)this.serviceFactory, (Dictionary)props);
    }

    protected Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.serviceRegistration != null && this.serviceFactory.isActive()) {
            ServiceReference reference = this.serviceRegistration.getReference();
            IDiscoveryLocator aLocator = (IDiscoveryLocator)ctxt.getService(reference);
            this.serviceRegistration.unregister();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.ecf.core.IContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IContainer container = (IContainer)aLocator.getAdapter((Class)clazz);
            container.disconnect();
            container.dispose();
            this.serviceRegistration = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        this.context = ctxt;
        plugin = null;
    }

    public static synchronized JMDNSPlugin getDefault() {
        return plugin;
    }

    public void logException(String string, Throwable t) {
        this.getLogService();
        if (this.logService != null) {
            this.logService.log(1, string, t);
        }
    }

    public void logInfo(String string, Throwable t) {
        this.getLogService();
        if (this.logService != null) {
            this.logService.log(3, string, t);
        }
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void logError(String errorString) {
        this.getLogService();
        if (this.logService != null) {
            this.logService.log(1, errorString);
        }
    }

    class DiscoveryServiceFactory
    implements ServiceFactory {
        private volatile JMDNSDiscoveryContainer jdc;

        DiscoveryServiceFactory() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            if (this.jdc == null) {
                try {
                    this.jdc = new JMDNSDiscoveryContainer();
                    this.jdc.connect(null, null);
                }
                catch (IDCreateException e) {
                    Trace.catching((String)JMDNSPlugin.PLUGIN_ID, (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getService(Bundle, ServiceRegistration)", (Throwable)e);
                }
                catch (ContainerConnectException e) {
                    Trace.catching((String)JMDNSPlugin.PLUGIN_ID, (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getService(Bundle, ServiceRegistration)", (Throwable)e);
                    this.jdc = null;
                }
            }
            return this.jdc;
        }

        public boolean isActive() {
            return this.jdc != null;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

