/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.host;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.status.SerializableStatus;
import org.eclipse.ecf.mgmt.framework.BundleEventMTO;
import org.eclipse.ecf.mgmt.framework.BundleInstallException;
import org.eclipse.ecf.mgmt.framework.BundleMTO;
import org.eclipse.ecf.mgmt.framework.IBundleEventHandlerAsync;
import org.eclipse.ecf.mgmt.framework.IBundleManager;
import org.eclipse.ecf.mgmt.framework.host.AbstractManager;
import org.eclipse.ecf.mgmt.framework.startlevel.BundleStartLevelMTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;

public class BundleManager
extends AbstractManager
implements IBundleManager {
    private static final Function<Bundle, BundleMTO> mapper = b -> BundleMTO.createMTO((Bundle)b);
    protected List<IBundleEventHandlerAsync> behs = new ArrayList<IBundleEventHandlerAsync>();
    protected BundleListener localBundleListener = new BundleListener(){

        public void bundleChanged(BundleEvent event) {
            BundleManager.this.fireBundleChangedEvent(event);
        }
    };

    public BundleMTO[] getBundles() {
        List<BundleMTO> results = this.selectAndMap(this.getAllBundles(), null, mapper);
        return results.toArray(new BundleMTO[results.size()]);
    }

    public BundleMTO getBundle(long bundleId) {
        return BundleMTO.createMTO((Bundle)this.getBundle0(bundleId));
    }

    public BundleMTO[] getBundles(String symbolicName) {
        List<BundleMTO> results = this.selectAndMap(this.getAllBundles(), b -> b.getSymbolicName().equals(symbolicName), mapper);
        return results.toArray(new BundleMTO[results.size()]);
    }

    private IStatus startstop(long bundleId, int options, boolean start) {
        Bundle bundle = this.getBundle0(bundleId);
        if (bundle == null) {
            return this.createErrorStatus("Cannot find bundle with bundleId=" + bundleId, new NullPointerException());
        }
        try {
            if (start) {
                bundle.start(options);
            } else {
                bundle.stop(options);
            }
            return new SerializableStatus(Status.OK_STATUS);
        }
        catch (BundleException e) {
            return this.createErrorStatus("Exception starting " + bundle.getSymbolicName() + " version " + bundle.getVersion().toString(), e);
        }
    }

    public IStatus start(long bundleId) {
        return this.startstop(bundleId, 0, true);
    }

    public IStatus stop(long bundleId) {
        return this.startstop(bundleId, 0, false);
    }

    public IStatus start(long bundleId, int options) {
        return this.startstop(bundleId, options, true);
    }

    public IStatus stop(long bundleId, int options) {
        return this.startstop(bundleId, options, false);
    }

    public BundleStartLevelMTO getBundleStartLevel(long bundleId) {
        Bundle b = this.getBundle0(bundleId);
        return b == null ? null : new BundleStartLevelMTO((BundleStartLevelDTO)b.adapt(BundleStartLevelDTO.class));
    }

    public void setBundleStartlevel(long bundleId, int startLevel) {
        Bundle b = this.getBundle0(bundleId);
        if (b == null) {
            return;
        }
        ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
    }

    public BundleMTO installBundle(String url) throws BundleInstallException {
        try {
            return BundleMTO.createMTO((Bundle)this.getContext().installBundle(url));
        }
        catch (BundleException e) {
            this.logError("Cannot install bundle with url=" + url, e);
            throw new BundleInstallException("Cannot install bundle with url=" + url);
        }
    }

    public IStatus uninstallBundle(long bundleId) {
        Bundle b = this.getBundle0(bundleId);
        if (b == null) {
            return this.createErrorStatus("Bundle with id=" + bundleId + " not found to uninstall", new NullPointerException());
        }
        try {
            b.uninstall();
            return SerializableStatus.OK_STATUS;
        }
        catch (BundleException e) {
            return this.createErrorStatus("Could not uninstall bundle=" + bundleId, e);
        }
    }

    public IStatus updateBundle(long bundleId) {
        Bundle b = this.getBundle0(bundleId);
        if (b == null) {
            return this.createErrorStatus("Bundle with id=" + bundleId + " not found to update", new NullPointerException());
        }
        try {
            b.update();
            return SerializableStatus.OK_STATUS;
        }
        catch (BundleException e) {
            return this.createErrorStatus("Cannot update bundle=" + bundleId, e);
        }
    }

    public IStatus updateBundle(long bundleId, String urlString) {
        Bundle b = this.getBundle0(bundleId);
        if (b == null) {
            return this.createErrorStatus("Bundle with id=" + bundleId + " and urlString=" + urlString + " not found to update", new NullPointerException());
        }
        try {
            b.update(new URL(urlString).openStream());
            return SerializableStatus.OK_STATUS;
        }
        catch (BundleException e) {
            return this.createErrorStatus("Cannot update bundle with id=" + bundleId, e);
        }
        catch (IOException e) {
            return this.createErrorStatus("Cannot read from url=" + urlString + " to load bundleId=" + bundleId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addBundleEventHandler(IBundleEventHandlerAsync async) {
        List<IBundleEventHandlerAsync> list = this.behs;
        synchronized (list) {
            return this.behs.add(async);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeBundleEventHandler(IBundleEventHandlerAsync async) {
        List<IBundleEventHandlerAsync> list = this.behs;
        synchronized (list) {
            return this.behs.remove(async);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBundleChangedEvent(BundleEvent event) {
        ArrayList<IBundleEventHandlerAsync> notify = null;
        List<IBundleEventHandlerAsync> list = this.behs;
        synchronized (list) {
            notify = new ArrayList<IBundleEventHandlerAsync>(this.behs);
        }
        for (IBundleEventHandlerAsync beh : notify) {
            beh.handleBundleEventAsync(new BundleEventMTO(event.getOrigin().getBundleId(), event.getType(), BundleMTO.createMTO((Bundle)event.getBundle())));
        }
    }

    @Override
    protected void activate(BundleContext context) throws Exception {
        super.activate(context);
        this.getContext().addBundleListener(this.localBundleListener);
    }

    @Override
    protected void deactivate() throws Exception {
        this.getContext().removeBundleListener(this.localBundleListener);
        super.deactivate();
    }
}

