/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.mqtt.container;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.comm.ConnectionEvent;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.jms.channel.AbstractJMSServerChannel;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.ecf.provider.jms.mqtt.container.MqttChannel;
import org.eclipse.ecf.provider.jms.mqtt.container.MqttChannelMessageHandler;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class MqttJMSServerChannel
extends AbstractJMSServerChannel
implements MqttChannelMessageHandler {
    private static final long serialVersionUID = -5177220940980707980L;
    private MqttChannel channel;

    public MqttJMSServerChannel(ISynchAsynchEventHandler handler, int keepAlive, MqttConnectOptions options, int qos) throws ECFException {
        super(handler, keepAlive);
        JMSID localID = (JMSID)this.getLocalID();
        this.channel = new MqttChannel(localID, (ID)localID, options, qos, this);
    }

    protected void createAndSendMessage(Serializable object, String jmsCorrelationId) throws JMSException {
        if (this.channel != null) {
            this.channel.sendMessage(object, jmsCorrelationId);
        }
    }

    public AbstractJMSServerChannel.Client createClient(ID remoteID) {
        AbstractJMSServerChannel.Client newclient = new AbstractJMSServerChannel.Client((AbstractJMSServerChannel)this, remoteID, false);
        newclient.start();
        return newclient;
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
        Object object = this.waitResponse;
        synchronized (object) {
            this.waitResponse.notifyAll();
        }
        this.fireListenersDisconnect(new ConnectionEvent((IConnection)this, null));
        this.connectionListeners.clear();
    }

    protected Object readObject(byte[] bytes) throws IOException, ClassNotFoundException {
        return MqttChannel.osu.deserializeFromBytes(bytes);
    }

    public void handleMqttChannelMessage(byte[] data, String correlationId) {
        super.handleMessage(data, correlationId);
    }

    protected ConnectionFactory createJMSConnectionFactory(JMSID targetID) throws IOException {
        return null;
    }

    public void connectionLost(Throwable arg0) {
    }
}

