/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.container;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Map;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.SynchEvent;
import org.eclipse.ecf.provider.generic.ClientSOContainer;
import org.eclipse.ecf.provider.generic.ContainerMessage;
import org.eclipse.ecf.provider.generic.SOConfig;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.SOContext;
import org.eclipse.ecf.provider.jms.channel.DisconnectRequestMessage;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;

public abstract class AbstractJMSClient
extends ClientSOContainer {
    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.namespace.jmsid");
    }

    public AbstractJMSClient() throws Exception {
        this(new JMSContainerConfig());
    }

    public AbstractJMSClient(int keepAlive) {
        this(new JMSContainerConfig(keepAlive));
    }

    public AbstractJMSClient(JMSContainerConfig config) {
        super((ISharedObjectContainerConfig)config);
    }

    protected JMSContainerConfig getJMSContainerConfig() {
        return (JMSContainerConfig)this.getConfig();
    }

    protected void handleContainerMessage(ContainerMessage mess) throws IOException {
        if (mess == null) {
            this.debug("got null container message...ignoring");
            return;
        }
        Serializable data = mess.getData();
        if (data instanceof ContainerMessage.CreateMessage) {
            this.handleCreateMessage(mess);
        } else if (data instanceof ContainerMessage.CreateResponseMessage) {
            this.handleCreateResponseMessage(mess);
        } else if (data instanceof ContainerMessage.SharedObjectMessage) {
            this.handleSharedObjectMessage(mess);
        } else if (data instanceof ContainerMessage.SharedObjectDisposeMessage) {
            this.handleSharedObjectDisposeMessage(mess);
        } else {
            this.debug("got unrecognized container message...ignoring: " + mess);
        }
    }

    protected SOContext createSharedObjectContext(SOConfig soconfig, IQueueEnqueue queue) {
        return new JMSContainerContext(soconfig.getSharedObjectID(), soconfig.getHomeContainerID(), (SOContainer)this, soconfig.getProperties(), queue);
    }

    protected Serializable processSynch(SynchEvent e) throws IOException {
        Object req = e.getData();
        if (req instanceof DisconnectRequestMessage) {
            this.handleDisconnectRequest((DisconnectRequestMessage)req);
        }
        return null;
    }

    protected void handleDisconnectRequest(DisconnectRequestMessage request) {
        ID fromID = request.getSenderID();
        if (fromID == null) {
            return;
        }
        ISynchAsynchConnection conn = this.getConnection();
        this.handleLeave(fromID, (IConnection)conn);
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), fromID));
    }

    protected ID handleConnectResponse(ID originalTarget, Object serverData) throws Exception {
        Object cr = null;
        if (serverData instanceof byte[]) {
            cr = AbstractJMSClient.deserializeContainerMessage((byte[])((byte[])serverData));
        } else if (serverData instanceof ContainerMessage) {
            cr = serverData;
        } else {
            throw new ConnectException("Invalid server response to connect request");
        }
        return super.handleConnectResponse(originalTarget, cr);
    }

    class JMSContainerContext
    extends SOContext {
        public JMSContainerContext(ID objID, ID homeID, SOContainer cont, Map props, IQueueEnqueue queue) {
            super(objID, homeID, cont, props, queue);
        }
    }
}

