/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.uitools.swing.CompositeIcon;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ActiveIconBuilder
implements IconBuilder,
Cloneable,
Serializable {
    private IconBuilder original;
    private boolean active;
    private static final ImageFilter INACTIVE_ICON_FILTER = new GrayFilter(true, 50);
    private static final long serialVersionUID = 1L;

    public ActiveIconBuilder(IconBuilder original, boolean active) {
        if (original == null) {
            throw new NullPointerException();
        }
        this.original = original;
        this.active = active;
    }

    public Icon buildIcon() {
        Icon originalIcon = this.original.buildIcon();
        return this.active ? originalIcon : this.buildInactiveIcon(originalIcon);
    }

    protected Icon buildInactiveIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return this.buildInactiveImageIcon((ImageIcon)icon);
        }
        if (icon instanceof CompositeIcon) {
            return this.buildInactiveCompositeIcon((CompositeIcon)icon);
        }
        return icon;
    }

    protected Icon buildInactiveImageIcon(ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        Image inactiveImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), INACTIVE_ICON_FILTER));
        return new ImageIcon(inactiveImage);
    }

    protected Icon buildInactiveCompositeIcon(CompositeIcon compositeIcon) {
        compositeIcon = (CompositeIcon)compositeIcon.clone();
        int cnt = compositeIcon.iconCount();
        for (int i = 0; i < cnt; ++i) {
            compositeIcon.setIcon(i, this.buildInactiveIcon(compositeIcon.getIcon(i)));
        }
        return compositeIcon;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ActiveIconBuilder) {
            return this.equals((ActiveIconBuilder)o);
        }
        return false;
    }

    public boolean equals(ActiveIconBuilder other) {
        return ((Object)this.original).equals(other.original) && this.active == other.active;
    }

    public int hashCode() {
        return ((Object)this.original).hashCode() ^ Boolean.valueOf(this.active).hashCode();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.original);
    }
}

