/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class StatusDialog
extends AbstractDialog {
    private final String helpTopicId;
    private final String messageKey;
    private final Collection status;
    JTree tree;

    public StatusDialog(WorkbenchContext context, Collection status, String titleKey) {
        this(context, status, titleKey, "dialog.status");
    }

    public StatusDialog(WorkbenchContext context, Dialog owner, Collection status, String titleKey) {
        this(context, owner, status, titleKey, "dialog.status");
    }

    public StatusDialog(WorkbenchContext context, Collection status, String titleKey, String helpTopicId) {
        this(context, status, titleKey, "STATUS_DIALOG_MESSAGE", helpTopicId);
    }

    public StatusDialog(WorkbenchContext context, Dialog owner, Collection status, String titleKey, String helpTopicId) {
        this(context, owner, status, titleKey, "STATUS_DIALOG_MESSAGE", helpTopicId);
    }

    public StatusDialog(WorkbenchContext context, Collection status, String titleKey, String messageKey, String helpTopicId) {
        super(context);
        if (status == null) {
            throw new NullPointerException("The collection of status cannot be null");
        }
        this.status = status;
        this.messageKey = messageKey;
        this.helpTopicId = helpTopicId;
        this.setTitle(this.resourceRepository().getString(titleKey));
    }

    public StatusDialog(WorkbenchContext context, Dialog owner, Collection status, String titleKey, String messageKey, String helpTopicId) {
        super(context, owner);
        if (status == null) {
            throw new NullPointerException("The collection of status cannot be null");
        }
        this.status = status;
        this.messageKey = messageKey;
        this.helpTopicId = helpTopicId;
        this.setTitle(this.resourceRepository().getString(titleKey));
    }

    public static Status createStatus(Object item, List status) {
        return StatusDialog.createStatus(item, status, Collections.EMPTY_LIST);
    }

    public static Status createStatus(Object item, List status, List children) {
        return new LocalStatus(item, status, children);
    }

    public static Status createStatus(Object item, Map status) {
        return StatusDialog.createStatus(item, new Vector(status.keySet()));
    }

    public static Status createStatus(Object item, Map status, List children) {
        return StatusDialog.createStatus(item, new Vector(status.keySet()), children);
    }

    private ComponentListener buildComponentListener() {
        return new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                StatusDialog.this.updateTree();
            }
        };
    }

    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        LabelArea messageLabel = new LabelArea(this.resourceRepository().getString(this.messageKey));
        messageLabel.getAccessibleContext().setAccessibleName(messageLabel.getText());
        messageLabel.setScrollable(true);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)messageLabel, constraints);
        this.tree = new StatusTree();
        this.tree.setRowHeight(0);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setDoubleBuffered(true);
        this.tree.setCellRenderer(new StatusTreeNodeRenderer());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        JScrollPane pane = new JScrollPane(this.tree);
        pane.addComponentListener(this.buildComponentListener());
        container.add((Component)pane, constraints);
        messageLabel.setLabelFor(this.tree);
        return container;
    }

    protected CellRendererAdapter buildNodeRenderer(Object value) {
        if (value instanceof Node) {
            return CellRendererAdapter.NODE_CELL_RENDERER_ADAPTER;
        }
        if (value instanceof Displayable) {
            return CellRendererAdapter.DISPLAYABLE_CELL_RENDERER_ADAPTER;
        }
        if (value instanceof MWError) {
            return new MWErrorCellRendererAdapter();
        }
        return CellRendererAdapter.DEFAULT_CELL_RENDERER_ADAPTER;
    }

    private void buildTreeContent() {
        MutableTreeNode rootNode = this.rootNode();
        Iterator iter = this.status.iterator();
        while (iter.hasNext()) {
            this.buildTreeNode(rootNode, (Status)iter.next());
        }
    }

    private void buildTreeNode(MutableTreeNode parentNode, Status nodeStatus) {
        StatusTreeNode statusNode = this.buildTreeNode(nodeStatus.getItem(), false);
        parentNode.insert(statusNode, parentNode.getChildCount());
        Iterator iter = nodeStatus.status();
        while (iter.hasNext()) {
            StatusTreeNode node = this.buildTreeNode(iter.next(), true);
            statusNode.insert(node, statusNode.getChildCount());
        }
        iter = nodeStatus.children();
        while (iter.hasNext()) {
            this.buildTreeNode(statusNode, (Status)iter.next());
        }
    }

    private StatusTreeNode buildTreeNode(Object value, boolean requireWrapping) {
        return new StatusTreeNode(value, this.buildNodeRenderer(value));
    }

    protected boolean cancelButtonIsVisible() {
        return false;
    }

    private void expandAll(MutableTreeNode node) {
        if (node.isLeaf()) {
            return;
        }
        this.expandPath(node);
        Enumeration<? extends TreeNode> stream = node.children();
        while (stream.hasMoreElements()) {
            MutableTreeNode childNode = (MutableTreeNode)stream.nextElement();
            this.expandAll(childNode);
        }
    }

    private void expandPath(MutableTreeNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        Object[] paths = model.getPathToRoot(node);
        this.tree.expandPath(new TreePath(paths));
    }

    protected String helpTopicId() {
        return this.helpTopicId;
    }

    protected void initialize(WorkbenchContext context) {
        super.initialize(context.buildExpandedResourceRepositoryContext(UiCommonBundle.class));
    }

    protected void prepareToShow() {
        this.setSize(455, 230);
        this.setLocationRelativeTo(this.getParent());
        this.buildTreeContent();
        this.updateTree();
    }

    void updateTree() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.expandAll(this.rootNode());
        this.tree.revalidate();
        this.tree.repaint();
    }

    protected final MutableTreeNode rootNode() {
        return (MutableTreeNode)((DefaultTreeModel)this.tree.getModel()).getRoot();
    }

    private class StatusTreeNodeRenderer
    extends SimpleTreeCellRenderer {
        private StatusTreeNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree t, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            return node.isRoot() ? this : super.getTreeCellRendererComponent(t, value, sel, expanded, leaf, row, cellHasFocus);
        }

        protected String buildAccessibleName(Object value) {
            return ((StatusTreeNode)value).buildAccessibleName();
        }

        protected Icon buildIcon(Object value) {
            return ((StatusTreeNode)value).buildIcon();
        }

        protected String buildText(Object value) {
            return ((StatusTreeNode)value).buildText();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusNode();
            }
            return this.accessibleContext;
        }

        protected class AccessibleStatusNode
        extends JLabel.AccessibleJLabel {
            protected AccessibleStatusNode() {
                super(StatusTreeNodeRenderer.this);
            }

            public String getAccessibleName() {
                return super.getAccessibleName();
            }
        }
    }

    private class StatusTreeNode
    extends DefaultMutableTreeNode {
        private final CellRendererAdapter renderer;

        private StatusTreeNode(Object value, CellRendererAdapter renderer) {
            super(value);
            this.renderer = renderer;
        }

        public String buildAccessibleName() {
            return this.renderer.buildAccessibleName(this.getUserObject());
        }

        public Icon buildIcon() {
            return this.renderer.buildIcon(this.getUserObject());
        }

        public String buildText() {
            return this.renderer.buildText(this.getUserObject());
        }
    }

    private class StatusTree
    extends SwingComponentFactory.AccessibleTree {
        private StatusTree() {
            super(new DefaultTreeModel(new DefaultMutableTreeNode("")));
        }

        public void collapsePath(TreePath path) {
        }

        public void collapseRow(int row) {
        }

        protected void setExpandedState(TreePath path, boolean state) {
            if (state) {
                super.setExpandedState(path, state);
            }
        }
    }

    private static class LocalStatus
    implements Status {
        private final List children;
        private final Object item;
        private final List status;

        public LocalStatus(Object item, List status, List children) {
            this.item = item;
            this.status = status;
            this.children = children;
        }

        public Iterator children() {
            return this.children.iterator();
        }

        public Object getItem() {
            return this.item;
        }

        public Iterator status() {
            return this.status.iterator();
        }
    }

    protected class MWErrorCellRendererAdapter
    extends AbstractCellRendererAdapter {
        protected MWErrorCellRendererAdapter() {
        }

        public Icon buildIcon(Object value) {
            MWError error = (MWError)value;
            String errorId = error.getErrorId();
            if (errorId.endsWith("SUCCESSFUL")) {
                return StatusDialog.this.resourceRepository().getIcon("approve");
            }
            if (errorId.endsWith("ERROR")) {
                return StatusDialog.this.resourceRepository().getIcon("error");
            }
            return StatusDialog.this.resourceRepository().getIcon("warning");
        }

        public String buildText(Object value) {
            MWError error = (MWError)value;
            return StatusDialog.this.resourceRepository().getString(error.getErrorId(), error.getArguments());
        }
    }

    public static interface Status {
        public Iterator children();

        public Object getItem();

        public Iterator status();
    }
}

