/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCopyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class CopyPolicyPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel copyPolicyHolder;
    private PropertyValueModel policyTypeHolder;
    static final int EDITOR_WEIGHT = 9;

    CopyPolicyPropertiesPage(PropertyValueModel valueModel, WorkbenchContextHolder contextHolder) {
        super(valueModel, contextHolder);
    }

    protected JPanel buildUseCloneMethodPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        ListChooser cloneMethodChooser = this.buildCloneMethodListChooser();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)cloneMethodChooser, constraints);
        cloneMethodChooser.putClientProperty("labeledBy", new JLabel(" "));
        return panel;
    }

    protected String getHelpTopicId() {
        return "descriptor.copying";
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel copyPolicyPanel = new JPanel(new GridBagLayout());
        copyPolicyPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JRadioButton useInstantiationPolicy = this.buildUseInstantiationPolicyButton();
        JRadioButton useClone = this.buildUseCloneMethodPolicyButton();
        JPanel useCloneMethodPanel = this.buildUseCloneMethodPanel();
        this.buildCloneMethodPaneEnabler(this.buildPolicyTypeValueHolder(), useCloneMethodPanel.getComponents());
        GroupBox groupBox = new GroupBox(useInstantiationPolicy, useClone, useCloneMethodPanel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        copyPolicyPanel.add((Component)groupBox, constraints);
        this.addHelpTopicId(useCloneMethodPanel, this.getHelpTopicId() + ".useCloneMethod");
        this.addHelpTopicId(copyPolicyPanel, this.getHelpTopicId());
        return copyPolicyPanel;
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.copyPolicyHolder = this.buildCopyPolicyHolder();
    }

    private PropertyValueModel buildCopyPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "copyPolicy"){

            protected Object getValueFromSubject() {
                MWDescriptorPolicy policy = ((MWMappingDescriptor)this.subject).getCopyPolicy();
                return policy.isActive() ? policy : null;
            }
        };
    }

    private JRadioButton buildUseInstantiationPolicyButton() {
        JRadioButton radioButton = this.buildRadioButton("useCopyPolicy", new RadioButtonModelAdapter(this.buildPolicyTypeValueHolder(), "instantiation"));
        return radioButton;
    }

    private JRadioButton buildUseCloneMethodPolicyButton() {
        JRadioButton radioButton = this.buildRadioButton("useCloneMethod", new RadioButtonModelAdapter(this.buildPolicyTypeValueHolder(), "clone"));
        return radioButton;
    }

    private PropertyValueModel buildPolicyTypeValueHolder() {
        if (this.policyTypeHolder == null) {
            this.policyTypeHolder = new PropertyAspectAdapter(this.copyPolicyHolder, "copyPolicyType"){

                protected Object getValueFromSubject() {
                    return ((MWDescriptorCopyPolicy)this.subject).getPolicyType();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWDescriptorCopyPolicy)this.subject).setPolicyType((String)value);
                }
            };
        }
        return this.policyTypeHolder;
    }

    private PropertyValueModel buildClassHolder() {
        return new PropertyAspectAdapter(this.copyPolicyHolder){

            protected Object getValueFromSubject() {
                return ((MWDescriptorCopyPolicy)this.subject).getOwningDescriptor().getMWClass();
            }
        };
    }

    private PropertyValueModel buildCloneMethodSelectionHolder() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.copyPolicyHolder, "copyMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorCopyPolicy)this.subject).getMethod();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorCopyPolicy)this.subject).setMethod((MWMethod)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "signature");
    }

    private ListChooser buildCloneMethodListChooser() {
        ListChooser listChooser = new ListChooser(this.buildCloneMethodComboBoxModel(), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private CachingComboBoxModel buildCloneMethodComboBoxModel() {
        return new IndirectComboBoxModel(this.buildCloneMethodSelectionHolder(), this.buildClassHolder()){

            protected ListIterator listValueFromSubject(Object subject) {
                return CopyPolicyPropertiesPage.this.orderedCloneMethodChoices((MWClass)subject);
            }
        };
    }

    ListIterator orderedCloneMethodChoices(MWClass mwClass) {
        return CollectionTools.sort((Iterator)mwClass.candidateCloneMethods()).listIterator();
    }

    private ComponentEnabler buildCloneMethodPaneEnabler(PropertyValueModel useCloneMethodHolder, Component[] components) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(useCloneMethodHolder){

            protected Object transform(Object value) {
                return "clone".equals(value);
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, components);
    }
}

