/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWDirectToFieldMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWManyToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.utility.string.SimpleStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class TableGenerator {
    private WorkbenchContext workbenchContext;
    private Collection classDescriptors;
    private HashMap descriptorLookup;
    private HashMap tableLookup;
    private MWRelationalProject project;
    private Vector log;
    private HashMap relationshipTableLookup;
    private int tableCreatedCount;
    protected static HashMap primitiveToJavaTypeMap;
    protected final int ATTR_TYPE = 0;
    protected final int ITEM_TYPE = 1;

    TableGenerator(WorkbenchContext workbenchContext) {
        this.initialize(workbenchContext);
    }

    protected void initialize(WorkbenchContext workbenchContex) {
        this.workbenchContext = workbenchContex;
        this.descriptorLookup = new HashMap();
        this.tableLookup = new HashMap();
        this.relationshipTableLookup = new HashMap();
        this.log = new Vector();
    }

    public StatusDialog.Status generateTablesFromDescriptors(Collection descriptorCollection) {
        MWDescriptor firstDescriptor = (MWDescriptor)descriptorCollection.iterator().next();
        this.setProject((MWRelationalProject)firstDescriptor.getProject());
        this.setClassDescriptors(this.sortTableDescriptors(descriptorCollection));
        this.runGenerateTables();
        this.generationCompleted();
        if (descriptorCollection.size() == 1) {
            return StatusDialog.createStatus((Object)firstDescriptor, this.log);
        }
        return StatusDialog.createStatus((Object)this.project, this.log);
    }

    private void generationCompleted() {
        if (this.log.isEmpty()) {
            this.log.add(new MWError("TABLE_GENERATOR_SUCCESSFUL"));
        }
    }

    protected void runGenerateTables() {
        MWClass sourceClass;
        MWMapping mapping;
        Iterator mappings;
        int count = 0;
        for (MWTableDescriptor descriptor : this.getClassDescriptors()) {
            ++count;
            this.createTableIfAbsent(descriptor);
            descriptor.setActive(true);
        }
        count = 0;
        for (MWTableDescriptor descriptor : this.getClassDescriptors()) {
            Iterator attributes = descriptor.getMWClass().attributes();
            while (attributes.hasNext()) {
                MWClassAttribute attribute = (MWClassAttribute)attributes.next();
                MWMapping mapping2 = descriptor.mappingForAttribute(attribute);
                if (mapping2 != null) continue;
                descriptor.addDirectMapping(attribute);
            }
            mappings = descriptor.mappings();
            while (mappings.hasNext()) {
                mapping = (MWMapping)mappings.next();
                sourceClass = mapping.getParentDescriptor().getMWClass();
                this.generateForNonCollectionMapping(mapping, sourceClass);
            }
            ++count;
        }
        count = 0;
        for (MWTableDescriptor descriptor : this.getClassDescriptors()) {
            mappings = descriptor.mappings();
            while (mappings.hasNext()) {
                mapping = (MWMapping)mappings.next();
                sourceClass = mapping.getParentDescriptor().getMWClass();
                this.generateForCollectionMapping(mapping, sourceClass);
            }
            ++count;
        }
    }

    protected MWOneToOneMapping backpointerFor(MWMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWClass itemType = attrAndItemType[this.ITEM_TYPE];
        MWTableDescriptor itemDescriptor = this.locateDescriptorFor(itemType);
        Iterator stream = itemType.attributes();
        while (stream.hasNext()) {
            MWMapping backMapping;
            MWClassAttribute attribute = (MWClassAttribute)stream.next();
            if (attribute.getType() != sourceClass && (!attribute.isValueHolder() || attribute.getValueType() != sourceClass) || (backMapping = itemDescriptor.mappingNamed(attribute.getName())) == null || attribute.getType().isAssignableToCollection()) continue;
            if (backMapping instanceof MWOneToOneMapping) {
                return (MWOneToOneMapping)backMapping;
            }
            return backMapping.asMWOneToOneMapping();
        }
        stream = itemDescriptor.mappings();
        while (stream.hasNext()) {
            MWOneToOneMapping oneToOne;
            MWMapping itemMapping = (MWMapping)stream.next();
            if (!(itemMapping instanceof MWOneToOneMapping) || (oneToOne = (MWOneToOneMapping)itemMapping).getReferenceDescriptor().getMWClass() != sourceClass) continue;
            return oneToOne;
        }
        return null;
    }

    protected Collection copyInheritedPrimaryKeys(MWTableDescriptor superclassDesc, MWTableDescriptor subclassDesc) {
        MWTableDescriptor definingDescriptor = superclassDesc;
        boolean definingDescriptorFound = false;
        while (!definingDescriptorFound) {
            MWTableDescriptor superD = this.locateDescriptorFor(definingDescriptor.getMWClass().getSuperclass());
            if (superD == null) {
                definingDescriptorFound = true;
                continue;
            }
            definingDescriptor = superD;
        }
        if (!definingDescriptor.getInheritancePolicy().isActive()) {
            definingDescriptor.addInheritancePolicy();
        }
        ((MWDescriptorInheritancePolicy)definingDescriptor.getInheritancePolicy()).setIsRoot(true);
        if (definingDescriptor.primaryKeysSize() == 0) {
            this.logError(this.resourceRepository().getString("unableToFindKeyFieldsForInSuperclasses", new Object[]{subclassDesc.getMWClass().shortName()}));
            ArrayList<Object[]> array = new ArrayList<Object[]>();
            array.add(this.fabricateKeyFor(subclassDesc.getMWClass(), this.getTableFor(subclassDesc.getMWClass())));
            return array;
        }
        MWTable primaryTable = subclassDesc.getPrimaryTable();
        Iterator stream = definingDescriptor.primaryKeys();
        while (stream.hasNext()) {
            MWColumn primaryKey = (MWColumn)stream.next();
            if (primaryTable.containsColumnNamed(primaryKey.getName())) continue;
            ((MWRelationalTransactionalPolicy)subclassDesc.getTransactionalPolicy()).getPrimaryKeyPolicy().addPrimaryKey(primaryTable.addColumnLike(primaryKey));
        }
        if (!subclassDesc.getInheritancePolicy().isActive()) {
            subclassDesc.addInheritancePolicy();
        }
        MWDescriptorInheritancePolicy subInheritPolicy = (MWDescriptorInheritancePolicy)subclassDesc.getInheritancePolicy();
        MWClassIndicatorPolicy subIndicatorPolicy = subInheritPolicy.getClassIndicatorPolicy();
        subInheritPolicy.setIsRoot(false);
        subInheritPolicy.setParentDescriptor((MWDescriptor)superclassDesc);
        return null;
    }

    protected HashMap copyPrimaryKeyColumns(MWTable sourceTable, MWTable targetTable) {
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        Iterator stream = sourceTable.primaryKeyColumns();
        while (stream.hasNext()) {
            MWColumn keyColumn = (MWColumn)stream.next();
            MWColumn keyColumnCopy = targetTable.addColumnLike(keyColumn);
            keyColumnCopy.setName(this.newColumnName(targetTable, sourceTable.getName() + "_" + keyColumn.getName()));
            columnNameMap.put(keyColumn.getName(), keyColumnCopy.getName());
            keyColumnCopy.setPrimaryKey(false);
        }
        return columnNameMap;
    }

    protected MWColumn createColumn(String potentialName, MWTable sourceTable, MWColumn foreignColumn) {
        String newColumnName = this.newColumnName(sourceTable, potentialName);
        MWColumn newColumn = sourceTable.addColumn(newColumnName);
        newColumn.setDatabaseType(foreignColumn.getDatabaseType());
        return newColumn;
    }

    protected MWColumn createColumn(String name, String javaClassName, int arrayDepth, MWTable table) {
        String columnName = this.newColumnName(table, name);
        DatabaseType dbType = null;
        try {
            dbType = this.getDatabase().getDatabasePlatform().databaseTypeForJavaTypeDeclaration(javaClassName, arrayDepth);
        }
        catch (IllegalArgumentException iae) {
            dbType = this.getDatabase().getDatabasePlatform().defaultDatabaseType();
        }
        MWColumn column = table.addColumn(columnName);
        column.setDatabaseType(dbType);
        return column;
    }

    protected MWColumn createPrimaryKeyColumn(String fieldName, String javaClassName, int arrayDepth, MWTable table) {
        MWColumn column = this.createColumn(fieldName, javaClassName, arrayDepth, table);
        column.setPrimaryKey(true);
        return column;
    }

    protected void createPrimaryKeyFields(MWClass bldrClass, MWTable table) {
        Collection parentKeys;
        ArrayList<Object[]> keyColumns = new ArrayList<Object[]>();
        MWTableDescriptor superclassDescriptor = this.locateDescriptorFor(bldrClass.getSuperclass());
        if (superclassDescriptor != null && (parentKeys = this.copyInheritedPrimaryKeys(superclassDescriptor, this.getDescriptorFor(bldrClass))) == null) {
            return;
        }
        if (keyColumns.isEmpty()) {
            keyColumns.addAll(this.defaultKeysFor(bldrClass, table));
        }
        if (keyColumns.isEmpty()) {
            keyColumns.add(this.fabricateKeyFor(bldrClass, table));
        }
        for (Object[] varAndColumn : keyColumns) {
            MWClassAttribute attribute = (MWClassAttribute)varAndColumn[0];
            MWColumn column = (MWColumn)varAndColumn[1];
            MWTableDescriptor descriptor = this.getDescriptorFor(bldrClass);
            MWMapping existingMapping = descriptor.mappingForAttribute(attribute);
            if (existingMapping != null) {
                descriptor.removeMapping(existingMapping);
            }
            MWDirectToFieldMapping mapping = (MWDirectToFieldMapping)descriptor.addDirectMapping(attribute);
            mapping.setColumn(column);
            mapping.setUsesMethodAccessing(this.getProject().getDefaultsPolicy().isMethodAccessing());
            ((MWRelationalTransactionalPolicy)descriptor.getTransactionalPolicy()).getPrimaryKeyPolicy().addPrimaryKey(column);
        }
    }

    protected MWReference createReferenceIfAbsent(MWTable sourceTable, MWTable targetTable, HashMap keyColumnTranslations) {
        String nameOfReference = sourceTable.getName() + "_" + targetTable.getName();
        MWReference reference = sourceTable.referenceNamed(nameOfReference);
        if (reference != null) {
            return reference;
        }
        reference = sourceTable.addReference(nameOfReference, targetTable);
        Iterator stream = targetTable.primaryKeyColumns();
        while (stream.hasNext()) {
            MWColumn targetColumn = (MWColumn)stream.next();
            String sourceColumnName = targetColumn.getName();
            if (keyColumnTranslations != null && keyColumnTranslations.get(targetColumn.getName()) != null) {
                sourceColumnName = (String)keyColumnTranslations.get(targetColumn.getName());
            }
            MWColumn joinColumn = sourceTable.columnNamed(sourceColumnName);
            reference.addColumnPair(joinColumn, targetColumn);
        }
        return reference;
    }

    protected MWTable createTableIfAbsent(MWTableDescriptor descriptor) {
        MWClass bldrClass = descriptor.getMWClass();
        if (bldrClass.attributesSize() == 0 && descriptor.mappingsSize() == 0) {
            MWTableDescriptor parentDescriptor;
            if (bldrClass.getSuperclass() != null && (parentDescriptor = this.getDescriptorFor(bldrClass.getSuperclass())) != null) {
                descriptor.setPrimaryTable(parentDescriptor.getPrimaryTable());
            }
            return null;
        }
        MWTable table = descriptor.getPrimaryTable();
        if (table == null) {
            String proposedName = bldrClass.defaultTableNameWithLength(this.getTableNameLength());
            table = this.getDatabase().addTable(this.newTableName(proposedName));
            ++this.tableCreatedCount;
            descriptor.setPrimaryTable(table);
        }
        this.tableLookup.put(bldrClass, table);
        if (!table.primaryKeyColumns().hasNext()) {
            this.createPrimaryKeyFields(bldrClass, table);
        }
        return table;
    }

    public static String defaultAbstractClassIndicatorFieldName() {
        return "SUBCLASS";
    }

    protected Collection defaultKeysFor(MWClass bldrClass, MWTable table) {
        MWColumn column;
        MWClassAttribute attribute;
        String pkSearchPattern = this.getProject().getTableGenerationPolicy().getPrimaryKeySearchPattern();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Iterator stream = bldrClass.attributes();
        while (stream.hasNext()) {
            attribute = (MWClassAttribute)stream.next();
            if (!new SimpleStringMatcher(pkSearchPattern, true).matches(attribute.getName()) || (column = this.createPrimaryKeyColumn(attribute.getName(), attribute.typeName(), attribute.getDimensionality(), table)) == null) continue;
            result.add(new Object[]{attribute, column});
        }
        if (result.isEmpty()) {
            stream = bldrClass.allAttributes();
            while (stream.hasNext()) {
                attribute = (MWClassAttribute)stream.next();
                if (!new SimpleStringMatcher(pkSearchPattern, true).matches(attribute.getName())) continue;
                this.getDescriptorFor(bldrClass).addInheritedAttribute(attribute);
                column = this.createPrimaryKeyColumn(attribute.getName(), attribute.typeName(), attribute.getDimensionality(), table);
                if (column == null) continue;
                result.add(new Object[]{attribute, column});
            }
        }
        return result;
    }

    protected MWClass[] determineAttrAndItemType(MWMapping mapping, boolean firstPass) {
        MWClassAttribute attribute = mapping.getInstanceVariable();
        if (attribute == null) {
            return new MWClass[]{null, null};
        }
        MWClass attrType = null;
        MWClass itemType = null;
        if (attribute.isValueHolder()) {
            if (!attribute.getValueType().isObject()) {
                attrType = attribute.getValueType();
                if (attrType.isAssignableToCollection()) {
                    itemType = attribute.getItemType();
                }
            } else {
                if (firstPass) {
                    this.logUrgent(this.resourceRepository().getString("VALUE_HOLDER_TYPE_SELECT", new Object[]{attribute.getName(), attribute.getDeclaringType().getName()}));
                }
                attrType = attribute.getType();
            }
        } else {
            attrType = attribute.getType();
            itemType = attribute.getItemType();
        }
        if ((attrType == null || itemType == null) && mapping != null) {
            if (mapping.isCollectionMapping()) {
                MWCollectionMapping collectionMapping = (MWCollectionMapping)mapping;
                if (attrType == null) {
                    attrType = collectionMapping.getContainerPolicy().getDefaultingContainerClass().getContainerClass();
                }
                if (itemType == null && collectionMapping.getReferenceDescriptor() != null) {
                    itemType = collectionMapping.getReferenceDescriptor().getMWClass();
                }
            } else if (mapping instanceof MWReferenceMapping) {
                MWReferenceMapping referenceMapping = (MWReferenceMapping)mapping;
                if (attrType == null && referenceMapping.getReferenceDescriptor() != null) {
                    attrType = referenceMapping.getReferenceDescriptor().getMWClass();
                }
            }
        }
        return new MWClass[]{attrType, itemType};
    }

    protected static boolean directCollectionContentsAreSorted() {
        return true;
    }

    protected static boolean directCollectionContentsAreUnsorted() {
        return !TableGenerator.directCollectionContentsAreSorted();
    }

    protected static boolean directCollectionsHaveUniqueEntries() {
        return true;
    }

    protected Object[] fabricateKeyFor(MWClass bldrClass, MWTable table) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.resourceRepository().getString("noKeyFieldFound", new Object[]{bldrClass.shortName()}));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(this.resourceRepository().getString("pleaseEditJavaSourceFileAppropriately"));
        this.logUrgent(buffer.toString());
        String defaultPKName = this.getProject().getTableGenerationPolicy().getDefaultPrimaryKeyName().toLowerCase();
        MWClass typeInt = this.getProject().typeFor(Integer.TYPE);
        MWClassAttribute attribute = bldrClass.addAttribute(defaultPKName, typeInt);
        MWColumn primaryKey = this.createPrimaryKeyColumn(attribute.getName(), attribute.typeName(), attribute.getDimensionality(), table);
        return new Object[]{attribute, primaryKey};
    }

    protected MWMapping generateForMWAggregateMapping(MWMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWAggregateMapping aggregateMapping = mapping instanceof MWAggregateMapping ? (MWAggregateMapping)mapping : mapping.asMWAggregateMapping();
        boolean mapCollectionMappings = false;
        this.mapAggregateMapping(aggregateMapping, attrAndItemType, sourceClass, mapCollectionMappings);
        return mapping;
    }

    protected MWCollectionMapping generateForMWCollectionMapping(MWMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWCollectionMapping collectionMapping;
        MWClass itemType = attrAndItemType[this.ITEM_TYPE];
        if (itemType.isInterface() || itemType.getName().equals(Object.class.getName())) {
            return null;
        }
        if (mapping != null && mapping.isCollectionMapping()) {
            collectionMapping = (MWCollectionMapping)mapping;
        } else {
            MWOneToOneMapping backpointer = this.backpointerFor(mapping, attrAndItemType, sourceClass);
            if (backpointer == null) {
                this.logNotify(this.resourceRepository().getString("refersToWhichHasNoBackpointer", new Object[]{sourceClass.shortName(), mapping.getName(), itemType.shortName()}));
                collectionMapping = mapping.asMWManyToManyMapping();
            } else {
                this.logAssumption(this.resourceRepository().getString("isBackpointerFor", new Object[]{itemType.shortName(), backpointer.getName(), sourceClass.shortName(), mapping.getName()}));
                collectionMapping = mapping.asMWOneToManyMapping();
            }
        }
        if (collectionMapping instanceof MWManyToManyMapping) {
            this.mapManyToManyMapping((MWManyToManyMapping)collectionMapping, attrAndItemType, sourceClass);
        } else {
            this.mapOneToManyMapping((MWOneToManyMapping)collectionMapping, attrAndItemType, sourceClass);
        }
        collectionMapping.getContainerPolicy().getDefaultingContainerClass().setContainerClass(attrAndItemType[this.ATTR_TYPE]);
        collectionMapping.setReferenceDescriptor((MWDescriptor)this.locateDescriptorFor(itemType));
        return collectionMapping;
    }

    protected MWMapping generateForMWDirectCollectionMapping(MWMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWRelationalDirectCollectionMapping collectionMapping = mapping instanceof MWRelationalDirectCollectionMapping ? (MWRelationalDirectCollectionMapping)mapping : (MWRelationalDirectCollectionMapping)mapping.asMWDirectCollectionMapping();
        this.mapDirectCollectionMapping(collectionMapping, attrAndItemType, sourceClass);
        return collectionMapping;
    }

    protected MWMapping generateForMWDirectToFieldMapping(MWMapping mapping, MWClass sourceClass) {
        MWDirectToFieldMapping dtfMapping = mapping instanceof MWDirectToFieldMapping ? (MWDirectToFieldMapping)mapping : (MWDirectToFieldMapping)mapping.asMWDirectMapping();
        this.mapDirectToFieldMapping(dtfMapping, sourceClass);
        return dtfMapping;
    }

    protected MWMapping generateForMWOneToOneMapping(MWMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWOneToOneMapping oneToOneMapping = mapping instanceof MWOneToOneMapping ? (MWOneToOneMapping)mapping : mapping.asMWOneToOneMapping();
        this.mapOneToOneMapping(oneToOneMapping, attrAndItemType, sourceClass);
        return oneToOneMapping;
    }

    protected MWMapping generateForCollectionMapping(MWMapping mapping, MWClass sourceClass) {
        ArrayList writtenFields = new ArrayList();
        mapping.addWrittenFieldsTo(writtenFields);
        if (!((MWRelationalDescriptor)mapping.getParentDescriptor()).isAggregateDescriptor() && writtenFields.size() > 0) {
            return mapping;
        }
        MWClass[] attrAndItemType = this.determineAttrAndItemType(mapping, false);
        MWClass attrType = attrAndItemType[this.ATTR_TYPE];
        MWClass itemType = attrAndItemType[this.ITEM_TYPE];
        if (mapping instanceof MWDirectCollectionMapping) {
            if (attrType == null) {
                attrType = attrAndItemType[this.ATTR_TYPE] = this.getProject().typeFor(Vector.class);
            }
            if (itemType == null) {
                itemType = attrAndItemType[this.ITEM_TYPE] = this.getProject().typeFor(String.class);
            }
        }
        if (attrType == null) {
            return null;
        }
        if (mapping instanceof MWAggregateMapping) {
            boolean mapCollectionMappings = true;
            this.mapAggregateMapping((MWAggregateMapping)mapping, attrAndItemType, sourceClass, mapCollectionMappings);
            return mapping;
        }
        if (itemType == null || itemType.isInterface()) {
            return null;
        }
        if (attrType.isAssignableToCollection()) {
            if (this.isDatabaseType(itemType)) {
                return this.generateForMWDirectCollectionMapping(mapping, attrAndItemType, sourceClass);
            }
            return this.generateForMWCollectionMapping(mapping, attrAndItemType, sourceClass);
        }
        return null;
    }

    protected MWMapping generateForNonCollectionMapping(MWMapping mapping, MWClass sourceClass) {
        ArrayList writtenFields = new ArrayList();
        mapping.addWrittenFieldsTo(writtenFields);
        if (!((MWRelationalDescriptor)mapping.getParentDescriptor()).isAggregateDescriptor() && writtenFields.size() > 0) {
            return mapping;
        }
        MWClass[] attrAndItemType = this.determineAttrAndItemType(mapping, true);
        MWClass attrType = attrAndItemType[this.ATTR_TYPE];
        if (attrType == null) {
            return null;
        }
        if (attrType.isAssignableToCollection() || attrType.isInterface()) {
            return null;
        }
        if (this.isDatabaseType(attrType)) {
            return this.generateForMWDirectToFieldMapping(mapping, sourceClass);
        }
        MWMappingDescriptor targetDescriptor = (MWMappingDescriptor)this.getProject().descriptorForType(attrType);
        if (targetDescriptor == null) {
            return null;
        }
        boolean targetDescriptorIsAggregate = ((MWRelationalDescriptor)targetDescriptor).isAggregateDescriptor();
        if (mapping instanceof MWAggregateMapping || targetDescriptorIsAggregate) {
            return this.generateForMWAggregateMapping(mapping, attrAndItemType, sourceClass);
        }
        return this.generateForMWOneToOneMapping(mapping, attrAndItemType, sourceClass);
    }

    protected static boolean generateIndexColumnsForDirectCollections() {
        return TableGenerator.directCollectionContentsAreUnsorted();
    }

    protected Collection getClassDescriptors() {
        return this.classDescriptors;
    }

    protected int getColumnNameLength() {
        return 30;
    }

    protected MWDatabase getDatabase() {
        return this.getProject().getDatabase();
    }

    protected MWTableDescriptor getDescriptorFor(MWClass bldrClass) {
        return (MWTableDescriptor)this.descriptorLookup.get(bldrClass);
    }

    protected static HashMap getPrimitiveToJavaTypeMap() {
        if (primitiveToJavaTypeMap == null) {
            TableGenerator.initializePrimitiveToJavaTypeMap();
        }
        return primitiveToJavaTypeMap;
    }

    protected MWRelationalProject getProject() {
        return this.project;
    }

    protected MWTable getRelationshipTableFor(MWClass aClass, MWClass anotherClass) {
        MWTable table = null;
        for (Collection classes : this.relationshipTableLookup.keySet()) {
            if (!classes.contains(aClass) || !classes.contains(anotherClass)) continue;
            table = (MWTable)this.relationshipTableLookup.get(classes);
            return table;
        }
        return null;
    }

    protected MWTable getTableFor(MWClass bldrClass) {
        return (MWTable)this.tableLookup.get(bldrClass);
    }

    protected int getTableNameLength() {
        return 30;
    }

    protected static void initializePrimitiveToJavaTypeMap() {
        primitiveToJavaTypeMap = new HashMap();
        primitiveToJavaTypeMap.put("byte", "java.lang.Byte");
        primitiveToJavaTypeMap.put("short", "java.lang.Short");
        primitiveToJavaTypeMap.put("int", "java.lang.Integer");
        primitiveToJavaTypeMap.put("char", "java.lang.Character");
        primitiveToJavaTypeMap.put("long", "java.lang.Long");
        primitiveToJavaTypeMap.put("double", "java.lang.Double");
        primitiveToJavaTypeMap.put("float", "java.lang.Float");
        primitiveToJavaTypeMap.put("boolean", "java.lang.Boolean");
    }

    protected boolean isByteArray(MWClassAttribute attribute) {
        return attribute.getType().isBytePrimitive() && attribute.getDimensionality() == 1;
    }

    protected boolean isDatabaseType(MWClass type) {
        if (type == null) {
            return false;
        }
        return this.getDatabase().getDatabasePlatform().javaTypeDeclarationCanBeMappedToDatabaseType(type.getName(), 0);
    }

    protected MWTableDescriptor locateDescriptorFor(MWClass bldrClass) {
        if (bldrClass == null) {
            return null;
        }
        MWTableDescriptor descriptor = this.getDescriptorFor(bldrClass);
        if (descriptor != null) {
            return descriptor;
        }
        return (MWTableDescriptor)this.getProject().descriptorForType(bldrClass);
    }

    protected void logAssumption(String errorMessage) {
        this.log.add(new MWError("TABLE_GENERATOR_ASSUMPTION", (Object)errorMessage));
    }

    protected void logError(String errorMessage) {
        this.log.add(new MWError("TABLE_GENERATOR_ERROR", (Object)errorMessage));
    }

    protected void logNotify(String errorMessage) {
        this.log.add(new MWError("TABLE_GENERATOR_WARNING", (Object)errorMessage));
    }

    protected void logUrgent(String errorMessage) {
        this.log.add(new MWError("TABLE_GENERATOR_URGENT", (Object)errorMessage));
    }

    protected void mapAggregateMapping(MWAggregateMapping aggMapping, MWClass[] attrAndItemType, MWClass sourceClass, boolean mapCollectionMappings) {
        MWMappingDescriptor descriptor = (MWMappingDescriptor)aggMapping.getReferenceDescriptor();
        if (descriptor == null) {
            descriptor = (MWMappingDescriptor)this.getProject().descriptorForType(attrAndItemType[this.ATTR_TYPE]);
        }
        Iterator stream = descriptor.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            if (mapCollectionMappings) {
                this.generateForCollectionMapping(mapping, sourceClass);
                continue;
            }
            this.generateForNonCollectionMapping(mapping, sourceClass);
        }
    }

    protected void mapDirectCollectionMapping(MWRelationalDirectCollectionMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWClassAttribute attribute = mapping.getInstanceVariable();
        MWClass itemClass = attrAndItemType[this.ITEM_TYPE];
        MWClass attrClass = attrAndItemType[this.ATTR_TYPE];
        String assumptions = new String();
        int length = this.getTableNameLength() / 2 - 1;
        String proposedName = sourceClass.defaultTableNameWithLength(length) + "_TO_" + itemClass.defaultTableNameWithLength(length);
        MWTable table = this.getDatabase().addTable(this.newTableName(proposedName));
        HashMap columnNames = this.copyPrimaryKeyColumns(this.getTableFor(sourceClass), table);
        MWColumn column = this.createColumn(attribute.getName(), itemClass.getName(), 0, table);
        if (TableGenerator.directCollectionsHaveUniqueEntries()) {
            assumptions = this.resourceRepository().getString("isUnique", new Object[]{assumptions});
        }
        this.logAssumption(this.resourceRepository().getString("directCollectionHasEntries", new Object[]{sourceClass.shortName(), attribute.getName(), assumptions}));
        mapping.setDirectValueColumn(column);
        mapping.getContainerPolicy().getDefaultingContainerClass().setContainerClass(attrClass);
        mapping.setUsesMethodAccessing(this.getProject().getDefaultsPolicy().isMethodAccessing());
        MWReference reference = this.createReferenceIfAbsent(table, this.getTableFor(sourceClass), columnNames);
        mapping.setReference(reference);
    }

    protected void mapDirectToFieldMapping(MWDirectToFieldMapping mapping, MWClass sourceClass) {
        MWClassAttribute attribute = mapping.getInstanceVariable();
        MWTable table = this.getTableFor(sourceClass);
        MWColumn column = this.createColumn(attribute.getName(), attribute.typeName(), 0, table);
        if (!((MWRelationalDescriptor)mapping.getParentDescriptor()).isAggregateDescriptor()) {
            mapping.setColumn(column);
        }
    }

    protected void mapManyToManyMapping(MWManyToManyMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWTable sourceTable = this.getTableFor(sourceClass);
        if (sourceTable == null) {
            return;
        }
        MWClass itemClass = attrAndItemType[this.ITEM_TYPE];
        MWTableDescriptor itemDescriptor = this.locateDescriptorFor(itemClass);
        if (itemDescriptor == null) {
            this.logError(this.resourceRepository().getString("couldNotFindMapping", new Object[]{mapping.getName(), sourceClass.shortName(), itemClass.getName()}));
            return;
        }
        MWTable itemTable = itemDescriptor.getPrimaryTable();
        if (itemTable == null) {
            this.logError(this.resourceRepository().getString("descriptorDoesNotHaveAPrimaryTable", new Object[]{itemDescriptor.getMWClass().shortName()}));
            return;
        }
        HashMap sourceKeyNames = null;
        HashMap itemKeyNames = null;
        MWTable joinTable = this.getRelationshipTableFor(sourceClass, itemClass);
        if (joinTable == null) {
            int length = this.getTableNameLength() / 2 - 1;
            String proposedName = sourceClass.defaultTableNameWithLength(length) + "_TO_" + itemClass.defaultTableNameWithLength(length);
            joinTable = this.getDatabase().addTable(this.newTableName(proposedName));
            sourceKeyNames = this.copyPrimaryKeyColumns(sourceTable, joinTable);
            itemKeyNames = this.copyPrimaryKeyColumns(itemTable, joinTable);
            this.registerRelationshipTable(joinTable, sourceClass, itemClass);
        }
        mapping.setRelationTable(joinTable);
        String nameOfReference = joinTable.getName() + "_" + sourceTable.getName();
        MWReference sourceReference = this.createReferenceIfAbsent(joinTable, sourceTable, sourceKeyNames);
        mapping.setSourceReference(sourceReference);
        nameOfReference = joinTable.getName() + "_" + itemTable.getName();
        MWReference targetReference = this.createReferenceIfAbsent(joinTable, itemTable, itemKeyNames);
        mapping.setTargetReference(targetReference);
        mapping.setReferenceDescriptor((MWDescriptor)itemDescriptor);
    }

    protected void mapOneToManyMapping(MWOneToManyMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWClass itemClass = attrAndItemType[this.ITEM_TYPE];
        if (itemClass.isInterface()) {
            return;
        }
        MWTableDescriptor itemDescriptor = this.locateDescriptorFor(itemClass);
        if (itemDescriptor.getPrimaryTable() == null) {
            this.logError(this.resourceRepository().getString("couldNotFindMapping", new Object[]{mapping.getName(), sourceClass.shortName(), itemClass.getName()}));
            return;
        }
        MWOneToOneMapping backMapping = this.backpointerFor((MWMapping)mapping, attrAndItemType, sourceClass);
        if (backMapping == null) {
            this.logUrgent(this.resourceRepository().getString("thereIsNoOneToOneBackpointer", new Object[]{mapping.getName(), sourceClass.shortName()}));
            return;
        }
        MWReference reference = backMapping.getReference();
        if (reference == null || reference.columnPairsSize() == 0) {
            this.logUrgent(this.resourceRepository().getString("errorMapOneToManyMapping"));
            return;
        }
        mapping.setReference(backMapping.getReference());
        mapping.setReferenceDescriptor((MWDescriptor)itemDescriptor);
    }

    protected void mapOneToOneMapping(MWOneToOneMapping mapping, MWClass[] attrAndItemType, MWClass sourceClass) {
        MWTableDescriptor sourceDescriptor = this.getDescriptorFor(sourceClass);
        MWTable sourceTable = this.getTableFor(sourceClass);
        MWClass foreignClass = attrAndItemType[this.ATTR_TYPE];
        MWTableDescriptor targetDescriptor = (MWTableDescriptor)this.getProject().descriptorForType(foreignClass);
        if (targetDescriptor == null) {
            this.logError(this.resourceRepository().getString("couldNotFindMapping", new Object[]{mapping.getName(), sourceDescriptor.getName(), foreignClass.getName()}));
            return;
        }
        mapping.setUsesMethodAccessing(this.getProject().getDefaultsPolicy().isMethodAccessing());
        MWTable targetTable = targetDescriptor.getPrimaryTable();
        if (targetTable != null && targetTable.columnsSize() > 0) {
            String referenceName = sourceTable.getName() + "_" + targetTable.getName();
            MWReference reference = sourceTable.referenceNamed(referenceName);
            if (reference == null) {
                reference = sourceTable.addReference(referenceName, targetTable);
            }
            Iterator stream = targetTable.primaryKeyColumns();
            while (stream.hasNext()) {
                MWColumn foreignColumn = (MWColumn)stream.next();
                MWColumn column = this.createColumn(mapping.getName(), sourceTable, foreignColumn);
                reference.addColumnPair(column, foreignColumn);
            }
            mapping.setReference(reference);
        }
        mapping.setReferenceDescriptor((MWDescriptor)targetDescriptor);
    }

    protected String mungeName(String aString) {
        int startOfNumber;
        if (aString == null || aString == "") {
            return "1";
        }
        if (!Character.isDigit(aString.charAt(aString.length() - 1))) {
            return aString + "1";
        }
        for (startOfNumber = aString.length() - 1; startOfNumber >= 0; --startOfNumber) {
            if (Character.isDigit(aString.charAt(startOfNumber))) continue;
            ++startOfNumber;
            break;
        }
        String oldNumberString = aString.substring(startOfNumber);
        int number = Integer.parseInt(oldNumberString);
        String newNumberString = String.valueOf(number + 1);
        return aString.substring(0, startOfNumber) + newNumberString;
    }

    protected String newColumnName(MWTable aTable, String proposedString) {
        String newString = proposedString.replace('$', '_');
        String columnName = StringTools.convertCamelBackToAllCaps((String)newString, (int)this.getColumnNameLength());
        while (aTable.columnNamed(columnName) != null) {
            columnName = this.mungeName(columnName);
        }
        return columnName;
    }

    protected String newTableName(String proposedString) {
        String tableName = proposedString.replace('$', '_');
        while (this.getDatabase().containsTableNamed(tableName)) {
            tableName = this.mungeName(tableName);
        }
        return tableName;
    }

    protected void registerRelationshipTable(MWTable aTable, MWClass aClass, MWClass anotherClass) {
        ArrayList<MWClass> classes = new ArrayList<MWClass>();
        classes.add(aClass);
        classes.add(anotherClass);
        this.relationshipTableLookup.put(classes, aTable);
    }

    protected void setClassDescriptors(Collection classDescriptors) {
        this.classDescriptors = classDescriptors;
    }

    protected void setProject(MWRelationalProject project) {
        this.project = project;
    }

    protected Collection sortTableDescriptors(Collection aCollection) {
        ArrayList dependsOn;
        MWTableDescriptor descriptor;
        ArrayList<MWTableDescriptor> orderedList = new ArrayList<MWTableDescriptor>();
        ArrayList nonClassDescriptors = new ArrayList();
        for (Object desc : aCollection) {
            if (desc instanceof MWTableDescriptor) continue;
            nonClassDescriptors.add(desc);
        }
        aCollection.removeAll(nonClassDescriptors);
        HashMap<MWClass, ArrayList> dependencyList = new HashMap<MWClass, ArrayList>();
        int count = 0;
        Iterator descriptors = aCollection.iterator();
        while (descriptors.hasNext()) {
            ++count;
            descriptor = (MWTableDescriptor)descriptors.next();
            MWClass bldrClass = descriptor.getMWClass();
            this.descriptorLookup.put(bldrClass, descriptor);
            MWTableDescriptor foundDependency = null;
            for (MWTableDescriptor descriptor2 : aCollection) {
                if (descriptor2.getMWClass() != bldrClass.getSuperclass()) continue;
                foundDependency = descriptor2;
                break;
            }
            dependsOn = new ArrayList(1);
            if (foundDependency != null) {
                dependsOn.add(bldrClass.getSuperclass());
            }
            dependencyList.put(bldrClass, dependsOn);
        }
        while (!dependencyList.isEmpty()) {
            MWClass current = null;
            for (MWClass bldrClass : dependencyList.keySet()) {
                ArrayList dependsOn2 = (ArrayList)dependencyList.get(bldrClass);
                if (!dependsOn2.isEmpty()) continue;
                current = bldrClass;
            }
            if (current == null) {
                throw new RuntimeException(this.resourceRepository().getString("errorCyclicDependency"));
            }
            descriptor = this.getDescriptorFor(current);
            orderedList.add(descriptor);
            dependencyList.remove(current);
            for (MWClass bldrClass : dependencyList.keySet()) {
                dependsOn = (ArrayList)dependencyList.get(bldrClass);
                dependsOn.remove(current);
            }
        }
        return orderedList;
    }

    private ResourceRepository resourceRepository() {
        return this.workbenchContext.getApplicationContext().getResourceRepository();
    }
}

