/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerEditingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

public final class AttributeTransformerPanel
extends AbstractSubjectPanel {
    public AttributeTransformerPanel(ValueModel transformationMappingHolder, WorkbenchContextHolder contextHolder) {
        super(transformationMappingHolder, contextHolder);
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = this.buildAttributeTransformerLabel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)label, constraints);
        this.addAlignLeft(label);
        Component component = this.buildAttributeTransformerComponent();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add(component, constraints);
        JButton button = this.buildAttributeTransformerEditButton();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)button, constraints);
        this.addAlignRight(button);
        label.setLabelFor(button);
        SwingComponentFactory.updateButtonAccessibleName(label, button);
        this.addHelpTopicId(this, "mapping.transformation.attributeTransformer");
    }

    private JLabel buildAttributeTransformerLabel() {
        return SwingComponentFactory.buildLabel("ATTRIBUTE_TRANSFORMER_LABEL", this.resourceRepository());
    }

    private Component buildAttributeTransformerComponent() {
        JList list = SwingComponentFactory.buildList(this.buildAttributeTransformerListModel());
        list.setCellRenderer(this.buildTransformerListCellRenderer());
        list.setDoubleBuffered(true);
        list.setVisibleRowCount(1);
        list.setPreferredSize(new Dimension(0, 0));
        return new JScrollPane(list, 21, 31);
    }

    private ListModel buildAttributeTransformerListModel() {
        return new ListModelAdapter(this.buildAttributeTransformerCollectionValue());
    }

    private CollectionValueModel buildAttributeTransformerCollectionValue() {
        return new PropertyCollectionValueModelAdapter(this.buildAttributeTransformerPropertyValue());
    }

    private PropertyValueModel buildAttributeTransformerPropertyValue() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "attributeTransformer"){

            protected Object getValueFromSubject() {
                return ((MWTransformationMapping)this.subject).getAttributeTransformer();
            }
        };
    }

    private ListCellRenderer buildTransformerListCellRenderer() {
        return new AdaptableListCellRenderer(new TransformerCellRendererAdapter(this.resourceRepository()));
    }

    private JButton buildAttributeTransformerEditButton() {
        JButton button = new JButton(this.resourceRepository().getString("ATTRIBUTE_TRANSFORMER_EDIT_BUTTON"));
        button.addActionListener(this.buildAttributeTransformerEditAction());
        return button;
    }

    private ActionListener buildAttributeTransformerEditAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MWTransformationMapping transformationMapping = (MWTransformationMapping)AttributeTransformerPanel.this.subject();
                WorkbenchContext context = AttributeTransformerPanel.this.getWorkbenchContext();
                TransformerEditingDialog.promptToEditAttributeTransformer(transformationMapping, context);
            }
        };
    }
}

