/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta;

import java.awt.Dialog;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.UiMetaBundle;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ExternalClassLoadFailuresDialog
extends StatusDialog {
    public ExternalClassLoadFailuresDialog(WorkbenchContext context, ExternalClassLoadFailureContainer failures) {
        super(context.buildExpandedResourceRepositoryContext(UiMetaBundle.class), ExternalClassLoadFailuresDialog.buildStatus(failures), "ERROR_IMPORTING_CLASSES.TITLE", "CLASSES_COMPILED_AND_ON_CLASSPATH_ERROR_MESSAGE", "dialog.classesNotFound");
    }

    public ExternalClassLoadFailuresDialog(WorkbenchContext context, Dialog owner, ExternalClassLoadFailureContainer failures) {
        super(context.buildExpandedResourceRepositoryContext(UiMetaBundle.class), owner, ExternalClassLoadFailuresDialog.buildStatus(failures), "ERROR_IMPORTING_CLASSES.TITLE", "CLASSES_COMPILED_AND_ON_CLASSPATH_ERROR_MESSAGE", "dialog.classesNotFound");
    }

    private static Collection buildStatus(ExternalClassLoadFailureContainer failures) {
        SortedSet failureClassNames = CollectionTools.sortedSet((Iterator)failures.failureClassNames());
        Vector<StatusDialog.Status> statusList = new Vector<StatusDialog.Status>(failureClassNames.size());
        Iterator iter = failureClassNames.iterator();
        while (iter.hasNext()) {
            Vector<Error> errors = new Vector<Error>();
            String className = (String)iter.next();
            Throwable cause = failures.failureForClassNamed(className);
            errors.add(new Error(cause));
            while (cause.getCause() != null) {
                if ((cause = cause.getCause()) instanceof NullPointerException || cause.getLocalizedMessage() == null) continue;
                errors.add(new Error(cause));
            }
            StatusDialog.Status status = StatusDialog.createStatus((Object)className, errors);
            statusList.add(status);
        }
        return statusList;
    }

    protected CellRendererAdapter buildNodeRenderer(Object value) {
        if (value instanceof String) {
            return new ClassNameCellRendererAdapter();
        }
        if (value instanceof Error) {
            return new ErrorCellRendererAdapter();
        }
        return super.buildNodeRenderer(value);
    }

    private class ErrorCellRendererAdapter
    extends AbstractCellRendererAdapter {
        private ErrorCellRendererAdapter() {
        }

        public Icon buildIcon(Object value) {
            return ExternalClassLoadFailuresDialog.this.resourceRepository().getIcon("error");
        }

        public String buildText(Object value) {
            return ((Error)value).getErrorMessage(ExternalClassLoadFailuresDialog.this.resourceRepository());
        }
    }

    private static class Error {
        private final Throwable error;
        private String errorMessage;

        Error(Throwable error) {
            this.error = error;
        }

        private String buildErrorMessage(StringRepository repository) {
            if (this.error instanceof ExternalClassNotFoundException) {
                return repository.getString("ERROR_IMPORTING_CLASSES_ERROR_MESSAGE_CLASS_NOT_FOUND");
            }
            if (this.error instanceof InterfaceDescriptorCreationException) {
                return repository.getString("ERROR_IMPORTING_CLASSES_ERROR_MESSAGE_INTERFACE");
            }
            if (this.error instanceof IOException) {
                return repository.getString("ERROR_IMPORTING_CLASSES_ERROR_MESSAGE_IO", this.error.getLocalizedMessage());
            }
            if (this.error.getLocalizedMessage() != null) {
                return this.error.getLocalizedMessage();
            }
            return this.error.toString();
        }

        public String getErrorMessage(StringRepository repository) {
            if (this.errorMessage == null) {
                this.errorMessage = this.buildErrorMessage(repository);
            }
            return this.errorMessage;
        }
    }

    protected class ClassNameCellRendererAdapter
    extends AbstractCellRendererAdapter {
        protected ClassNameCellRendererAdapter() {
        }

        public Icon buildIcon(Object value) {
            return ExternalClassLoadFailuresDialog.this.resourceRepository().getIcon("class.public");
        }

        public String buildText(Object value) {
            String className = (String)value;
            if (className.indexOf(".") == -1) {
                return className + " " + ExternalClassLoadFailuresDialog.this.resourceRepository().getString("DEFAULT_PACKAGE");
            }
            return ClassTools.shortNameForClassNamed((String)className) + " (" + ClassTools.packageNameForClassNamed((String)className) + ")";
        }
    }
}

