/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgumentElement;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeModel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

abstract class AttributeItemDialog
extends AbstractDialog {
    private MWQuery query;
    private MWAttributeItem attributeItem;
    private QueryableTree queryableTree;
    private Filter traversableFilter;
    private Filter chooseableFilter;

    AttributeItemDialog(MWQuery query, MWAttributeItem attributeItem, Filter traversableFilter, Filter chooseableFilter, WorkbenchContext context) {
        super(context);
        this.query = query;
        this.attributeItem = attributeItem;
        this.traversableFilter = traversableFilter;
        this.chooseableFilter = chooseableFilter;
        this.getOKAction().setEnabled(false);
    }

    AttributeItemDialog(MWQuery query, MWAttributeItem attributeItem, WorkbenchContext context) {
        this(query, attributeItem, null, null, context);
        this.traversableFilter = this.buildTraversableFilter();
        this.chooseableFilter = this.buildChooseableFilter();
    }

    protected Filter buildTraversableFilter() {
        return Filter.NULL_INSTANCE;
    }

    protected Filter buildChooseableFilter() {
        return Filter.NULL_INSTANCE;
    }

    protected abstract String titleKey();

    protected abstract String editTitleKey();

    private MWMappingDescriptor getDescriptor() {
        return this.query.getOwningDescriptor();
    }

    protected MWQuery getQuery() {
        return this.query;
    }

    protected MWAttributeItem getAttributeItem() {
        return this.attributeItem;
    }

    protected QueryableTree getQueryableTree() {
        return this.queryableTree;
    }

    protected void initializeContentPane() {
        super.initializeContentPane();
        if (this.attributeItem != null) {
            this.initializeEditMode(this.attributeItem);
            this.setTitle(this.resourceRepository().getString(this.editTitleKey()));
        } else {
            this.setTitle(this.resourceRepository().getString(this.titleKey()));
        }
    }

    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JScrollPane scrollPane = new JScrollPane(this.buildQueryableTree());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)scrollPane, constraints);
        return panel;
    }

    protected QueryableTree buildQueryableTree() {
        this.queryableTree = new QueryableTree(this.buildQueryableTreeModel(), this.getWorkbenchContext());
        this.queryableTree.addTreeSelectionListener(this.buildTreeSelectionHandler());
        SwingComponentFactory.addDoubleClickMouseListener(this.queryableTree, new DoubleClickMouseListener(){

            public void mouseDoubleClicked(MouseEvent e) {
                TreePath path = AttributeItemDialog.this.queryableTree.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    AttributeItemDialog.this.clickOK();
                }
            }
        });
        return this.queryableTree;
    }

    protected QueryableTreeModel buildQueryableTreeModel() {
        return new QueryableTreeModel(new DefaultMutableTreeNode(this.getDescriptor()), this.traversableFilter);
    }

    protected void initializeEditMode(MWAttributeItem attributeItem) {
        MWQueryableArgumentElement element = attributeItem.getQueryableArgument().getQueryableArgumentElement();
        if (element.getQueryable() != null && this.chooseableFilter.accept((Object)element.getQueryable())) {
            this.queryableTree.setSelectedQueryableArgumentElement(attributeItem.getQueryableArgument().getQueryableArgumentElement());
        }
        this.setTitle(this.resourceRepository().getString(this.titleKey()));
    }

    private TreeSelectionListener buildTreeSelectionHandler() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AttributeItemDialog.this.treeSelectionChanged(e);
            }
        };
    }

    protected void treeSelectionChanged(TreeSelectionEvent e) {
        this.updateOKButton();
    }

    protected void updateOKButton() {
        boolean selected;
        boolean bl = selected = this.queryableTree.getSelectionCount() > 0;
        if (selected) {
            QueryableTreeNode selectedNode = (QueryableTreeNode)this.queryableTree.getSelectionPath().getLastPathComponent();
            this.getOKAction().setEnabled(this.chooseableFilter.accept((Object)selectedNode.getQueryable()));
        } else {
            this.getOKAction().setEnabled(false);
        }
    }

    protected void cancelPressed() {
        ((DefaultMutableTreeNode)this.queryableTree.getModel().getRoot()).removeAllChildren();
        super.cancelPressed();
    }

    protected boolean preConfirm() {
        TreePath selectionPath = this.queryableTree.getSelectionPath();
        ArrayList<MWQueryable> queryablePath = new ArrayList<MWQueryable>();
        ArrayList<Boolean> allowsNull = new ArrayList<Boolean>();
        QueryableTreeNode selectedNode = (QueryableTreeNode)selectionPath.getLastPathComponent();
        allowsNull.add(selectedNode.isAllowsNull());
        MWQueryable queryableObject = selectedNode.getQueryable();
        queryablePath.add(queryableObject);
        selectionPath = selectionPath.getParentPath();
        while (selectionPath.getPathCount() > 1) {
            selectedNode = (QueryableTreeNode)selectionPath.getLastPathComponent();
            allowsNull.add(new Boolean(selectedNode.isAllowsNull()));
            MWQueryable joinedQueryable = selectedNode.getQueryable();
            queryablePath.add(joinedQueryable);
            selectionPath = selectionPath.getParentPath();
        }
        int index = this.attributeItemsSize();
        if (this.attributeItem != null) {
            index = this.indexOfAttributeItem(this.attributeItem);
            this.removeAttributeItem(index);
        }
        this.addAttributeItem(index, queryablePath.iterator(), allowsNull.iterator());
        ((DefaultMutableTreeNode)this.queryableTree.getModel().getRoot()).removeAllChildren();
        return super.preConfirm();
    }

    protected abstract int attributeItemsSize();

    protected abstract int indexOfAttributeItem(MWAttributeItem var1);

    protected abstract void removeAttributeItem(int var1);

    protected abstract void addAttributeItem(int var1, Iterator var2, Iterator var3);
}

