/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JNDINamingServiceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;

public abstract class TransportManagerAdapter
extends SCAdapter {
    public static final String ON_CONNECTION_ERROR_PROPERTY = "onConnectionErrorConfig";
    private static final String DISCARD_CONNECTION = "DiscardConnection";
    private static final String KEEP_CONNECTION = "KeepConnection";

    TransportManagerAdapter(SCAdapter parent, TransportManagerConfig scConfig) {
        super(parent, scConfig);
    }

    protected TransportManagerAdapter(SCAdapter parent) {
        super(parent);
    }

    private final TransportManagerConfig transportManager() {
        return (TransportManagerConfig)this.getModel();
    }

    protected JNDINamingServiceAdapter buildJNDINamingService() {
        return new JNDINamingServiceAdapter(this);
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setRemoveConnectionOnError();
    }

    public boolean removeConnectionOnError() {
        String value = this.transportManager().getOnConnectionError();
        return value != null && value.equalsIgnoreCase(DISCARD_CONNECTION);
    }

    public void setRemoveConnectionOnError(boolean remove) {
        if (remove) {
            this.setRemoveConnectionOnError();
        } else {
            this.setKeepConnectionOnError();
        }
    }

    private void setRemoveConnectionOnError() {
        this.setOnConnectionError(DISCARD_CONNECTION);
    }

    private void setKeepConnectionOnError() {
        this.setOnConnectionError(KEEP_CONNECTION);
    }

    private void setOnConnectionError(String remove) {
        String old = this.transportManager().getOnConnectionError();
        this.transportManager().setOnConnectionError(remove);
        this.firePropertyChanged(ON_CONNECTION_ERROR_PROPERTY, old, remove);
    }
}

