/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class EventListenersPane
extends AbstractSubjectPanel {
    public EventListenersPane(PropertyValueModel sessionAdapterHolder, WorkbenchContextHolder contextHolder) {
        super((LayoutManager)new BorderLayout(), (ValueModel)sessionAdapterHolder, contextHolder);
        this.addHelpTopicId(this, "session.options.eventListeners");
    }

    private AddRemovePanel.Adapter buildAddRemoveListPanelAdapter() {
        return new AddRemoveListAdapter();
    }

    private ListValueModel buildEventListenerListHolder() {
        return new ListAspectAdapter(this.getSubjectHolder(), "sessionEventListeners"){

            protected ListIterator getValueFromSubject() {
                SessionAdapter adapter = (SessionAdapter)this.subject;
                return adapter.sessionEventListenerConfigs();
            }
        };
    }

    private AddRemoveListPanel buildEventListenerListPane() {
        return new CustomizedAddRemoveListPanel();
    }

    protected void initializeLayout() {
        AddRemoveListPanel eventListenersListPanel = this.buildEventListenerListPane();
        eventListenersListPanel.setCellRenderer(new SimpleListCellRenderer());
        eventListenersListPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("OPTIONS_EVENT_LISTENERS_LIST"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)eventListenersListPanel, "Center");
        this.addPaneForAlignment(eventListenersListPanel);
    }

    private class CustomizedAddRemoveListPanel
    extends AddRemoveListPanel {
        private CustomizedAddRemoveListPanel() {
            super(EventListenersPane.this.getApplicationContext(), EventListenersPane.this.buildAddRemoveListPanelAdapter(), EventListenersPane.this.buildEventListenerListHolder(), 3);
        }

        protected String addButtonKey() {
            return "OPTIONS_EVENT_LISTENERS_ADD_BUTTON";
        }

        protected void buildButtonPanel(JComponent buttonPanel, JButton addButton, JButton removeButton, JButton optionalButton) {
            buttonPanel.add(addButton);
            buttonPanel.add(removeButton);
        }

        protected String removeButtonKey() {
            return "OPTIONS_EVENT_LISTENERS_REMOVE_BUTTON";
        }
    }

    private class AddRemoveListAdapter
    implements AddRemovePanel.Adapter {
        private AddRemoveListAdapter() {
        }

        public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            SessionAdapter session = (SessionAdapter)EventListenersPane.this.subject();
            SimplePropertyValueModel selectionHolder = new SimplePropertyValueModel();
            ClassChooserTools.promptForType(EventListenersPane.this.getWorkbenchContext(), session.getClassRepository(), selectionHolder);
            String eventListenerClassName = (String)selectionHolder.getValue();
            if (eventListenerClassName != null && !CollectionTools.contains((Iterator)session.sessionEventListenerConfigs(), (Object)eventListenerClassName)) {
                session.addPropertyConfigNamed(eventListenerClassName);
            }
        }

        public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            SessionAdapter adapter = (SessionAdapter)EventListenersPane.this.subject();
            Object[] selectedValues = listSelectionModel.getSelectedValues();
            int index = selectedValues.length;
            while (--index >= 0) {
                adapter.removePropertyConfigNamed((String)selectedValues[index]);
            }
        }
    }
}

