/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public abstract class CollectionAspectAdapter
extends AspectAdapter
implements CollectionValueModel {
    protected String collectionName;
    protected CollectionChangeListener collectionChangeListener;

    protected CollectionAspectAdapter(String collectionName, Model subject) {
        super(subject);
        this.collectionName = collectionName;
    }

    protected CollectionAspectAdapter(ValueModel subjectHolder, String collectionName) {
        super(subjectHolder);
        this.collectionName = collectionName;
    }

    protected CollectionAspectAdapter(ValueModel subjectHolder) {
        this(subjectHolder, null);
    }

    protected void initialize() {
        super.initialize();
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CollectionAspectAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CollectionAspectAdapter.this.itemsRemoved(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionAspectAdapter.this.collectionChanged(e);
            }

            public String toString() {
                return "collection change listener: " + CollectionAspectAdapter.this.collectionName;
            }
        };
    }

    public Object getValue() {
        if (this.subject == null) {
            return NullIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected Iterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    public void addItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection items) {
        Iterator stream = items.iterator();
        while (stream.hasNext()) {
            this.addItem(stream.next());
        }
    }

    public void removeItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection items) {
        Iterator stream = items.iterator();
        while (stream.hasNext()) {
            this.removeItem(stream.next());
        }
    }

    public int size() {
        return this.subject == null ? 0 : this.sizeFromSubject();
    }

    protected int sizeFromSubject() {
        return CollectionTools.size((Iterator)((Iterator)this.getValue()));
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("value");
    }

    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireCollectionChanged("value");
    }

    protected void engageNonNullSubject() {
        if (this.collectionName != null) {
            ((Model)this.subject).addCollectionChangeListener(this.collectionName, this.collectionChangeListener);
        }
    }

    protected void disengageNonNullSubject() {
        if (this.collectionName != null) {
            ((Model)this.subject).removeCollectionChangeListener(this.collectionName, this.collectionChangeListener);
        }
    }

    public void toString(StringBuffer sb) {
        sb.append(this.collectionName);
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.fireItemsAdded(e.cloneWithSource((Object)this, "value"));
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        this.fireItemsRemoved(e.cloneWithSource((Object)this, "value"));
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        this.fireCollectionChanged("value");
    }
}

