/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public abstract class TreeAspectAdapter
extends AspectAdapter
implements TreeValueModel {
    protected String treeName;
    protected TreeChangeListener treeChangeListener;

    protected TreeAspectAdapter(String treeName, Model subject) {
        super(subject);
        this.treeName = treeName;
    }

    protected TreeAspectAdapter(ValueModel subjectHolder, String treeName) {
        super(subjectHolder);
        this.treeName = treeName;
    }

    protected void initialize() {
        super.initialize();
        this.treeChangeListener = this.buildTreeChangeListener();
    }

    protected TreeChangeListener buildTreeChangeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeChangeEvent e) {
                TreeAspectAdapter.this.nodeAdded(e);
            }

            public void nodeRemoved(TreeChangeEvent e) {
                TreeAspectAdapter.this.nodeRemoved(e);
            }

            public void treeChanged(TreeChangeEvent e) {
                TreeAspectAdapter.this.treeChanged(e);
            }

            public String toString() {
                return "tree change listener: " + TreeAspectAdapter.this.treeName;
            }
        };
    }

    public Object getValue() {
        if (this.subject == null) {
            return NullIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected Iterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    public void addNode(Object[] parentPath, Object node) {
        throw new UnsupportedOperationException();
    }

    public void removeNode(Object[] path) {
        throw new UnsupportedOperationException();
    }

    protected boolean hasListeners() {
        return this.hasAnyTreeChangeListeners("value");
    }

    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireTreeStructureChanged("value");
    }

    protected void engageNonNullSubject() {
        ((Model)this.subject).addTreeChangeListener(this.treeName, this.treeChangeListener);
    }

    protected void disengageNonNullSubject() {
        ((Model)this.subject).removeTreeChangeListener(this.treeName, this.treeChangeListener);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.treeName);
    }

    protected void nodeAdded(TreeChangeEvent e) {
        this.fireNodeAdded("value", e.getPath());
    }

    protected void nodeRemoved(TreeChangeEvent e) {
        this.fireNodeRemoved("value", e.getPath());
    }

    protected void treeChanged(TreeChangeEvent e) {
        this.fireTreeStructureChanged("value", e.getPath());
    }
}

