/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;

public class Util {
    public static final String CLASSES = "classes";
    public static final String DEFAULT_WSDL_LOCATION_URI = "REPLACE_WITH_ENDPOINT_ADDRESS";
    public static final String SWAREF_FILENAME;
    public static final String WSI_SWAREF_XSD_FILE;
    public static final String WEB_XML_FILENAME = "web.xml";
    public static final String DEFAULT_PLATFORM_CLASSNAME = "org.eclipse.persistence.platform.database.OraclePlatform";
    public static final String UNDER_DBWS = "_dbws";
    public static final String WSI_SWAREF = "swaRef";
    public static final String WSI_SWAREF_PREFIX = "ref";
    public static final String WSI_SWAREF_URI = "http://ws-i.org/profiles/basic/1.1/xsd";
    public static final String PK_QUERYNAME = "findByPrimaryKey";
    public static final String THE_INSTANCE_NAME = "theInstance";
    public static final String FINDALL_QUERYNAME = "findAll";
    public static final String CREATE_OPERATION_NAME = "create";
    public static final String UPDATE_OPERATION_NAME = "update";
    public static final String REMOVE_OPERATION_NAME = "delete";
    public static final String DBWS_PROVIDER_PACKAGE = "_dbws";
    public static final String DBWS_PROVIDER_NAME = "DBWSProvider";
    public static final String DOT_CLASS = ".class";
    static final String DOT_JAVA = ".java";
    public static final String DBWS_PROVIDER_CLASS_FILE = "DBWSProvider.class";
    public static final String DBWS_PROVIDER_SOURCE_FILE = "DBWSProvider.java";
    static final String PROVIDER_LISTENER = "ProviderListener";
    public static final String PROVIDER_LISTENER_CLASS_FILE = "ProviderListener.class";
    public static final String PROVIDER_LISTENER_SOURCE_FILE = "ProviderListener.java";
    public static final QName SXF_QNAME_CURSOR;

    public static QName getXMLTypeFromJDBCType(Short jdbcType) {
        return Util.getXMLTypeFromJDBCType(jdbcType.intValue());
    }

    public static QName getXMLTypeFromJDBCType(int jdbcType) {
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return XMLConstants.STRING_QNAME;
            }
            case -5: {
                return XMLConstants.INTEGER_QNAME;
            }
            case -6: 
            case 4: 
            case 5: {
                return XMLConstants.INT_QNAME;
            }
            case 3: {
                return XMLConstants.DECIMAL_QNAME;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return XMLConstants.DOUBLE_QNAME;
            }
            case 91: {
                return XMLConstants.DATE_QNAME;
            }
            case 92: {
                return XMLConstants.TIME_QNAME;
            }
            case 93: {
                return XMLConstants.DATE_TIME_QNAME;
            }
        }
        return XMLConstants.BASE_64_BINARY_QNAME;
    }

    public static QName qNameFromString(String qNameAsString, Schema schema) {
        QName qName = null;
        String nsURI = null;
        String prefix = null;
        String localPart = null;
        if (qNameAsString != null) {
            if (qNameAsString.charAt(0) == '{') {
                int endOfNamespaceURI = qNameAsString.indexOf(125);
                if (endOfNamespaceURI == -1) {
                    throw new IllegalArgumentException("cannot create QName from \"" + qNameAsString + "\", missing closing \"}\"");
                }
                nsURI = qNameAsString.substring(1, endOfNamespaceURI);
                localPart = qNameAsString.substring(endOfNamespaceURI + 1);
            } else {
                int colonIdx = qNameAsString.indexOf(58);
                if (colonIdx > 0) {
                    prefix = qNameAsString.substring(0, colonIdx);
                    localPart = qNameAsString.substring(colonIdx + 1);
                    nsURI = schema.getNamespaceResolver().resolveNamespacePrefix(prefix);
                    if (nsURI == null) {
                        nsURI = "";
                    }
                } else {
                    localPart = qNameAsString;
                }
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(localPart);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", localPart, prefix == null ? "" : prefix);
                }
            } else {
                qName = new QName(nsURI == null ? "" : nsURI, localPart, prefix == null ? "" : prefix);
            }
        }
        return qName;
    }

    public static void addSimpleXMLFormat(Schema schema) {
        ComplexType anyType = new ComplexType();
        anyType.setName("simple-xml-format");
        Sequence anySequence = new Sequence();
        Any any = new Any();
        any.setMinOccurs("0");
        anySequence.addAny(any);
        anyType.setSequence(anySequence);
        schema.addTopLevelComplexTypes(anyType);
    }

    public static boolean noOutArguments(DbStoredProcedure storedProcedure) {
        boolean noOutArguments = true;
        if (storedProcedure.getArguments() != null && storedProcedure.getArguments().size() > 0) {
            for (DbStoredArgument arg : storedProcedure.getArguments()) {
                if (arg.getInOut() != InOut.INOUT && arg.getInOut() != InOut.OUT) continue;
                noOutArguments = false;
                break;
            }
        }
        return noOutArguments;
    }

    public static String escapePunctuation(String originalName, boolean isOracle) {
        if (originalName == null || originalName.length() == 0) {
            if (isOracle) {
                return null;
            }
            return originalName;
        }
        return originalName.trim().replaceAll("[\\p{Punct}&&[^_%]]", "\\\\$0");
    }

    public static boolean sqlMatch(String pattern, String input) {
        if (pattern != null && pattern.length() > 0) {
            String tmp = pattern.replace('_', '.').replace("%", ".*");
            Pattern p = Pattern.compile(tmp, 66);
            return p.matcher(input).matches();
        }
        return false;
    }

    static {
        WSI_SWAREF_XSD_FILE = SWAREF_FILENAME = WSI_SWAREF.toLowerCase() + ".xsd";
        SXF_QNAME_CURSOR = new QName("", "cursor of simple-xml-format");
    }

    public static enum InOut {
        IN,
        OUT,
        INOUT,
        RETURN;

    }
}

