/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractProcedureArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedure;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWAbstractProcedureInOutputArgument
extends MWAbstractProcedureArgument {
    private String outFieldName;
    public static final String OUT_FIELD_NAME_PROPERTY = "outFieldName";

    protected MWAbstractProcedureInOutputArgument() {
    }

    MWAbstractProcedureInOutputArgument(MWProcedure manager, String name) {
        super(manager, name);
    }

    protected void initialize() {
        super.initialize();
        this.outFieldName = "";
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractProcedureInOutputArgument.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractProcedureArgument.class);
        XMLDirectMapping outFieldNameMapping = new XMLDirectMapping();
        outFieldNameMapping.setAttributeName(OUT_FIELD_NAME_PROPERTY);
        outFieldNameMapping.setGetMethodName("getOutFieldNameForTopLink");
        outFieldNameMapping.setSetMethodName("setOutFieldNameForTopLink");
        outFieldNameMapping.setXPath("out-field-name/text()");
        descriptor.addMapping((DatabaseMapping)outFieldNameMapping);
        return descriptor;
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.buildOutFieldJavaClassRequiredToPassByValueProblem(currentProblems);
    }

    protected void buildOutFieldJavaClassRequiredToPassByValueProblem(List currentProblems) {
        if ("value type".equals(this.getPassType()) && (StringTools.stringIsEmpty(this.getOutFieldName()) || StringTools.stringIsEmpty(this.getFieldJavaClassName()))) {
            this.buildProblem("0261");
        }
    }

    public String getOutFieldName() {
        if (this.outFieldName == null) {
            return "";
        }
        return this.outFieldName;
    }

    public void setOutFieldName(String name) {
        String oldOutFieldName = this.outFieldName;
        this.outFieldName = name;
        this.firePropertyChanged(OUT_FIELD_NAME_PROPERTY, oldOutFieldName, this.outFieldName);
    }

    private void setOutFieldNameForTopLink(String outFieldName) {
        this.outFieldName = outFieldName;
    }

    private String getOutFieldNameForTopLink() {
        return this.outFieldName;
    }
}

