/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractProcedureArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractProcedureInOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureNamedInArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureNamedInOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureNamedOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureUnamedInArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureUnamedInOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureUnamedOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStoredProcedureQueryFormat;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MWProcedure
extends MWModel {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private List<MWProcedureNamedOutputArgument> namedOutputArguments;
    public static final String NAMED_OUTPUT_ARGUMENT_LIST = "namedOutputArguments";
    private List<MWProcedureNamedInOutputArgument> namedInOuputArguments;
    public static final String NAMED_INOUTPUT_ARGUMENT_LIST = "namedInOutputArguments";
    private List<MWProcedureNamedInArgument> namedInArguments;
    public static final String NAMED_ARGUMENT_LIST = "namedArguments";
    private List<MWProcedureUnamedInOutputArgument> unamedInOuputArguments;
    public static final String UNAMED_INOUTPUT_ARGUMENT_LIST = "unamedInOutputArguments";
    private List<MWProcedureUnamedInArgument> unamedInArguments;
    public static final String UNAMED_ARGUMENT_LIST = "unamedArguments";
    private List<MWProcedureUnamedOutputArgument> unamedOutputArguments;
    public static final String UNAMED_OUTPUT_ARGUMENT_LIST = "unamedOutputArguments";
    public static final String ARGUMENT_COLLECTION = "arguments";
    private Boolean useUnamedCursorOutput;
    public static final String USE_UNAMED_CURSOR_OUTPUT = "useUnamedCursorOutput";
    private String cursorOutputName;
    public static final String CURSOR_OUTPUT_NAME = "cursorOutputName";

    private MWProcedure() {
    }

    public MWProcedure(MWStoredProcedureQueryFormat format) {
        super(format);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.name = "STR_PROC_1";
        this.namedInArguments = new ArrayList<MWProcedureNamedInArgument>();
        this.namedOutputArguments = new ArrayList<MWProcedureNamedOutputArgument>();
        this.namedInOuputArguments = new ArrayList<MWProcedureNamedInOutputArgument>();
        this.unamedInArguments = new ArrayList<MWProcedureUnamedInArgument>();
        this.unamedOutputArguments = new ArrayList<MWProcedureUnamedOutputArgument>();
        this.unamedInOuputArguments = new ArrayList<MWProcedureUnamedInOutputArgument>();
        this.useUnamedCursorOutput = Boolean.FALSE;
        this.cursorOutputName = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List<MWAbstractProcedureArgument> list = this.namedInArguments;
        synchronized (list) {
            children.addAll(this.namedInArguments);
        }
        list = this.namedOutputArguments;
        synchronized (list) {
            children.addAll(this.namedOutputArguments);
        }
        list = this.namedInOuputArguments;
        synchronized (list) {
            children.addAll(this.namedInOuputArguments);
        }
        list = this.unamedInArguments;
        synchronized (list) {
            children.addAll(this.unamedInArguments);
        }
        list = this.unamedOutputArguments;
        synchronized (list) {
            children.addAll(this.unamedOutputArguments);
        }
        list = this.unamedInOuputArguments;
        synchronized (list) {
            children.addAll(this.unamedInOuputArguments);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWProcedure.class);
        XMLDirectMapping nameMapping = new XMLDirectMapping();
        nameMapping.setAttributeName(NAME_PROPERTY);
        nameMapping.setGetMethodName("getNameForTopLink");
        nameMapping.setSetMethodName("setNameForTopLink");
        nameMapping.setXPath("name/text()");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        XMLDirectMapping useUnamedCursorOutputMapping = new XMLDirectMapping();
        useUnamedCursorOutputMapping.setAttributeName(USE_UNAMED_CURSOR_OUTPUT);
        useUnamedCursorOutputMapping.setGetMethodName("getUseUnamedCursorOutputForTopLink");
        useUnamedCursorOutputMapping.setSetMethodName("setUseUnamedCursorOutputForTopLink");
        useUnamedCursorOutputMapping.setNullValue((Object)Boolean.TRUE);
        useUnamedCursorOutputMapping.setXPath("use-unamed-cursor-output");
        descriptor.addMapping((DatabaseMapping)useUnamedCursorOutputMapping);
        descriptor.addDirectMapping(CURSOR_OUTPUT_NAME, "getCursorOutputNameForTopLink", "setCursorOutputNameForTopLink", "cursor-output-name/text()");
        XMLCompositeCollectionMapping namedOutputArgumentsMapping = new XMLCompositeCollectionMapping();
        namedOutputArgumentsMapping.setAttributeName(NAMED_OUTPUT_ARGUMENT_LIST);
        namedOutputArgumentsMapping.setGetMethodName("getNamedOutputArgumentsForTopLink");
        namedOutputArgumentsMapping.setSetMethodName("setNamedOutputArgumentsForTopLink");
        namedOutputArgumentsMapping.setReferenceClass(MWProcedureNamedOutputArgument.class);
        namedOutputArgumentsMapping.setXPath("named-output-arguments/named-output-argument");
        descriptor.addMapping((DatabaseMapping)namedOutputArgumentsMapping);
        XMLCompositeCollectionMapping unamedOutputArgumentsMapping = new XMLCompositeCollectionMapping();
        unamedOutputArgumentsMapping.setAttributeName(UNAMED_OUTPUT_ARGUMENT_LIST);
        unamedOutputArgumentsMapping.setGetMethodName("getUnamedOutputArgumentsForTopLink");
        unamedOutputArgumentsMapping.setSetMethodName("setUnamedOutputArgumentsForTopLink");
        unamedOutputArgumentsMapping.setReferenceClass(MWProcedureUnamedOutputArgument.class);
        unamedOutputArgumentsMapping.setXPath("unamed-output-arguments/unamed-output-argument");
        descriptor.addMapping((DatabaseMapping)unamedOutputArgumentsMapping);
        XMLCompositeCollectionMapping namedInArgumentsMapping = new XMLCompositeCollectionMapping();
        namedInArgumentsMapping.setAttributeName("namedInArguments");
        namedInArgumentsMapping.setGetMethodName("getNamedInArgumentsForTopLink");
        namedInArgumentsMapping.setSetMethodName("setNamedInArgumentsForTopLink");
        namedInArgumentsMapping.setReferenceClass(MWProcedureNamedInArgument.class);
        namedInArgumentsMapping.setXPath("named-in-arguments/named-in-argument");
        descriptor.addMapping((DatabaseMapping)namedInArgumentsMapping);
        XMLCompositeCollectionMapping unamedInArgumentsMapping = new XMLCompositeCollectionMapping();
        unamedInArgumentsMapping.setAttributeName("unamedInArguments");
        unamedInArgumentsMapping.setGetMethodName("getUnamedInArgumentsForTopLink");
        unamedInArgumentsMapping.setSetMethodName("setUnamedInArgumentsForTopLink");
        unamedInArgumentsMapping.setReferenceClass(MWProcedureUnamedInArgument.class);
        unamedInArgumentsMapping.setXPath("unamed-in-arguments/unamed-in-argument");
        descriptor.addMapping((DatabaseMapping)unamedInArgumentsMapping);
        XMLCompositeCollectionMapping namedInOutputArgumentsMapping = new XMLCompositeCollectionMapping();
        namedInOutputArgumentsMapping.setAttributeName(NAMED_INOUTPUT_ARGUMENT_LIST);
        namedInOutputArgumentsMapping.setGetMethodName("getNamedInOutputArgumentsForTopLink");
        namedInOutputArgumentsMapping.setSetMethodName("setNamedInOutputArgumentsForTopLink");
        namedInOutputArgumentsMapping.setReferenceClass(MWProcedureNamedInOutputArgument.class);
        namedInOutputArgumentsMapping.setXPath("named-inout-arguments/named-inout-argument");
        descriptor.addMapping((DatabaseMapping)namedInOutputArgumentsMapping);
        XMLCompositeCollectionMapping unamedInOutputArgumentsMapping = new XMLCompositeCollectionMapping();
        unamedInOutputArgumentsMapping.setAttributeName(UNAMED_INOUTPUT_ARGUMENT_LIST);
        unamedInOutputArgumentsMapping.setGetMethodName("getUnamedInOutputArgumentsForTopLink");
        unamedInOutputArgumentsMapping.setSetMethodName("setUnamedInOutputArgumentsForTopLink");
        unamedInOutputArgumentsMapping.setReferenceClass(MWProcedureUnamedInOutputArgument.class);
        unamedInOutputArgumentsMapping.setXPath("unamed-inout-arguments/unamed-inout-argument");
        descriptor.addMapping((DatabaseMapping)unamedInOutputArgumentsMapping);
        return descriptor;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, oldName, this.name);
    }

    private void setNameForTopLink(String name) {
        this.name = name;
    }

    private String getNameForTopLink() {
        return this.name;
    }

    public Boolean getUseUnamedCursorOutput() {
        return this.useUnamedCursorOutput;
    }

    public void setUseUnamedCursorOutput(Boolean newValue) {
        Boolean old = this.useUnamedCursorOutput;
        this.useUnamedCursorOutput = newValue;
        this.firePropertyChanged(USE_UNAMED_CURSOR_OUTPUT, old, this.useUnamedCursorOutput);
    }

    private Boolean getUseUnamedCursorOutputForTopLink() {
        return this.useUnamedCursorOutput;
    }

    private void setUseUnamedCursorOutputForTopLink(Boolean newValue) {
        this.useUnamedCursorOutput = newValue;
    }

    public String getCursorOutputName() {
        return this.cursorOutputName;
    }

    public void setCursorOutputName(String newValue) {
        String old = this.cursorOutputName;
        this.cursorOutputName = newValue;
        this.firePropertyChanged(CURSOR_OUTPUT_NAME, old, newValue);
    }

    private String getCursorOutputNameForTopLink() {
        return this.cursorOutputName;
    }

    private void setCursorOutputNameForTopLink(String newValue) {
        this.cursorOutputName = newValue;
    }

    public MWQuery getQuery() {
        return ((MWQueryFormat)this.getParent()).getQuery();
    }

    public int argumentsSize() {
        return this.namedInArgumentsSize() + this.namedOutputArgumentsSize() + this.namedInOutputArgumentsSize() + this.unamedInArgumentsSize() + this.unamedOutputArgumentsSize() + this.unamedInOutputArgumentsSize();
    }

    public Iterator<MWAbstractProcedureArgument> getAllArguments() {
        ArrayList argumentList = new ArrayList();
        CollectionTools.addAll(argumentList, this.namedInArguments());
        CollectionTools.addAll(argumentList, this.namedOutputArguments());
        CollectionTools.addAll(argumentList, this.namedInOutputArguments());
        CollectionTools.addAll(argumentList, this.unamedInArguments());
        CollectionTools.addAll(argumentList, this.unamedOutputArguments());
        CollectionTools.addAll(argumentList, this.unamedInOutputArguments());
        return argumentList.iterator();
    }

    public MWProcedureNamedInArgument addNamedInArgument(String name) {
        MWProcedureNamedInArgument namedArgument = new MWProcedureNamedInArgument(this, name);
        this.addItemToList(namedArgument, this.namedInArguments, NAMED_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
        return namedArgument;
    }

    public void removeArgument(MWAbstractProcedureArgument argument) {
        if (argument.isNamedIn()) {
            this.removeNamedArgument((MWProcedureNamedInArgument)argument);
        } else if (argument.isNamedOut()) {
            this.removeNamedOutputArgument((MWProcedureNamedOutputArgument)argument);
        } else if (argument.isNamedInOut()) {
            this.removeNamedInOutputArgument((MWProcedureNamedInOutputArgument)argument);
        } else if (argument.isUnnamedIn()) {
            this.removeUnamedArgument((MWProcedureUnamedInArgument)argument);
        } else if (argument.isUnnamedOut()) {
            this.removeUnamedOuputArgument((MWProcedureUnamedOutputArgument)argument);
        } else if (argument.isUnnamedInOut()) {
            this.removeUnamedInOuputArgument((MWProcedureUnamedInOutputArgument)argument);
        }
    }

    public void removeNamedArgument(MWProcedureNamedInArgument argument) {
        this.removeItemFromList(argument, this.namedInArguments, NAMED_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    private void setNamedInArgumentsForTopLink(List<MWProcedureNamedInArgument> namedArguments) {
        this.namedInArguments = namedArguments;
    }

    private List<MWProcedureNamedInArgument> getNamedInArgumentsForTopLink() {
        return CollectionTools.sort(this.namedInArguments);
    }

    public int namedInOutputArgumentsSize() {
        return this.namedInOuputArguments.size();
    }

    public MWProcedureNamedInOutputArgument addNamedInOutputArgument(String name) {
        MWProcedureNamedInOutputArgument namedInOutputArgument = new MWProcedureNamedInOutputArgument(this, name);
        this.addItemToList(namedInOutputArgument, this.namedInOuputArguments, NAMED_INOUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
        return namedInOutputArgument;
    }

    public void removeNamedInOutputArgument(MWProcedureNamedInOutputArgument argument) {
        this.removeItemFromList(argument, this.namedInOuputArguments, NAMED_INOUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    private void setNamedInOutputArgumentsForTopLink(List<MWProcedureNamedInOutputArgument> namedInOutputArguments) {
        this.namedInOuputArguments = namedInOutputArguments;
    }

    private List<MWProcedureNamedInOutputArgument> getNamedInOutputArgumentsForTopLink() {
        return CollectionTools.sort(this.namedInOuputArguments);
    }

    public int namedOutputArgumentsSize() {
        return this.namedOutputArguments.size();
    }

    public MWProcedureNamedOutputArgument addNamedOutputArgument(String name) {
        MWProcedureNamedOutputArgument namedOutputArgument = new MWProcedureNamedOutputArgument(this, name);
        this.addItemToList(namedOutputArgument, this.namedOutputArguments, NAMED_OUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
        return namedOutputArgument;
    }

    public void removeNamedOutputArgument(MWProcedureNamedOutputArgument argument) {
        this.removeItemFromList(argument, this.namedOutputArguments, NAMED_OUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    private void setNamedOutputArgumentsForTopLink(List<MWProcedureNamedOutputArgument> namedOutputArguments) {
        this.namedOutputArguments = namedOutputArguments;
    }

    private List<MWProcedureNamedOutputArgument> getNamedOutputArgumentsForTopLink() {
        return CollectionTools.sort(this.namedOutputArguments);
    }

    public MWProcedureUnamedInArgument addUnamedInArgument() {
        MWProcedureUnamedInArgument unamedArgument = new MWProcedureUnamedInArgument(this);
        this.addItemToList(unamedArgument, this.unamedInArguments, UNAMED_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
        return unamedArgument;
    }

    public void removeUnamedArgument(MWProcedureUnamedInArgument argument) {
        this.removeItemFromList(argument, this.unamedInArguments, UNAMED_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    private void setUnamedInArgumentsForTopLink(List<MWProcedureUnamedInArgument> unamedArguments) {
        this.unamedInArguments = unamedArguments;
    }

    private List<MWProcedureUnamedInArgument> getUnamedInArgumentsForTopLink() {
        return CollectionTools.sort(this.unamedInArguments);
    }

    public int unamedInOutputArgumentsSize() {
        return this.unamedInOuputArguments.size();
    }

    public MWProcedureUnamedInOutputArgument addUnamedInOutputArgument() {
        MWProcedureUnamedInOutputArgument unamedInOutputArgument = new MWProcedureUnamedInOutputArgument(this);
        this.addItemToList(unamedInOutputArgument, this.unamedInOuputArguments, UNAMED_INOUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
        return unamedInOutputArgument;
    }

    public void removeUnamedInOuputArgument(MWProcedureUnamedInOutputArgument argument) {
        this.removeItemFromList(argument, this.unamedInOuputArguments, UNAMED_INOUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    private void setUnamedInOutputArgumentsForTopLink(List<MWProcedureUnamedInOutputArgument> unamedInOutputArguments) {
        this.unamedInOuputArguments = unamedInOutputArguments;
    }

    private List<MWProcedureUnamedInOutputArgument> getUnamedInOutputArgumentsForTopLink() {
        return CollectionTools.sort(this.unamedInOuputArguments);
    }

    public int unamedOutputArgumentsSize() {
        return this.unamedOutputArguments.size();
    }

    public MWProcedureUnamedOutputArgument addUnamedOutputArgument() {
        MWProcedureUnamedOutputArgument unamedOutputArgument = new MWProcedureUnamedOutputArgument(this);
        this.addItemToList(unamedOutputArgument, this.unamedOutputArguments, UNAMED_OUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
        return unamedOutputArgument;
    }

    public void removeUnamedOuputArgument(MWProcedureUnamedOutputArgument argument) {
        this.removeItemFromList(argument, this.unamedOutputArguments, UNAMED_OUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    private void setUnamedOutputArgumentsForTopLink(List<MWProcedureUnamedOutputArgument> unamedOutputArguments) {
        this.unamedOutputArguments = unamedOutputArguments;
    }

    private List<MWProcedureUnamedOutputArgument> getUnamedOutputArgumentsForTopLink() {
        return CollectionTools.sort(this.unamedOutputArguments);
    }

    public Iterator<String> namedInArgumentNames() {
        return new TransformationIterator(this.namedInArguments()){

            protected String transform(Object value) {
                return ((MWProcedureNamedInArgument)value).getArgumentName();
            }
        };
    }

    public Iterator<String> namedInOutputArgumentNames() {
        return new TransformationIterator(this.namedInOutputArguments()){

            protected String transform(Object value) {
                return ((MWProcedureNamedInOutputArgument)value).getArgumentName();
            }
        };
    }

    public Iterator<String> namedOutputArgumentNames() {
        return new TransformationIterator(this.namedOutputArguments()){

            protected String transform(Object value) {
                return ((MWProcedureNamedOutputArgument)value).getArgumentName();
            }
        };
    }

    public Iterator<String> unamedOutputArgumentNames() {
        return new TransformationIterator(this.unamedOutputArguments()){

            protected String transform(Object value) {
                return ((MWProcedureUnamedOutputArgument)value).getArgumentName();
            }
        };
    }

    public Iterator<String> unamedInOutputArgumentNames() {
        return new TransformationIterator(this.unamedInOutputArguments()){

            protected String transform(Object value) {
                return ((MWProcedureUnamedInOutputArgument)value).getArgumentName();
            }
        };
    }

    public Iterator<String> unamedInArgumentNames() {
        return new TransformationIterator(this.unamedInArguments()){

            protected String transform(Object value) {
                return ((MWProcedureUnamedInArgument)value).getArgumentName();
            }
        };
    }

    public ListIterator<MWProcedureNamedInArgument> namedInArguments() {
        return new CloneListIterator(this.namedInArguments);
    }

    public ListIterator<MWProcedureNamedInOutputArgument> namedInOutputArguments() {
        return new CloneListIterator(this.namedInOuputArguments);
    }

    public ListIterator<MWProcedureNamedOutputArgument> namedOutputArguments() {
        return new CloneListIterator(this.namedOutputArguments);
    }

    public ListIterator<MWProcedureUnamedInArgument> unamedInArguments() {
        return new CloneListIterator(this.unamedInArguments);
    }

    public ListIterator<MWProcedureUnamedInOutputArgument> unamedInOutputArguments() {
        return new CloneListIterator(this.unamedInOuputArguments);
    }

    public ListIterator<MWProcedureUnamedOutputArgument> unamedOutputArguments() {
        return new CloneListIterator(this.unamedOutputArguments);
    }

    public int namedInArgumentsSize() {
        return this.namedInArguments.size();
    }

    public int unamedInArgumentsSize() {
        return this.unamedInArguments.size();
    }

    @Override
    public String displayString() {
        return this.getName();
    }

    public void removeNamedArgumentAt(int index) {
        this.removeItemFromList(index, this.namedInArguments, NAMED_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    public void removeNamedInOutputArgumentAt(int index) {
        this.removeItemFromList(index, this.namedInOuputArguments, NAMED_INOUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    public void removeNamedOutputArgumentAt(int index) {
        this.removeItemFromList(index, this.namedOutputArguments, NAMED_OUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    public void removeUnamedArgumentAt(int index) {
        this.removeItemFromList(index, this.unamedInArguments, UNAMED_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    public void removeUnamedInOutputArgumentAt(int index) {
        this.removeItemFromList(index, this.unamedInOuputArguments, UNAMED_INOUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    public void removeUnamedOutputArgumentAt(int index) {
        this.removeItemFromList(index, this.unamedOutputArguments, UNAMED_OUTPUT_ARGUMENT_LIST);
        this.fireCollectionChanged(ARGUMENT_COLLECTION);
    }

    public StoredProcedureCall buildRuntimeCall() {
        StoredProcedureCall runtimeProcedure = new StoredProcedureCall();
        runtimeProcedure.setProcedureName(this.getName());
        if (this.useUnamedCursorOutput.booleanValue()) {
            runtimeProcedure.useUnnamedCursorOutputAsResultSet();
        } else if (this.getCursorOutputName() == null) {
            runtimeProcedure.useNamedCursorOutputAsResultSet("");
        } else {
            runtimeProcedure.useNamedCursorOutputAsResultSet(this.getCursorOutputName());
        }
        ListIterator<MWAbstractProcedureArgument> it = this.namedInArguments();
        while (it.hasNext()) {
            MWProcedureNamedInArgument namedArgument = (MWProcedureNamedInArgument)it.next();
            namedArgument.addRuntimeEclipseLinkArgument(runtimeProcedure);
        }
        it = this.namedInOutputArguments();
        while (it.hasNext()) {
            MWProcedureNamedInOutputArgument namedInOutputArgument = (MWProcedureNamedInOutputArgument)it.next();
            namedInOutputArgument.addRuntimeEclipseLinkArgument(runtimeProcedure);
        }
        it = this.namedOutputArguments();
        while (it.hasNext()) {
            MWProcedureNamedOutputArgument namedOutputArgument = (MWProcedureNamedOutputArgument)it.next();
            namedOutputArgument.addRuntimeEclipseLinkArgument(runtimeProcedure);
        }
        it = this.unamedInArguments();
        while (it.hasNext()) {
            MWProcedureUnamedInArgument unamedArgument = (MWProcedureUnamedInArgument)it.next();
            unamedArgument.addRuntimeEclipseLinkArgument(runtimeProcedure);
        }
        it = this.unamedInOutputArguments();
        while (it.hasNext()) {
            MWProcedureUnamedInOutputArgument unamedInOutputArgument = (MWProcedureUnamedInOutputArgument)it.next();
            unamedInOutputArgument.addRuntimeEclipseLinkArgument(runtimeProcedure);
        }
        it = this.unamedOutputArguments();
        while (it.hasNext()) {
            MWProcedureUnamedOutputArgument unamedOutputArgument = (MWProcedureUnamedOutputArgument)it.next();
            unamedOutputArgument.addRuntimeEclipseLinkArgument(runtimeProcedure);
        }
        return runtimeProcedure;
    }

    public static MWProcedure convertFromEclipseLinkRuntime(MWStoredProcedureQueryFormat format, StoredProcedureCall call) {
        MWProcedure procedure = new MWProcedure(format);
        procedure.setName(call.getProcedureName());
        boolean unamedCursor = true;
        Iterator argumentNames = call.getProcedureArgumentNames().iterator();
        Iterator parameters = call.getParameters().iterator();
        Iterator parameterTypes = call.getParameterTypes().iterator();
        while (argumentNames.hasNext()) {
            String name = (String)argumentNames.next();
            Integer type = (Integer)parameterTypes.next();
            MWAbstractProcedureArgument arg = null;
            DatabaseField field = null;
            DatabaseField outField = null;
            Object parameter = parameters.next();
            if (parameter instanceof DatabaseField) {
                field = (DatabaseField)parameter;
            } else {
                field = (DatabaseField)((Object[])parameter)[0];
                outField = (DatabaseField)((Object[])parameter)[1];
            }
            if (name == null) {
                if (type.equals(DatasourceCall.IN)) {
                    arg = procedure.addUnamedInArgument();
                } else if (type.equals(DatasourceCall.INOUT)) {
                    arg = procedure.addUnamedInOutputArgument();
                    ((MWAbstractProcedureInOutputArgument)arg).setOutFieldName(outField.getName());
                } else if (type.equals(DatasourceCall.OUT)) {
                    arg = procedure.addUnamedOutputArgument();
                }
            } else if (type.equals(DatasourceCall.IN)) {
                arg = procedure.addNamedInArgument(name);
            } else if (type.equals(DatasourceCall.INOUT)) {
                arg = procedure.addNamedInOutputArgument(name);
                ((MWAbstractProcedureInOutputArgument)arg).setOutFieldName(outField.getName());
            } else if (type.equals(DatasourceCall.OUT)) {
                arg = procedure.addNamedOutputArgument(name);
            } else if (type.equals(DatasourceCall.OUT_CURSOR)) {
                unamedCursor = false;
                procedure.setCursorOutputName(name);
                procedure.setUseUnamedCursorOutput(Boolean.FALSE);
            }
            arg.setFieldName(field.getName());
            arg.setFieldSqlTypeName(MWAbstractProcedureArgument.jdbcTypeNameFor(field.getSqlType()));
            if (!(field instanceof ObjectRelationalDatabaseField)) continue;
            ObjectRelationalDatabaseField orField = (ObjectRelationalDatabaseField)field;
            arg.setFieldSubTypeName(orField.getSqlTypeName());
            if (orField.getType() != null) {
                arg.setFieldJavaClassName(orField.getType().getName());
            }
            if (orField.getNestedTypeField() == null) continue;
            arg.setNestedTypeFieldName(orField.getNestedTypeField().getName());
        }
        if (unamedCursor) {
            procedure.setUseUnamedCursorOutput(Boolean.TRUE);
            procedure.setCursorOutputName(null);
        }
        return procedure;
    }
}

