/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi;

import java.lang.reflect.Method;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalDatabaseFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalDatabaseFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepositoryFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClassRepositoryFactory;

public class DefaultSPIManager
implements SPIManager {
    private Preferences preferences;
    public static final String SPI_PREFERENCES_NODE = "spi";
    public static final String DEFAULTS_PREFERENCES_NODE = "defaults";
    public static final String PROJECTS_PREFERENCES_NODE = "projects";
    private String projectName;
    private ExternalClassRepositoryFactory externalClassRepositoryFactory;
    public static final String EXTERNAL_CLASS_REPOSITORY_FACTORY_CLASS_NAME_PREFERENCE = "external class repository factory class";
    public static final String EXTERNAL_CLASS_REPOSITORY_FACTORY_CLASS_NAME_PREFERENCE_DEFAULT = CFExternalClassRepositoryFactory.class.getName();
    public static final String EXTERNAL_CLASS_REPOSITORY_FACTORY_STATIC_METHOD_NAME_PREFERENCE = "external class repository factory static method";
    public static final String EXTERNAL_CLASS_REPOSITORY_FACTORY_STATIC_METHOD_NAME_PREFERENCE_DEFAULT = "instance";
    private ExternalDatabaseFactory externalDatabaseFactory;
    public static final String EXTERNAL_DATABASE_FACTORY_CLASS_NAME_PREFERENCE = "external database factory class";
    public static final String EXTERNAL_DATABASE_FACTORY_CLASS_NAME_PREFERENCE_DEFAULT = JDBCExternalDatabaseFactory.class.getName();
    public static final String EXTERNAL_DATABASE_FACTORY_STATIC_METHOD_NAME_PREFERENCE = "external database factory static method";
    public static final String EXTERNAL_DATABASE_FACTORY_STATIC_METHOD_NAME_PREFERENCE_DEFAULT = "instance";

    public DefaultSPIManager(Preferences preferences, String projectName) {
        this.preferences = preferences.node(SPI_PREFERENCES_NODE);
        this.projectName = projectName;
    }

    public ExternalClassRepositoryFactory getExternalClassRepositoryFactory() {
        if (this.externalClassRepositoryFactory == null) {
            this.externalClassRepositoryFactory = this.buildExternalClassRepositoryFactory();
        }
        return this.externalClassRepositoryFactory;
    }

    private ExternalClassRepositoryFactory buildExternalClassRepositoryFactory() {
        return (ExternalClassRepositoryFactory)this.buildFactory(this.externalClassRepositoryFactoryClassName(), this.externalClassRepositoryFactoryStaticMethodName());
    }

    private String externalClassRepositoryFactoryClassName() {
        return this.value(EXTERNAL_CLASS_REPOSITORY_FACTORY_CLASS_NAME_PREFERENCE, EXTERNAL_CLASS_REPOSITORY_FACTORY_CLASS_NAME_PREFERENCE_DEFAULT);
    }

    private String externalClassRepositoryFactoryStaticMethodName() {
        return this.value(EXTERNAL_CLASS_REPOSITORY_FACTORY_STATIC_METHOD_NAME_PREFERENCE, "instance");
    }

    public ExternalDatabaseFactory getExternalDatabaseFactory() {
        if (this.externalDatabaseFactory == null) {
            this.externalDatabaseFactory = this.buildExternalDatabaseFactory();
        }
        return this.externalDatabaseFactory;
    }

    private ExternalDatabaseFactory buildExternalDatabaseFactory() {
        return (ExternalDatabaseFactory)this.buildFactory(this.externalDatabaseFactoryClassName(), this.externalDatabaseFactoryStaticMethodName());
    }

    private String externalDatabaseFactoryClassName() {
        return this.value(EXTERNAL_DATABASE_FACTORY_CLASS_NAME_PREFERENCE, EXTERNAL_DATABASE_FACTORY_CLASS_NAME_PREFERENCE_DEFAULT);
    }

    private String externalDatabaseFactoryStaticMethodName() {
        return this.value(EXTERNAL_DATABASE_FACTORY_STATIC_METHOD_NAME_PREFERENCE, "instance");
    }

    private String value(String key, String defaultValue) {
        String value = defaultValue;
        value = this.preferences.node(DEFAULTS_PREFERENCES_NODE).get(key, value);
        try {
            if (this.preferences.node(PROJECTS_PREFERENCES_NODE).nodeExists(this.projectName)) {
                value = this.preferences.node(PROJECTS_PREFERENCES_NODE).node(this.projectName).get(key, value);
            }
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    private Object buildFactory(String factoryClassName, String factoryStaticMethodName) {
        try {
            Class<?> factoryClass = Class.forName(factoryClassName);
            Method factoryStaticMethod = factoryClass.getMethod(factoryStaticMethodName, new Class[0]);
            return factoryStaticMethod.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

