/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.Bag;

public class HashBag
extends AbstractCollection
implements Bag,
Cloneable,
Serializable {
    transient Entry[] table;
    transient int count = 0;
    transient int uniqueCount = 0;
    private int threshold;
    private float loadFactor;
    transient int modCount = 0;
    private static Iterator emptyIterator = new EmptyIterator();
    private static final long serialVersionUID = 1L;

    public HashBag() {
        this(11, 0.75f);
    }

    public HashBag(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashBag(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public HashBag(Collection c) {
        this(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object o) {
        Entry[] tab = this.table;
        if (o == null) {
            Entry e = tab[0];
            while (e != null) {
                if (e.object == null) {
                    return true;
                }
                e = e.next;
            }
        } else {
            int hash = o.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && o.equals(e.object)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public int count(Object o) {
        Entry[] tab = this.table;
        if (o == null) {
            Entry e = tab[0];
            while (e != null) {
                if (e.object == null) {
                    return e.count;
                }
                e = e.next;
            }
        } else {
            int hash = o.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && o.equals(e.object)) {
                    return e.count;
                }
                e = e.next;
            }
        }
        return 0;
    }

    private void rehash() {
        Entry[] oldMap = this.table;
        int oldCapacity = oldMap.length;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public boolean add(Object o) {
        Entry e;
        ++this.modCount;
        Entry[] tab = this.table;
        int hash = 0;
        int index = 0;
        if (o == null) {
            e = tab[0];
            while (e != null) {
                if (e.object == null) {
                    ++e.count;
                    ++this.count;
                    return true;
                }
                e = e.next;
            }
        } else {
            hash = o.hashCode();
            index = (hash & Integer.MAX_VALUE) % tab.length;
            e = tab[index];
            while (e != null) {
                if (e.hash == hash && o.equals(e.object)) {
                    ++e.count;
                    ++this.count;
                    return true;
                }
                e = e.next;
            }
        }
        if (this.uniqueCount >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, o, tab[index]);
        ++this.count;
        ++this.uniqueCount;
        return true;
    }

    public boolean remove(Object o) {
        Entry[] tab = this.table;
        if (o == null) {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                if (e.object == null) {
                    ++this.modCount;
                    --e.count;
                    if (e.count == 0) {
                        if (prev == null) {
                            tab[0] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --this.uniqueCount;
                    }
                    --this.count;
                    return true;
                }
                prev = e;
                e = e.next;
            }
        } else {
            int hash = o.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.hash == hash && o.equals(e.object)) {
                    ++this.modCount;
                    --e.count;
                    if (e.count == 0) {
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --this.uniqueCount;
                    }
                    --this.count;
                    return true;
                }
                prev = e;
                e = e.next;
            }
        }
        return false;
    }

    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int i = tab.length;
        while (--i >= 0) {
            tab[i] = null;
        }
        this.count = 0;
        this.uniqueCount = 0;
    }

    public Object clone() {
        try {
            HashBag clone = (HashBag)super.clone();
            clone.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                clone.table[i] = this.table[i] == null ? null : (Entry)this.table[i].clone();
            }
            clone.modCount = 0;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Iterator iterator() {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new HashIterator();
    }

    public Iterator uniqueIterator() {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new UniqueIterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bag)) {
            return false;
        }
        Bag b = (Bag)o;
        if (b.size() != this.size()) {
            return false;
        }
        Bag clone = (Bag)this.clone();
        for (Object element : b) {
            if (clone.remove(element)) continue;
            return false;
        }
        return clone.isEmpty();
    }

    public int hashCode() {
        int h = 0;
        for (Object next : this) {
            if (next == null) continue;
            h += next.hashCode();
        }
        return h;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.uniqueCount);
        Entry[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            Entry entry = tab[i];
            while (entry != null) {
                s.writeObject(entry.object);
                s.writeInt(entry.count);
                entry = entry.next;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.table = new Entry[s.readInt()];
        int unique = s.readInt();
        for (int i = 0; i < unique; ++i) {
            Object element = s.readObject();
            int elementCount = s.readInt();
            for (int j = 0; j < elementCount; ++j) {
                this.add(element);
            }
        }
    }

    private class UniqueIterator
    implements Iterator {
        Entry[] localTable;
        int index;
        Entry nextEntry;
        Entry lastReturnedEntry;
        private int expectedModCount;

        UniqueIterator() {
            this.localTable = HashBag.this.table;
            this.index = this.localTable.length;
            this.nextEntry = null;
            this.lastReturnedEntry = null;
            this.expectedModCount = HashBag.this.modCount;
        }

        public boolean hasNext() {
            Entry e = this.nextEntry;
            int i = this.index;
            Entry[] tab = this.localTable;
            while (e == null && i > 0) {
                e = tab[--i];
            }
            this.nextEntry = e;
            this.index = i;
            return e != null;
        }

        public Object next() {
            if (HashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.nextEntry;
            int i = this.index;
            Entry[] tab = this.localTable;
            while (et == null && i > 0) {
                et = tab[--i];
            }
            this.nextEntry = et;
            this.index = i;
            if (et == null) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturnedEntry = this.nextEntry;
            this.nextEntry = e.next;
            return e.object;
        }

        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (HashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = this.localTable;
            int slot = (this.lastReturnedEntry.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[slot];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturnedEntry) {
                    ++HashBag.this.modCount;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[slot] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --HashBag.this.uniqueCount;
                    HashBag.this.count -= this.lastReturnedEntry.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] localTable;
        int index;
        Entry nextEntry;
        int nextEntryCount;
        Entry lastReturnedEntry;
        private int expectedModCount;

        HashIterator() {
            this.localTable = HashBag.this.table;
            this.index = this.localTable.length;
            this.nextEntry = null;
            this.nextEntryCount = 0;
            this.lastReturnedEntry = null;
            this.expectedModCount = HashBag.this.modCount;
        }

        public boolean hasNext() {
            Entry e = this.nextEntry;
            int i = this.index;
            Entry[] tab = this.localTable;
            while (e == null && i > 0) {
                e = tab[--i];
            }
            this.nextEntry = e;
            this.index = i;
            return e != null;
        }

        public Object next() {
            if (HashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.nextEntry;
            int i = this.index;
            Entry[] tab = this.localTable;
            while (et == null && i > 0) {
                et = tab[--i];
            }
            this.nextEntry = et;
            this.index = i;
            if (et == null) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturnedEntry = this.nextEntry;
            ++this.nextEntryCount;
            if (this.nextEntryCount == e.count) {
                this.nextEntry = e.next;
                this.nextEntryCount = 0;
            }
            return e.object;
        }

        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (HashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = this.localTable;
            int slot = (this.lastReturnedEntry.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[slot];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturnedEntry) {
                    ++HashBag.this.modCount;
                    ++this.expectedModCount;
                    --e.count;
                    if (e.count == 0) {
                        if (prev == null) {
                            tab[slot] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --HashBag.this.uniqueCount;
                    } else {
                        --this.nextEntryCount;
                    }
                    --HashBag.this.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry {
        int hash;
        Object object;
        int count;
        Entry next;

        Entry(int hash, Object object, Entry next) {
            this(hash, object, 1, next);
        }

        private Entry(int hash, Object object, int count, Entry next) {
            this.hash = hash;
            this.object = object;
            this.count = count;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.object, this.count, this.next == null ? null : (Entry)this.next.clone());
        }

        public String toString() {
            return this.object + "=>" + this.count;
        }
    }
}

