/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.diff.ContainerDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.OrderedContainerDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.ReferenceDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.ReflectiveDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.ReflectiveFieldDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ReflectiveDifferentiator
implements Differentiator {
    private final Class javaClass;
    private final Differentiator defaultFieldDifferentiator;
    private final Map fieldDifferentiators;
    private KeyDifferentiator keyDifferentiator;
    private boolean comparesValueObjects;
    private OrderedContainerDifferentiator listDifferentiator;
    private OrderedContainerDifferentiator arrayDifferentiator;
    private ContainerDifferentiator collectionDifferentiator;
    private ContainerDifferentiator unorderedArrayDifferentiator;
    private ContainerDifferentiator mapDifferentiator;

    public ReflectiveDifferentiator(Class javaClass) {
        this(javaClass, EqualityDifferentiator.instance());
    }

    public ReflectiveDifferentiator(Class javaClass, Differentiator defaultFieldDifferentiator) {
        if (javaClass.isInterface()) {
            throw new IllegalArgumentException("interfaces cannot be compared reflectively: " + javaClass.getName());
        }
        this.javaClass = javaClass;
        if (defaultFieldDifferentiator == null) {
            throw new NullPointerException();
        }
        this.defaultFieldDifferentiator = defaultFieldDifferentiator;
        this.fieldDifferentiators = this.buildDefaultFieldDifferentiators(false);
        this.keyDifferentiator = new DefaultKeyDifferentiator();
        this.comparesValueObjects = false;
    }

    private Map buildDefaultFieldDifferentiators(boolean compareStaticFields) {
        HashMap<Field, Differentiator> differentiators = new HashMap<Field, Differentiator>();
        Field[] declaredFields = this.javaClass.getDeclaredFields();
        int i = declaredFields.length;
        while (i-- > 0) {
            Field field = declaredFields[i];
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers()) && !compareStaticFields) continue;
            differentiators.put(field, this.defaultFieldDifferentiator(field));
        }
        return differentiators;
    }

    private Differentiator defaultFieldDifferentiator(Field field) {
        Class<?> fieldType = field.getType();
        if (List.class.isAssignableFrom(fieldType)) {
            return this.getListDifferentiator();
        }
        if (Collection.class.isAssignableFrom(fieldType)) {
            return this.getCollectionDifferentiator();
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return this.getMapDifferentiator();
        }
        if (fieldType.isArray()) {
            return this.getArrayDifferentiator();
        }
        return this.defaultFieldDifferentiator;
    }

    private Differentiator defaultFieldDifferentiator(String fieldName) {
        return this.defaultFieldDifferentiator(this.field(fieldName));
    }

    public Diff diff(Object object1, Object object2) {
        return this.diff(object1, object2, this.fieldDifferentiators, DifferentiatorAdapter.NORMAL);
    }

    public Diff keyDiff(Object object1, Object object2) {
        return this.keyDifferentiator.keyDiff(object1, object2);
    }

    Diff diff(Object object1, Object object2, Map differentiators, DifferentiatorAdapter adapter) {
        if (object1 == object2) {
            return new NullDiff(object1, object2, this);
        }
        if (this.diffIsFatal(object1, object2)) {
            return new SimpleDiff(object1, object2, this.fatalDescriptionTitle(), this);
        }
        Object[] diffs = new ReflectiveFieldDiff[differentiators.size()];
        int i = 0;
        for (Map.Entry entry : differentiators.entrySet()) {
            Field field = (Field)entry.getKey();
            Differentiator fieldDifferentiator = (Differentiator)entry.getValue();
            Object fieldValue1 = this.fieldValue(field, object1);
            Object fieldValue2 = this.fieldValue(field, object2);
            Diff fieldDiff = adapter.diff(fieldDifferentiator, fieldValue1, fieldValue2);
            diffs[i++] = new ReflectiveFieldDiff(field, fieldDiff, this);
        }
        return new ReflectiveDiff(this.javaClass, object1, object2, (ReflectiveFieldDiff[])CollectionTools.sort(diffs), this);
    }

    public boolean comparesValueObjects() {
        return this.comparesValueObjects;
    }

    private OrderedContainerDifferentiator getListDifferentiator() {
        if (this.listDifferentiator == null) {
            this.listDifferentiator = OrderedContainerDifferentiator.forLists(this.defaultFieldDifferentiator);
        }
        return this.listDifferentiator;
    }

    private OrderedContainerDifferentiator getArrayDifferentiator() {
        if (this.arrayDifferentiator == null) {
            this.arrayDifferentiator = OrderedContainerDifferentiator.forArrays(this.defaultFieldDifferentiator);
        }
        return this.arrayDifferentiator;
    }

    private ContainerDifferentiator getCollectionDifferentiator() {
        if (this.collectionDifferentiator == null) {
            this.collectionDifferentiator = ContainerDifferentiator.forCollections(this.defaultFieldDifferentiator);
        }
        return this.collectionDifferentiator;
    }

    private ContainerDifferentiator getUnorderedArrayDifferentiator() {
        if (this.unorderedArrayDifferentiator == null) {
            this.unorderedArrayDifferentiator = ContainerDifferentiator.forArrays(this.defaultFieldDifferentiator);
        }
        return this.unorderedArrayDifferentiator;
    }

    private ContainerDifferentiator getMapDifferentiator() {
        if (this.mapDifferentiator == null) {
            this.mapDifferentiator = ContainerDifferentiator.forMaps(this.defaultFieldDifferentiator, this.defaultFieldDifferentiator);
        }
        return this.mapDifferentiator;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public Differentiator getDefaultFieldDifferentiator() {
        return this.defaultFieldDifferentiator;
    }

    public KeyDifferentiator getKeyDifferentiator() {
        return this.keyDifferentiator;
    }

    private boolean diffIsFatal(Object object1, Object object2) {
        if (object1 == null) {
            return true;
        }
        if (object2 == null) {
            return true;
        }
        return object1.getClass() != object2.getClass();
    }

    protected String fatalDescriptionTitle() {
        return "Objects cannot be compared via reflection (" + this.javaClass.getName() + ")";
    }

    public String toString() {
        return StringTools.buildToStringFor(this, ClassTools.shortNameFor(this.javaClass));
    }

    public void setKeyDifferentiator(KeyDifferentiator keyDifferentiator) {
        this.keyDifferentiator = keyDifferentiator;
    }

    public void setComparesValueObjects(boolean comparesValueObjects) {
        this.comparesValueObjects = comparesValueObjects;
    }

    public Differentiator setFieldDifferentiator(String fieldName, Differentiator differentiator) {
        return this.setFieldDifferentiator(this.field(fieldName), differentiator);
    }

    private Differentiator setFieldDifferentiator(Field field, Differentiator differentiator) {
        if (differentiator == null) {
            throw new NullPointerException();
        }
        Differentiator prev = this.fieldDifferentiators.put(field, differentiator);
        if (prev != this.defaultFieldDifferentiator(field)) {
            throw new IllegalArgumentException("duplicate field differentiator: " + field.getName());
        }
        return differentiator;
    }

    public Differentiator replaceFieldDifferentiator(String fieldName, Differentiator differentiator) {
        return this.replaceFieldDifferentiator(this.field(fieldName), differentiator);
    }

    private Differentiator replaceFieldDifferentiator(Field field, Differentiator differentiator) {
        if (differentiator == null) {
            throw new NullPointerException();
        }
        Differentiator prev = this.fieldDifferentiators.put(field, differentiator);
        if (prev == this.defaultFieldDifferentiator(field)) {
            throw new IllegalArgumentException("field differentiator not present: " + field.getName());
        }
        return differentiator;
    }

    public Differentiator getFieldDifferentiator(String fieldName) {
        return (Differentiator)this.fieldDifferentiators.get(this.field(fieldName));
    }

    public Differentiator setKeyFieldDifferentiator(String fieldName, Differentiator differentiator) {
        return this.setKeyFieldDifferentiator(this.field(fieldName), differentiator);
    }

    private Differentiator setKeyFieldDifferentiator(Field field, Differentiator differentiator) {
        if (this.keyDifferentiator instanceof DefaultKeyDifferentiator) {
            return ((DefaultKeyDifferentiator)this.keyDifferentiator).setKeyFieldDifferentiator(field, differentiator);
        }
        throw new IllegalStateException("the default key differentiator is not being used");
    }

    public Differentiator replaceKeyFieldDifferentiator(String fieldName, Differentiator differentiator) {
        return this.replaceKeyFieldDifferentiator(this.field(fieldName), differentiator);
    }

    private Differentiator replaceKeyFieldDifferentiator(Field field, Differentiator differentiator) {
        if (this.keyDifferentiator instanceof DefaultKeyDifferentiator) {
            return ((DefaultKeyDifferentiator)this.keyDifferentiator).replaceKeyFieldDifferentiator(field, differentiator);
        }
        throw new IllegalStateException("the default key differentiator is not being used");
    }

    public Differentiator getKeyFieldDifferentiator(String fieldName) {
        if (this.keyDifferentiator instanceof DefaultKeyDifferentiator) {
            return ((DefaultKeyDifferentiator)this.keyDifferentiator).getKeyFieldDifferentiator(this.field(fieldName));
        }
        throw new IllegalStateException("the default key differentiator is not being used");
    }

    public Differentiator removeKeyFieldDifferentiator(String fieldName) {
        if (this.keyDifferentiator instanceof DefaultKeyDifferentiator) {
            return ((DefaultKeyDifferentiator)this.keyDifferentiator).removeKeyFieldDifferentiator(this.field(fieldName));
        }
        throw new IllegalStateException("the default key differentiator is not being used");
    }

    private Object fieldValue(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Field field(String fieldName) {
        Field field = null;
        try {
            field = this.javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException(fieldName);
        }
        field.setAccessible(true);
        return field;
    }

    public NullDifferentiator ignoreFieldNamed(String fieldName) {
        return (NullDifferentiator)this.setFieldDifferentiator(fieldName, NullDifferentiator.instance());
    }

    public NullDifferentiator ignoreFieldsNamed(String fieldName) {
        return this.ignoreFieldNamed(fieldName);
    }

    public void ignoreFieldsNamed(String fieldName1, String fieldName2) {
        this.ignoreFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void ignoreFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.ignoreFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void ignoreFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.ignoreFieldNamed(fieldNames[i]);
        }
    }

    public Differentiator addKeyFieldNamed(String fieldName) {
        return this.setKeyFieldDifferentiator(fieldName, this.defaultFieldDifferentiator(fieldName));
    }

    public Differentiator addKeyFieldsNamed(String fieldName) {
        return this.addKeyFieldNamed(fieldName);
    }

    public void addKeyFieldsNamed(String fieldName1, String fieldName2) {
        this.addKeyFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addKeyFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addKeyFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addKeyFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addKeyFieldNamed(fieldNames[i]);
        }
    }

    private ReferenceDifferentiator addReferenceFieldNamed(String fieldName, Differentiator differentiator) {
        return (ReferenceDifferentiator)this.setFieldDifferentiator(fieldName, (Differentiator)new ReferenceDifferentiator(differentiator));
    }

    public Differentiator addReferenceFieldNamed(String fieldName) {
        return this.addReferenceFieldNamed(fieldName, this.defaultFieldDifferentiator(fieldName));
    }

    public Differentiator addReferenceFieldsNamed(String fieldName) {
        return this.addReferenceFieldNamed(fieldName);
    }

    public void addReferenceFieldsNamed(String fieldName1, String fieldName2) {
        this.addReferenceFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addReferenceFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addReferenceFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addReferenceFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addReferenceFieldNamed(fieldNames[i]);
        }
    }

    public OrderedContainerDifferentiator addListFieldNamed(String fieldName) {
        return (OrderedContainerDifferentiator)this.setFieldDifferentiator(fieldName, (Differentiator)this.getListDifferentiator());
    }

    public OrderedContainerDifferentiator addListFieldsNamed(String fieldName) {
        return this.addListFieldNamed(fieldName);
    }

    public void addListFieldsNamed(String fieldName1, String fieldName2) {
        this.addListFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addListFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addListFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addListFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addListFieldNamed(fieldNames[i]);
        }
    }

    public ReferenceDifferentiator addReferenceListFieldNamed(String fieldName) {
        return this.addReferenceFieldNamed(fieldName, this.getListDifferentiator());
    }

    public ReferenceDifferentiator addReferenceListFieldsNamed(String fieldName) {
        return this.addReferenceListFieldNamed(fieldName);
    }

    public void addReferenceListFieldsNamed(String fieldName1, String fieldName2) {
        this.addReferenceListFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addReferenceListFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addReferenceListFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addReferenceListFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addReferenceListFieldNamed(fieldNames[i]);
        }
    }

    public OrderedContainerDifferentiator addArrayFieldNamed(String fieldName) {
        return (OrderedContainerDifferentiator)this.setFieldDifferentiator(fieldName, (Differentiator)this.getArrayDifferentiator());
    }

    public OrderedContainerDifferentiator addArrayFieldsNamed(String fieldName) {
        return this.addArrayFieldNamed(fieldName);
    }

    public void addArrayFieldsNamed(String fieldName1, String fieldName2) {
        this.addArrayFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addArrayFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addArrayFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addArrayFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addArrayFieldNamed(fieldNames[i]);
        }
    }

    public ReferenceDifferentiator addReferenceArrayFieldNamed(String fieldName) {
        return this.addReferenceFieldNamed(fieldName, this.getArrayDifferentiator());
    }

    public ReferenceDifferentiator addReferenceArrayFieldsNamed(String fieldName) {
        return this.addReferenceArrayFieldNamed(fieldName);
    }

    public void addReferenceArrayFieldsNamed(String fieldName1, String fieldName2) {
        this.addReferenceArrayFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addReferenceArrayFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addReferenceArrayFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addReferenceArrayFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addReferenceArrayFieldNamed(fieldNames[i]);
        }
    }

    public ContainerDifferentiator addCollectionFieldNamed(String fieldName) {
        return (ContainerDifferentiator)this.setFieldDifferentiator(fieldName, (Differentiator)this.getCollectionDifferentiator());
    }

    public ContainerDifferentiator addCollectionFieldsNamed(String fieldName) {
        return this.addCollectionFieldNamed(fieldName);
    }

    public void addCollectionFieldsNamed(String fieldName1, String fieldName2) {
        this.addCollectionFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addCollectionFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addCollectionFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addCollectionFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addCollectionFieldNamed(fieldNames[i]);
        }
    }

    public ReferenceDifferentiator addReferenceCollectionFieldNamed(String fieldName) {
        return this.addReferenceFieldNamed(fieldName, this.getCollectionDifferentiator());
    }

    public ReferenceDifferentiator addReferenceCollectionFieldsNamed(String fieldName) {
        return this.addReferenceCollectionFieldNamed(fieldName);
    }

    public void addReferenceCollectionFieldsNamed(String fieldName1, String fieldName2) {
        this.addReferenceCollectionFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addReferenceCollectionFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addReferenceCollectionFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addReferenceCollectionFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addReferenceCollectionFieldNamed(fieldNames[i]);
        }
    }

    public ContainerDifferentiator addUnorderedArrayFieldNamed(String fieldName) {
        return (ContainerDifferentiator)this.setFieldDifferentiator(fieldName, (Differentiator)this.getUnorderedArrayDifferentiator());
    }

    public ContainerDifferentiator addUnorderedArrayFieldsNamed(String fieldName) {
        return this.addUnorderedArrayFieldNamed(fieldName);
    }

    public void addUnorderedArrayFieldsNamed(String fieldName1, String fieldName2) {
        this.addUnorderedArrayFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addUnorderedArrayFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addUnorderedArrayFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addUnorderedArrayFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addUnorderedArrayFieldNamed(fieldNames[i]);
        }
    }

    public ReferenceDifferentiator addReferenceUnorderedArrayFieldNamed(String fieldName) {
        return this.addReferenceFieldNamed(fieldName, this.getUnorderedArrayDifferentiator());
    }

    public ReferenceDifferentiator addReferenceUnorderedArrayFieldsNamed(String fieldName) {
        return this.addReferenceUnorderedArrayFieldNamed(fieldName);
    }

    public void addReferenceUnorderedArrayFieldsNamed(String fieldName1, String fieldName2) {
        this.addReferenceUnorderedArrayFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addReferenceUnorderedArrayFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addReferenceUnorderedArrayFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addReferenceUnorderedArrayFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addReferenceUnorderedArrayFieldNamed(fieldNames[i]);
        }
    }

    public ContainerDifferentiator addMapFieldNamed(String fieldName) {
        return (ContainerDifferentiator)this.setFieldDifferentiator(fieldName, (Differentiator)this.getMapDifferentiator());
    }

    public ContainerDifferentiator addMapFieldsNamed(String fieldName) {
        return this.addMapFieldNamed(fieldName);
    }

    public void addMapFieldsNamed(String fieldName1, String fieldName2) {
        this.addMapFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addMapFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addMapFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addMapFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addMapFieldNamed(fieldNames[i]);
        }
    }

    public ReferenceDifferentiator addReferenceMapFieldNamed(String fieldName) {
        return this.addReferenceFieldNamed(fieldName, this.getMapDifferentiator());
    }

    public ReferenceDifferentiator addReferenceMapFieldsNamed(String fieldName) {
        return this.addReferenceMapFieldNamed(fieldName);
    }

    public void addReferenceMapFieldsNamed(String fieldName1, String fieldName2) {
        this.addReferenceMapFieldsNamed(new String[]{fieldName1, fieldName2});
    }

    public void addReferenceMapFieldsNamed(String fieldName1, String fieldName2, String fieldName3) {
        this.addReferenceMapFieldsNamed(new String[]{fieldName1, fieldName2, fieldName3});
    }

    public void addReferenceMapFieldsNamed(String[] fieldNames) {
        int i = fieldNames.length;
        while (i-- > 0) {
            this.addReferenceMapFieldNamed(fieldNames[i]);
        }
    }

    public static class SimpleMethodKeyDifferentiator
    implements KeyDifferentiator {
        protected String methodName;
        protected static final Object NULL_KEY = new Object();

        public SimpleMethodKeyDifferentiator(String methodName) {
            this.methodName = methodName;
        }

        public Diff keyDiff(Object object1, Object object2) {
            return this.diffKeys(this.key(object1), this.key(object2));
        }

        protected Diff diffKeys(Object key1, Object key2) {
            return EqualityDifferentiator.instance().diff(key1, key2);
        }

        protected Object key(Object object) {
            return object == null ? NULL_KEY : ClassTools.invokeMethod(object, this.methodName);
        }

        protected Object nullKey() {
            return NULL_KEY;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.methodName);
        }
    }

    private class DefaultKeyDifferentiator
    implements KeyDifferentiator {
        private Map keyFieldDifferentiators = new HashMap();

        DefaultKeyDifferentiator() {
        }

        public Diff keyDiff(Object object1, Object object2) {
            return ReflectiveDifferentiator.this.diff(object1, object2, this.keyFieldDifferentiators, DifferentiatorAdapter.KEY);
        }

        Differentiator setKeyFieldDifferentiator(Field field, Differentiator differentiator) {
            Differentiator prev = this.replaceKeyFieldDifferentiator(field, differentiator);
            if (prev != null) {
                throw new IllegalArgumentException("duplicate key field differentiator: " + field.getName());
            }
            return differentiator;
        }

        Differentiator replaceKeyFieldDifferentiator(Field field, Differentiator differentiator) {
            if (differentiator == null) {
                throw new NullPointerException();
            }
            return this.keyFieldDifferentiators.put(field, differentiator);
        }

        Differentiator getKeyFieldDifferentiator(Field field) {
            return (Differentiator)this.keyFieldDifferentiators.get(field);
        }

        Differentiator removeKeyFieldDifferentiator(Field field) {
            return (Differentiator)this.keyFieldDifferentiators.remove(field);
        }
    }

    public static interface KeyDifferentiator {
        public Diff keyDiff(Object var1, Object var2);
    }
}

