/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.IdentityHashBag;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ChangeSupport
implements Serializable {
    protected final Object source;
    private transient Map listeners;
    private Map children;
    private static final long serialVersionUID = 1L;

    public ChangeSupport(Object source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(Class listenerClass, Object listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            IdentityHashBag listenerClassSpecificListeners;
            if (this.listeners == null) {
                this.listeners = new IdentityHashMap();
            }
            if ((listenerClassSpecificListeners = (IdentityHashBag)this.listeners.get(listenerClass)) == null) {
                listenerClassSpecificListeners = new IdentityHashBag();
                this.listeners.put(listenerClass, listenerClassSpecificListeners);
            }
            listenerClassSpecificListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(String aspectName, Class listenerClass, Object listener) {
        if (aspectName == null || listener == null) {
            throw new NullPointerException();
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ChangeSupport child;
            if (this.children == null) {
                this.children = new IdentityHashMap();
            }
            if ((child = (ChangeSupport)this.children.get(aspectName)) == null) {
                child = this.buildChildChangeSupport();
                this.children.put(aspectName, child);
            }
            child.addListener(listenerClass, listener);
        }
    }

    protected ChangeSupport buildChildChangeSupport() {
        return new ChangeSupport(this.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListener(Class listenerClass, Object listener) {
        if (this.listeners == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            IdentityHashBag listenerClassSpecificListeners = (IdentityHashBag)this.listeners.get(listenerClass);
            if (listenerClassSpecificListeners == null) {
                throw new IllegalArgumentException("listener not registered");
            }
            if (!listenerClassSpecificListeners.remove(listener)) {
                throw new IllegalArgumentException("listener not registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListener(String aspectName, Class listenerClass, Object listener) {
        if (this.children == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ChangeSupport child = (ChangeSupport)this.children.get(aspectName);
            if (child == null) {
                throw new IllegalArgumentException("listener not registered");
            }
            child.removeListener(listenerClass, listener);
        }
    }

    protected ChangeNotifier notifier() {
        return DefaultChangeNotifier.instance();
    }

    protected synchronized boolean hasAnyListeners(Class listenerClass) {
        if (this.listeners == null) {
            return false;
        }
        IdentityHashBag listenerClassSpecificListeners = (IdentityHashBag)this.listeners.get(listenerClass);
        return listenerClassSpecificListeners != null && !listenerClassSpecificListeners.isEmpty();
    }

    protected synchronized boolean hasAnyListeners(Class listenerClass, String aspectName) {
        if (this.hasAnyListeners(listenerClass)) {
            return true;
        }
        if (this.children == null) {
            return false;
        }
        ChangeSupport child = (ChangeSupport)this.children.get(aspectName);
        return child != null && child.hasAnyListeners(listenerClass);
    }

    protected void sourceChanged(String aspectName) {
    }

    public void addStateChangeListener(StateChangeListener listener) {
        this.addListener(StateChangeListener.class, listener);
    }

    public void removeStateChangeListener(StateChangeListener listener) {
        this.removeListener(StateChangeListener.class, listener);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.hasAnyListeners(StateChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged(StateChangeEvent event) {
        IdentityHashBag stateChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (stateChangeListeners = (IdentityHashBag)this.listeners.get(StateChangeListener.class)) != null) {
                targets = (IdentityHashBag)stateChangeListeners.clone();
            }
        }
        if (targets != null) {
            for (StateChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = stateChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().stateChanged(target, event);
            }
        }
        this.sourceChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged() {
        IdentityHashBag stateChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (stateChangeListeners = (IdentityHashBag)this.listeners.get(StateChangeListener.class)) != null) {
                targets = (IdentityHashBag)stateChangeListeners.clone();
            }
        }
        if (targets != null) {
            StateChangeEvent event = null;
            for (StateChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = stateChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new StateChangeEvent(this.source);
                }
                this.notifier().stateChanged(target, event);
            }
        }
        this.sourceChanged(null);
    }

    public boolean valuesAreEqual(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public boolean valuesAreDifferent(Object value1, Object value2) {
        return !this.valuesAreEqual(value1, value2);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addListener(PropertyChangeListener.class, listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.addListener(propertyName, PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removeListener(PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.removeListener(propertyName, PropertyChangeListener.class, listener);
    }

    public boolean hasAnyPropertyChangeListeners(String propertyName) {
        return this.hasAnyListeners(PropertyChangeListener.class, propertyName);
    }

    public boolean hasAnyPropertyChangeListeners() {
        return this.hasAnyListeners(PropertyChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(PropertyChangeEvent event) {
        if (this.valuesAreEqual(event.getOldValue(), event.getNewValue())) {
            return;
        }
        String propertyName = event.getPropertyName();
        IdentityHashBag propertyChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (propertyChangeListeners = (IdentityHashBag)this.listeners.get(PropertyChangeListener.class)) != null) {
                targets = (IdentityHashBag)propertyChangeListeners.clone();
            }
            if (propertyName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(propertyName);
            }
        }
        if (targets != null) {
            for (PropertyChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = propertyChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().propertyChange(target, event);
            }
        }
        if (child != null) {
            child.firePropertyChanged(event);
        }
        this.sourceChanged(propertyName);
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (this.valuesAreDifferent(oldValue, newValue)) {
            this.firePropertyChangedInternal(propertyName, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChangedInternal(String propertyName, Object oldValue, Object newValue) {
        IdentityHashBag propertyChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (propertyChangeListeners = (IdentityHashBag)this.listeners.get(PropertyChangeListener.class)) != null) {
                targets = (IdentityHashBag)propertyChangeListeners.clone();
            }
            if (propertyName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(propertyName);
            }
        }
        PropertyChangeEvent event = null;
        if (targets != null) {
            for (PropertyChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = propertyChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                }
                this.notifier().propertyChange(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.firePropertyChanged(propertyName, oldValue, newValue);
            } else {
                child.firePropertyChanged(event);
            }
        }
        this.sourceChanged(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        IdentityHashBag propertyChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (propertyChangeListeners = (IdentityHashBag)this.listeners.get(PropertyChangeListener.class)) != null) {
                targets = (IdentityHashBag)propertyChangeListeners.clone();
            }
            if (propertyName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(propertyName);
            }
        }
        PropertyChangeEvent event = null;
        if (targets != null) {
            for (PropertyChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = propertyChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new PropertyChangeEvent(this.source, propertyName, new Integer(oldValue), new Integer(newValue));
                }
                this.notifier().propertyChange(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.firePropertyChanged(propertyName, oldValue, newValue);
            } else {
                child.firePropertyChanged(event);
            }
        }
        this.sourceChanged(propertyName);
    }

    public void firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.firePropertyChangedInternal(propertyName, oldValue, newValue);
        }
    }

    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.addListener(CollectionChangeListener.class, listener);
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.addListener(collectionName, CollectionChangeListener.class, listener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.removeListener(CollectionChangeListener.class, listener);
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.removeListener(collectionName, CollectionChangeListener.class, listener);
    }

    public boolean hasAnyCollectionChangeListeners(String collectionName) {
        return this.hasAnyListeners(CollectionChangeListener.class, collectionName);
    }

    public boolean hasAnyCollectionChangeListeners() {
        return this.hasAnyListeners(CollectionChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(CollectionChangeEvent event) {
        if (event.size() == 0) {
            return;
        }
        String collectionName = event.getCollectionName();
        IdentityHashBag collectionChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (collectionChangeListeners = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                targets = (IdentityHashBag)collectionChangeListeners.clone();
            }
            if (collectionName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(collectionName);
            }
        }
        if (targets != null) {
            for (CollectionChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = collectionChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().itemsAdded(target, event);
            }
        }
        if (child != null) {
            child.fireItemsAdded(event);
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(String collectionName, Collection addedItems) {
        if (addedItems.size() == 0) {
            return;
        }
        IdentityHashBag collectionChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (collectionChangeListeners = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                targets = (IdentityHashBag)collectionChangeListeners.clone();
            }
            if (collectionName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(collectionName);
            }
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            for (CollectionChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = collectionChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new CollectionChangeEvent(this.source, collectionName, addedItems);
                }
                this.notifier().itemsAdded(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsAdded(collectionName, addedItems);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(String collectionName, Object addedItem) {
        IdentityHashBag collectionChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (collectionChangeListeners = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                targets = (IdentityHashBag)collectionChangeListeners.clone();
            }
            if (collectionName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(collectionName);
            }
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            for (CollectionChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = collectionChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new CollectionChangeEvent(this.source, collectionName, Collections.singleton(addedItem));
                }
                this.notifier().itemsAdded(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemAdded(collectionName, addedItem);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(CollectionChangeEvent event) {
        if (event.size() == 0) {
            return;
        }
        String collectionName = event.getCollectionName();
        IdentityHashBag collectionChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (collectionChangeListeners = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                targets = (IdentityHashBag)collectionChangeListeners.clone();
            }
            if (collectionName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(collectionName);
            }
        }
        if (targets != null) {
            for (CollectionChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = collectionChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().itemsRemoved(target, event);
            }
        }
        if (child != null) {
            child.fireItemsRemoved(event);
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(String collectionName, Collection removedItems) {
        if (removedItems.size() == 0) {
            return;
        }
        IdentityHashBag collectionChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (collectionChangeListeners = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                targets = (IdentityHashBag)collectionChangeListeners.clone();
            }
            if (collectionName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(collectionName);
            }
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            for (CollectionChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = collectionChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new CollectionChangeEvent(this.source, collectionName, removedItems);
                }
                this.notifier().itemsRemoved(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsRemoved(collectionName, removedItems);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemRemoved(String collectionName, Object removedItem) {
        IdentityHashBag collectionChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (collectionChangeListeners = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                targets = (IdentityHashBag)collectionChangeListeners.clone();
            }
            if (collectionName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(collectionName);
            }
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            for (CollectionChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = collectionChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new CollectionChangeEvent(this.source, collectionName, Collections.singleton(removedItem));
                }
                this.notifier().itemsRemoved(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemRemoved(collectionName, removedItem);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionChanged(CollectionChangeEvent event) {
        String collectionName = event.getCollectionName();
        IdentityHashBag collectionChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (collectionChangeListeners = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                targets = (IdentityHashBag)collectionChangeListeners.clone();
            }
            if (collectionName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(collectionName);
            }
        }
        if (targets != null) {
            for (CollectionChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = collectionChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().collectionChanged(target, event);
            }
        }
        if (child != null) {
            child.fireCollectionChanged(event);
        }
        this.sourceChanged(collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionChanged(String collectionName) {
        IdentityHashBag collectionChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (collectionChangeListeners = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                targets = (IdentityHashBag)collectionChangeListeners.clone();
            }
            if (collectionName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(collectionName);
            }
        }
        CollectionChangeEvent event = null;
        if (targets != null) {
            for (CollectionChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = collectionChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new CollectionChangeEvent(this.source, collectionName);
                }
                this.notifier().collectionChanged(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireCollectionChanged(collectionName);
            } else {
                child.fireCollectionChanged(event);
            }
        }
        this.sourceChanged(collectionName);
    }

    public void addListChangeListener(ListChangeListener listener) {
        this.addListener(ListChangeListener.class, listener);
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
        this.addListener(listName, ListChangeListener.class, listener);
    }

    public void removeListChangeListener(ListChangeListener listener) {
        this.removeListener(ListChangeListener.class, listener);
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
        this.removeListener(listName, ListChangeListener.class, listener);
    }

    public boolean hasAnyListChangeListeners(String listName) {
        return this.hasAnyListeners(ListChangeListener.class, listName);
    }

    public boolean hasAnyListChangeListeners() {
        return this.hasAnyListeners(ListChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(ListChangeEvent event) {
        if (event.size() == 0) {
            return;
        }
        String listName = event.getListName();
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().itemsAdded(target, event);
            }
        }
        if (child != null) {
            child.fireItemsAdded(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(String listName, int index, List addedItems) {
        if (addedItems.size() == 0) {
            return;
        }
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        ListChangeEvent event = null;
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName, index, addedItems);
                }
                this.notifier().itemsAdded(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsAdded(listName, index, addedItems);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(String listName, int index, Object addedItem) {
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        ListChangeEvent event = null;
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(addedItem));
                }
                this.notifier().itemsAdded(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemAdded(listName, index, addedItem);
            } else {
                child.fireItemsAdded(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(ListChangeEvent event) {
        if (event.size() == 0) {
            return;
        }
        String listName = event.getListName();
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().itemsRemoved(target, event);
            }
        }
        if (child != null) {
            child.fireItemsRemoved(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(String listName, int index, List removedItems) {
        if (removedItems.size() == 0) {
            return;
        }
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        ListChangeEvent event = null;
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName, index, removedItems);
                }
                this.notifier().itemsRemoved(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsRemoved(listName, index, removedItems);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemRemoved(String listName, int index, Object removedItem) {
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        ListChangeEvent event = null;
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(removedItem));
                }
                this.notifier().itemsRemoved(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemRemoved(listName, index, removedItem);
            } else {
                child.fireItemsRemoved(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsReplaced(ListChangeEvent event) {
        if (event.size() == 0) {
            return;
        }
        String listName = event.getListName();
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().itemsReplaced(target, event);
            }
        }
        if (child != null) {
            child.fireItemsReplaced(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsReplaced(String listName, int index, List newItems, List replacedItems) {
        if (newItems.size() == 0) {
            return;
        }
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        ListChangeEvent event = null;
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName, index, newItems, replacedItems);
                }
                this.notifier().itemsReplaced(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemsReplaced(listName, index, newItems, replacedItems);
            } else {
                child.fireItemsReplaced(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemReplaced(String listName, int index, Object newItem, Object replacedItem) {
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        ListChangeEvent event = null;
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName, index, Collections.singletonList(newItem), Collections.singletonList(replacedItem));
                }
                this.notifier().itemsReplaced(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireItemReplaced(listName, index, newItem, replacedItem);
            } else {
                child.fireItemsReplaced(event);
            }
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListChanged(ListChangeEvent event) {
        String listName = event.getListName();
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().listChanged(target, event);
            }
        }
        if (child != null) {
            child.fireListChanged(event);
        }
        this.sourceChanged(listName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListChanged(String listName) {
        IdentityHashBag listChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (listChangeListeners = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                targets = (IdentityHashBag)listChangeListeners.clone();
            }
            if (listName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(listName);
            }
        }
        ListChangeEvent event = null;
        if (targets != null) {
            for (ListChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = listChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName);
                }
                this.notifier().listChanged(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireListChanged(listName);
            } else {
                child.fireListChanged(event);
            }
        }
        this.sourceChanged(listName);
    }

    public void addTreeChangeListener(TreeChangeListener listener) {
        this.addListener(TreeChangeListener.class, listener);
    }

    public void addTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.addListener(treeName, TreeChangeListener.class, listener);
    }

    public void removeTreeChangeListener(TreeChangeListener listener) {
        this.removeListener(TreeChangeListener.class, listener);
    }

    public void removeTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.removeListener(treeName, TreeChangeListener.class, listener);
    }

    public boolean hasAnyTreeChangeListeners(String treeName) {
        return this.hasAnyListeners(TreeChangeListener.class, treeName);
    }

    public boolean hasAnyTreeChangeListeners() {
        return this.hasAnyListeners(TreeChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeAdded(TreeChangeEvent event) {
        String treeName = event.getTreeName();
        IdentityHashBag treeChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (treeChangeListeners = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                targets = (IdentityHashBag)treeChangeListeners.clone();
            }
            if (treeName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(treeName);
            }
        }
        if (targets != null) {
            for (TreeChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = treeChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().nodeAdded(target, event);
            }
        }
        if (child != null) {
            child.fireNodeAdded(event);
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeAdded(String treeName, Object[] path) {
        IdentityHashBag treeChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (treeChangeListeners = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                targets = (IdentityHashBag)treeChangeListeners.clone();
            }
            if (treeName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(treeName);
            }
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            for (TreeChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = treeChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new TreeChangeEvent(this.source, treeName, path);
                }
                this.notifier().nodeAdded(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireNodeAdded(treeName, path);
            } else {
                child.fireNodeAdded(event);
            }
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeRemoved(TreeChangeEvent event) {
        String treeName = event.getTreeName();
        IdentityHashBag treeChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (treeChangeListeners = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                targets = (IdentityHashBag)treeChangeListeners.clone();
            }
            if (treeName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(treeName);
            }
        }
        if (targets != null) {
            for (TreeChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = treeChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().nodeRemoved(target, event);
            }
        }
        if (child != null) {
            child.fireNodeRemoved(event);
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeRemoved(String treeName, Object[] path) {
        IdentityHashBag treeChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (treeChangeListeners = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                targets = (IdentityHashBag)treeChangeListeners.clone();
            }
            if (treeName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(treeName);
            }
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            for (TreeChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = treeChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new TreeChangeEvent(this.source, treeName, path);
                }
                this.notifier().nodeRemoved(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireNodeRemoved(treeName, path);
            } else {
                child.fireNodeRemoved(event);
            }
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged(TreeChangeEvent event) {
        String treeName = event.getTreeName();
        IdentityHashBag treeChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (treeChangeListeners = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                targets = (IdentityHashBag)treeChangeListeners.clone();
            }
            if (treeName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(treeName);
            }
        }
        if (targets != null) {
            for (TreeChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = treeChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                this.notifier().treeChanged(target, event);
            }
        }
        if (child != null) {
            child.fireTreeChanged(event);
        }
        this.sourceChanged(treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged(String treeName, Object[] path) {
        IdentityHashBag treeChangeListeners = null;
        IdentityHashBag targets = null;
        ChangeSupport child = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (treeChangeListeners = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                targets = (IdentityHashBag)treeChangeListeners.clone();
            }
            if (treeName != null && this.children != null) {
                child = (ChangeSupport)this.children.get(treeName);
            }
        }
        TreeChangeEvent event = null;
        if (targets != null) {
            for (TreeChangeListener target : targets) {
                boolean stillListening;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    stillListening = treeChangeListeners.contains(target);
                }
                if (!stillListening) continue;
                if (event == null) {
                    event = new TreeChangeEvent(this.source, treeName, path);
                }
                this.notifier().treeChanged(target, event);
            }
        }
        if (child != null) {
            if (event == null) {
                child.fireTreeChanged(treeName, path);
            } else {
                child.fireTreeChanged(event);
            }
        }
        this.sourceChanged(treeName);
    }

    public void fireTreeChanged(String treeName) {
        this.fireTreeChanged(treeName, null);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.source);
    }
}

