/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.visitors;

import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVisitor<R, P>
extends SimpleTypeVisitor6<MetadataAnnotatedElement, MetadataAnnotatedElement> {
    public static String GENERIC_TYPE = "? extends Object";

    @Override
    public MetadataAnnotatedElement visitArray(ArrayType arrayType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(arrayType.toString());
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitDeclared(DeclaredType declaredType, MetadataAnnotatedElement annotatedElement) {
        MetadataMirrorFactory factory = (MetadataMirrorFactory)annotatedElement.getMetadataFactory();
        MetadataClass cls = factory.getMetadataClass(declaredType);
        annotatedElement.setType(cls.getName());
        annotatedElement.addGenericType(cls.getName());
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            annotatedElement.addGenericType(factory.getMetadataClass(typeMirror).getType());
        }
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitError(ErrorType errorType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(GENERIC_TYPE);
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitExecutable(ExecutableType executableType, MetadataAnnotatedElement annotatedElement) {
        MetadataMirrorFactory factory = (MetadataMirrorFactory)annotatedElement.getMetadataFactory();
        MetadataMethod method = (MetadataMethod)annotatedElement;
        for (TypeMirror typeMirror : executableType.getParameterTypes()) {
            method.addParameter(factory.getMetadataClass(typeMirror).getType());
        }
        executableType.getReturnType().accept(this, method);
        method.setReturnType(method.getType());
        return method;
    }

    @Override
    public MetadataAnnotatedElement visitNoType(NoType noType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(GENERIC_TYPE);
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitNull(NullType nullType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(GENERIC_TYPE);
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitPrimitive(PrimitiveType primitiveType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setPrimitiveType((Object)primitiveType);
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitTypeVariable(TypeVariable typeVariable, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(GENERIC_TYPE);
        return annotatedElement;
    }

    @Override
    public MetadataAnnotatedElement visitWildcard(WildcardType wildcardType, MetadataAnnotatedElement annotatedElement) {
        annotatedElement.setType(wildcardType.toString());
        return annotatedElement;
    }
}

