/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.history;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.HistoricalDatabaseTable;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class HistoryPolicy
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected DatabaseMapping mapping;
    protected Vector historicalTables;
    protected Vector startFields;
    protected Vector endFields;
    protected boolean shouldHandleWrites = true;
    protected boolean usesLocalTime = true;

    public Expression additionalHistoryExpression(ObjectExpression expression) {
        AsOfClause clause = expression.getAsOfClause();
        Object value = clause.getValue();
        Expression join = null;
        Expression subJoin = null;
        Expression start = null;
        Expression end = null;
        if (value == null) {
            return null;
        }
        if (value instanceof Expression) {
            if (value instanceof ConstantExpression && ((ConstantExpression)value).getValue() instanceof String) {
                value = ((ConstantExpression)value).getValue();
            }
        } else {
            ConversionManager converter = ConversionManager.getDefaultManager();
            value = converter.convertObject(value, ClassConstants.TIMESTAMP);
        }
        if (this.getMapping() != null) {
            TableExpression tableExp = null;
            DatabaseTable historicalTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
            tableExp = (TableExpression)expression.existingDerivedTable(historicalTable);
            start = tableExp.getField(this.getStart());
            end = tableExp.getField(this.getEnd());
            join = expression.shouldUseOuterJoin() ? start.isNull().or(start.lessThanEqual(value)) : start.lessThanEqual(value);
            join = join.and(end.isNull().or(end.greaterThan(value)));
            tableExp.setTable(historicalTable);
            return join;
        }
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            start = expression.getField(this.getStart(i));
            end = expression.getField(this.getEnd(i));
            subJoin = expression.shouldUseOuterJoin() ? start.isNull().or(start.lessThanEqual(value)) : start.lessThanEqual(value);
            subJoin = subJoin.and(end.isNull().or(end.greaterThan(value)));
            join = join == null ? subJoin : join.and(subJoin);
        }
        return join;
    }

    public Object clone() {
        Enumeration enumtr;
        HistoryPolicy clone = null;
        try {
            clone = (HistoryPolicy)super.clone();
        }
        catch (CloneNotSupportedException ignore) {
            // empty catch block
        }
        if (this.startFields != null) {
            clone.setStartFields(NonSynchronizedVector.newInstance(this.startFields.size()));
            enumtr = this.startFields.elements();
            while (enumtr.hasMoreElements()) {
                clone.getStartFields().addElement(((DatabaseField)enumtr.nextElement()).clone());
            }
        }
        if (this.endFields != null) {
            clone.setEndFields(NonSynchronizedVector.newInstance(this.endFields.size()));
            enumtr = this.endFields.elements();
            while (enumtr.hasMoreElements()) {
                clone.getEndFields().addElement(((DatabaseField)enumtr.nextElement()).clone());
            }
        }
        if (this.historicalTables != null) {
            clone.setHistoricalTables((Vector)this.historicalTables.clone());
        }
        return clone;
    }

    public Object getCurrentTime(AbstractSession session) {
        if (this.shouldUseLocalTime()) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.shouldUseDatabaseTime()) {
            AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
            while (readSession.isUnitOfWork()) {
                readSession = ((UnitOfWorkImpl)readSession).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            return readSession.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(session, readSession.getName());
        }
        return null;
    }

    public long getMinimumTimeIncrement(AbstractSession session) {
        AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
        while (readSession.isUnitOfWork()) {
            readSession = ((UnitOfWorkImpl)readSession).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
        }
        return readSession.getPlatform().minimumTimeIncrement();
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final Vector getHistoricalTables() {
        if (this.historicalTables == null) {
            this.historicalTables = NonSynchronizedVector.newInstance(1);
        }
        return this.historicalTables;
    }

    public Vector getHistoryTableNames() {
        Vector<String> names = new Vector<String>(this.getHistoricalTables().size());
        Enumeration enumtr = this.getHistoricalTables().elements();
        while (enumtr.hasMoreElements()) {
            HistoricalDatabaseTable table = (HistoricalDatabaseTable)enumtr.nextElement();
            names.addElement(table.getQualifiedName());
        }
        return names;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected DatabaseField getStart() {
        if (this.startFields != null) {
            return (DatabaseField)this.startFields.elementAt(0);
        }
        return null;
    }

    protected DatabaseField getStart(int i) {
        return (DatabaseField)this.startFields.elementAt(i);
    }

    public String getStartFieldName() {
        if (this.getStart() != null) {
            return this.getStart().getName();
        }
        return null;
    }

    public Vector getStartFields() {
        return this.startFields;
    }

    protected DatabaseField getEnd() {
        if (this.endFields != null) {
            return (DatabaseField)this.endFields.elementAt(0);
        }
        return null;
    }

    protected DatabaseField getEnd(int i) {
        return (DatabaseField)this.endFields.elementAt(i);
    }

    public String getEndFieldName() {
        if (this.getEnd() != null) {
            return this.getEnd().getName();
        }
        return null;
    }

    public Vector getEndFields() {
        return this.endFields;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void initialize(AbstractSession session) {
        if (this.getMapping() != null) {
            this.setDescriptor(this.getMapping().getDescriptor());
            if (this.getMapping().isDirectCollectionMapping()) {
                DatabaseTable refTable = ((DirectCollectionMapping)this.getMapping()).getReferenceTable();
                DatabaseTable histTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
                histTable.setName(refTable.getName());
                histTable.setTableQualifier(refTable.getTableQualifier());
                this.getStart().setTable(histTable);
                this.getEnd().setTable(histTable);
            } else if (this.getMapping().isManyToManyMapping()) {
                DatabaseTable relationTable = ((ManyToManyMapping)this.getMapping()).getRelationTable();
                DatabaseTable histTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
                histTable.setName(relationTable.getName());
                histTable.setTableQualifier(relationTable.getTableQualifier());
                this.getStart().setTable(histTable);
                this.getEnd().setTable(histTable);
            }
            this.verifyTableQualifiers(session.getPlatform());
            return;
        }
        int offset = this.getDescriptor().getTables().size() - this.getHistoricalTables().size();
        if (!this.getHistoricalTables().isEmpty() && ((DatabaseTable)this.getHistoricalTables().elementAt(0)).getName().equals("")) {
            for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
                DatabaseField endField;
                DatabaseField startField;
                HistoricalDatabaseTable table = (HistoricalDatabaseTable)this.getHistoricalTables().elementAt(i);
                if (table.getName().equals("")) {
                    DatabaseTable mirrored = this.getDescriptor().getTables().elementAt(i + offset);
                    table.setName(mirrored.getName());
                    table.setTableQualifier(mirrored.getTableQualifier());
                }
                if (this.getStartFields().size() < i + 1) {
                    startField = this.getStart(0).clone();
                    startField.setTable(table);
                    this.getStartFields().addElement(startField);
                } else {
                    startField = this.getStart(i);
                    startField.setTable(table);
                }
                if (this.getEndFields().size() < i + 1) {
                    endField = this.getEnd(0).clone();
                    endField.setTable(table);
                    this.getEndFields().addElement(endField);
                    continue;
                }
                endField = this.getEnd(i);
                endField.setTable(table);
            }
        } else {
            Vector unsortedTables = this.getHistoricalTables();
            NonSynchronizedVector sortedTables = NonSynchronizedVector.newInstance(unsortedTables.size());
            NonSynchronizedVector sortedStartFields = NonSynchronizedVector.newInstance(unsortedTables.size());
            NonSynchronizedVector sortedEndFields = NonSynchronizedVector.newInstance(unsortedTables.size());
            boolean universalStartField = this.getStartFields().size() == 1 && !((DatabaseField)this.getStartFields().get(0)).hasTableName();
            boolean universalEndField = this.getEndFields().size() == 1 && !((DatabaseField)this.getEndFields().get(0)).hasTableName();
            DatabaseTable descriptorTable = null;
            HistoricalDatabaseTable historicalTable = null;
            DatabaseField historyField = null;
            Vector<DatabaseTable> descriptorTables = this.getDescriptor().getTables();
            block1: for (int i = offset; i < descriptorTables.size(); ++i) {
                Enumeration enumtr;
                descriptorTable = descriptorTables.elementAt(i);
                int index = unsortedTables.indexOf(descriptorTable);
                if (index == -1) {
                    // empty if block
                }
                historicalTable = (HistoricalDatabaseTable)unsortedTables.elementAt(index);
                historicalTable.setTableQualifier(descriptorTable.getTableQualifier());
                ((Vector)sortedTables).add(historicalTable);
                if (universalStartField) {
                    historyField = this.getStart(0).clone();
                    historyField.setTable(historicalTable);
                    ((Vector)sortedStartFields).add(historyField);
                } else {
                    enumtr = this.getStartFields().elements();
                    while (enumtr.hasMoreElements()) {
                        historyField = (DatabaseField)enumtr.nextElement();
                        if (historyField.getTable().equals(historicalTable)) {
                            ((Vector)sortedStartFields).add(historyField);
                            break;
                        }
                        if (enumtr.hasMoreElements()) continue;
                    }
                }
                if (universalEndField) {
                    historyField = this.getEnd(0).clone();
                    historyField.setTable(historicalTable);
                    ((Vector)sortedEndFields).add(historyField);
                    continue;
                }
                enumtr = this.getEndFields().elements();
                while (enumtr.hasMoreElements()) {
                    historyField = (DatabaseField)enumtr.nextElement();
                    if (historyField.getTable().equals(historicalTable)) {
                        ((Vector)sortedEndFields).add(historyField);
                        continue block1;
                    }
                    if (enumtr.hasMoreElements()) continue;
                }
            }
            this.setHistoricalTables(sortedTables);
            this.setStartFields(sortedStartFields);
            this.setEndFields(sortedEndFields);
        }
        this.verifyTableQualifiers(session.getPlatform());
        if (this.getDescriptor().hasInheritance()) {
            ClassDescriptor parentDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
            while (parentDescriptor != null && parentDescriptor.getHistoryPolicy() == null) {
                parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
            }
            if (parentDescriptor != null) {
                this.setHistoricalTables(Helper.concatenateUniqueVectors(parentDescriptor.getHistoryPolicy().getHistoricalTables(), this.getHistoricalTables()));
                this.setStartFields(Helper.concatenateUniqueVectors(parentDescriptor.getHistoryPolicy().getStartFields(), this.getStartFields()));
                this.setEndFields(Helper.concatenateUniqueVectors(parentDescriptor.getHistoryPolicy().getEndFields(), this.getEndFields()));
            }
        }
    }

    public void addHistoryTableName(String name) {
        HistoricalDatabaseTable table = new HistoricalDatabaseTable("");
        table.setHistoricalName(name);
        this.getHistoricalTables().add(table);
    }

    public void addHistoryTableName(String sourceTableName, String historyTableName) {
        if (sourceTableName == null || sourceTableName.equals("")) {
            this.addHistoryTableName(historyTableName);
        }
        HistoricalDatabaseTable table = new HistoricalDatabaseTable(sourceTableName);
        table.setHistoricalName(historyTableName);
        int index = this.getHistoricalTables().indexOf(table);
        if (index == -1) {
            this.getHistoricalTables().add(table);
        } else {
            this.getHistoricalTables().set(index, table);
        }
    }

    public void setHistoricalTables(Vector historicalTables) {
        this.historicalTables = historicalTables;
    }

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    protected void setStartFields(Vector startFields) {
        this.startFields = startFields;
    }

    public void addStartFieldName(String startFieldName) {
        DatabaseField startField = new DatabaseField(startFieldName);
        startField.setType(ClassConstants.TIMESTAMP);
        if (this.startFields == null) {
            this.startFields = NonSynchronizedVector.newInstance();
            this.startFields.addElement(startField);
            return;
        }
        Enumeration enumtr = this.startFields.elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField existing = (DatabaseField)enumtr.nextElement();
            if (!startField.getTableName().equals(existing.getTableName())) continue;
            existing.setName(startField.getName());
            return;
        }
        this.startFields.addElement(startField);
    }

    public void setStartFieldType(Class type) {
        Enumeration enumtr = this.startFields.elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField existing = (DatabaseField)enumtr.nextElement();
            existing.setType(type);
        }
    }

    protected void setEndFields(Vector endFields) {
        this.endFields = endFields;
    }

    public void addEndFieldName(String endFieldName) {
        DatabaseField endField = new DatabaseField(endFieldName);
        endField.setType(ClassConstants.TIMESTAMP);
        if (this.endFields == null) {
            this.endFields = NonSynchronizedVector.newInstance();
            this.endFields.addElement(endField);
            return;
        }
        Enumeration enumtr = this.endFields.elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField existing = (DatabaseField)enumtr.nextElement();
            if (!endField.getTableName().equals(existing.getTableName())) continue;
            existing.setName(endField.getName());
            return;
        }
        this.endFields.addElement(endField);
    }

    public void setEndFieldType(String fieldName, Class type) {
        Enumeration enumtr = this.endFields.elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField existing = (DatabaseField)enumtr.nextElement();
            existing.setType(type);
        }
    }

    public void setShouldHandleWrites(boolean value) {
        this.shouldHandleWrites = value;
    }

    public boolean shouldHandleWrites() {
        return this.shouldHandleWrites;
    }

    public void setShouldUseDatabaseTime(boolean value) {
        this.usesLocalTime = !value;
    }

    public boolean shouldUseLocalTime() {
        return this.usesLocalTime;
    }

    public boolean shouldUseDatabaseTime() {
        return !this.usesLocalTime;
    }

    public void useLocalTime() {
        this.usesLocalTime = true;
    }

    public void useDatabaseTime() {
        this.usesLocalTime = false;
    }

    protected void verifyTableQualifiers(DatasourcePlatform platform) {
        String tableQualifier = platform.getTableQualifier();
        if (tableQualifier.length() == 0) {
            return;
        }
        Enumeration tableEnumeration = this.getHistoricalTables().elements();
        while (tableEnumeration.hasMoreElements()) {
            HistoricalDatabaseTable table = (HistoricalDatabaseTable)tableEnumeration.nextElement();
            DatabaseTable scratchTable = new DatabaseTable(table.getQualifiedName());
            if (scratchTable.getTableQualifier().length() != 0) continue;
            scratchTable.setTableQualifier(tableQualifier);
            table.setHistoricalName(scratchTable.getQualifiedNameDelimited(platform));
        }
    }

    protected boolean checkWastedVersioning(AbstractRecord modifyRow, DatabaseTable table) {
        Enumeration fieldsEnum = modifyRow.keys();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField field = (DatabaseField)fieldsEnum.nextElement();
            if (!field.getTable().equals(table) && field.hasTableName()) continue;
            return true;
        }
        return false;
    }

    public void postDelete(ModifyQuery deleteQuery) {
        this.logicalDelete(deleteQuery, false);
    }

    public void postUpdate(ObjectLevelModifyQuery writeQuery) {
        this.postUpdate(writeQuery, false);
    }

    public void postUpdate(ObjectLevelModifyQuery writeQuery, boolean isShallow) {
        this.logicalDelete(writeQuery, true, isShallow);
        this.logicalInsert(writeQuery, true);
    }

    public void postInsert(ObjectLevelModifyQuery writeQuery) {
        this.logicalInsert(writeQuery, false);
    }

    public void logicalInsert(ObjectLevelModifyQuery writeQuery, boolean isUpdate) {
        ClassDescriptor descriptor = this.getDescriptor();
        AbstractRecord modifyRow = null;
        AbstractRecord originalModifyRow = writeQuery.getModifyRow();
        Object currentTime = null;
        if (isUpdate) {
            modifyRow = descriptor.getObjectBuilder().buildRow(writeQuery.getObject(), writeQuery.getSession(), DatabaseMapping.WriteType.UPDATE);
            modifyRow.putAll((Map)originalModifyRow);
        } else {
            modifyRow = originalModifyRow;
            currentTime = this.getCurrentTime(writeQuery.getSession());
        }
        StatementQueryMechanism insertMechanism = new StatementQueryMechanism(writeQuery);
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            DatabaseTable table = (DatabaseTable)this.getHistoricalTables().elementAt(i);
            if (isUpdate && !this.checkWastedVersioning(originalModifyRow, table)) continue;
            if (!isUpdate) {
                modifyRow.add(this.getStart(i), currentTime);
            }
            SQLInsertStatement insertStatement = new SQLInsertStatement();
            insertStatement.setTable(table);
            insertMechanism.getSQLStatements().add(insertStatement);
        }
        if (insertMechanism.hasMultipleStatements()) {
            writeQuery.setTranslationRow(modifyRow);
            writeQuery.setModifyRow(modifyRow);
            insertMechanism.insertObject();
        }
    }

    public void mappingLogicalInsert(DataModifyQuery originalQuery, AbstractRecord arguments, AbstractSession session) {
        DataModifyQuery historyQuery = new DataModifyQuery();
        SQLInsertStatement historyStatement = new SQLInsertStatement();
        DatabaseTable histTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
        historyStatement.setTable(histTable);
        AbstractRecord modifyRow = originalQuery.getModifyRow().clone();
        AbstractRecord translationRow = arguments.clone();
        if (!modifyRow.containsKey(this.getStart())) {
            Object time = this.getCurrentTime(session);
            modifyRow.add(this.getStart(), time);
            translationRow.add(this.getStart(), time);
        }
        historyQuery.setSQLStatement(historyStatement);
        historyQuery.setModifyRow(modifyRow);
        historyStatement.setModifyRow(modifyRow);
        session.executeQuery((DatabaseQuery)historyQuery, translationRow);
    }

    public void logicalDelete(ModifyQuery writeQuery, boolean isUpdate) {
        this.logicalDelete(writeQuery, isUpdate, false);
    }

    public void logicalDelete(ModifyQuery writeQuery, boolean isUpdate, boolean isShallow) {
        ClassDescriptor descriptor = writeQuery.getDescriptor();
        AbstractRecord originalModifyRow = writeQuery.getModifyRow();
        DatabaseRecord modifyRow = new DatabaseRecord();
        StatementQueryMechanism updateMechanism = new StatementQueryMechanism(writeQuery);
        Object currentTime = this.getCurrentTime(writeQuery.getSession());
        for (int i = 0; i < this.getHistoricalTables().size(); ++i) {
            DatabaseTable table = (DatabaseTable)this.getHistoricalTables().elementAt(i);
            if (isUpdate && !this.checkWastedVersioning(originalModifyRow, table)) continue;
            SQLUpdateStatement updateStatement = new SQLUpdateStatement();
            updateStatement.setTable(table);
            Expression whereClause = null;
            if (writeQuery instanceof DeleteAllQuery) {
                if (writeQuery.getSelectionCriteria() != null) {
                    whereClause = (Expression)writeQuery.getSelectionCriteria().clone();
                }
            } else {
                whereClause = descriptor.getObjectBuilder().buildPrimaryKeyExpression(table);
            }
            ExpressionBuilder builder = whereClause == null ? new ExpressionBuilder() : whereClause.getBuilder();
            whereClause = builder.getField(this.getEnd(i)).isNull().and(whereClause);
            updateStatement.setWhereClause(whereClause);
            modifyRow.add(this.getEnd(i), currentTime);
            if (isUpdate) {
                if (isShallow) {
                    Timestamp incrementedTime = (Timestamp)currentTime;
                    incrementedTime.setTime(incrementedTime.getTime() + this.getMinimumTimeIncrement(writeQuery.getSession()));
                    originalModifyRow.add(this.getStart(i), incrementedTime);
                } else {
                    originalModifyRow.add(this.getStart(i), currentTime);
                }
            }
            updateMechanism.getSQLStatements().add(updateStatement);
        }
        if (updateMechanism.hasMultipleStatements()) {
            writeQuery.setModifyRow(modifyRow);
            updateMechanism.updateObject();
            writeQuery.setModifyRow(originalModifyRow);
        }
    }

    public void mappingLogicalDelete(ModifyQuery originalQuery, AbstractRecord arguments, AbstractSession session) {
        SQLDeleteStatement originalStatement = (SQLDeleteStatement)originalQuery.getSQLStatement();
        DataModifyQuery historyQuery = new DataModifyQuery();
        SQLUpdateStatement historyStatement = new SQLUpdateStatement();
        DatabaseTable histTable = (DatabaseTable)this.getHistoricalTables().elementAt(0);
        historyStatement.setTable(histTable);
        Expression whereClause = (Expression)originalStatement.getWhereClause().clone();
        DatabaseField endField = this.getEnd();
        whereClause = whereClause.getBuilder().getField(endField).isNull().and(whereClause);
        historyStatement.setWhereClause(whereClause);
        DatabaseRecord modifyRow = new DatabaseRecord();
        AbstractRecord translationRow = arguments.clone();
        Object time = this.getCurrentTime(session);
        modifyRow.add(this.getEnd(), time);
        translationRow.add(this.getEnd(), time);
        historyStatement.setModifyRow(modifyRow);
        historyQuery.setSQLStatement(historyStatement);
        historyQuery.setModifyRow(modifyRow);
        session.executeQuery((DatabaseQuery)historyQuery, translationRow);
    }
}

