/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequenceConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;

public abstract class SequenceAdapter
extends SCAdapter
implements Nominative {
    public static final String PREALLOCATION_SIZE_PROPERTY = "preAllocationSize";
    public static final String NAME_PROPERTY = "name";
    private boolean isTheDefaultSequence;

    SequenceAdapter(SCAdapter parent, SequenceConfig scConfig) {
        super(parent, scConfig);
    }

    protected SequenceAdapter(SCAdapter parent, String name, int preallocationSize) {
        super(parent);
        this.setName(name);
        this.setPreallocationSize(new Integer(preallocationSize));
    }

    private final SequenceConfig sequence() {
        return (SequenceConfig)this.getModel();
    }

    @Override
    protected Object buildModel() {
        return new SequenceConfig();
    }

    @Override
    public String getName() {
        return this.sequence().getName();
    }

    public void setName(String name) {
        String old = this.sequence().getName();
        this.sequence().setName(name);
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public int getPreallocationSize() {
        Integer size = this.sequence().getPreallocationSize();
        return size != null ? size : 0;
    }

    public void setPreallocationSize(Integer size) {
        Integer old = this.sequence().getPreallocationSize();
        this.sequence().setPreallocationSize(new Integer(size));
        this.firePropertyChanged(PREALLOCATION_SIZE_PROPERTY, old, size);
    }

    @Override
    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getName());
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isNative() {
        return false;
    }

    public boolean isXMLFile() {
        return false;
    }

    public boolean isCustom() {
        return false;
    }

    public abstract SequenceType getType();

    public boolean isTheDefaultSequence() {
        return this.isTheDefaultSequence;
    }

    public void setTheDefaultSequence(boolean isTheDefaultSequence) {
        this.isTheDefaultSequence = isTheDefaultSequence;
    }
}

