/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.DoubleConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FieldRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.FloatConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.IntegerConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.InterfaceMethodRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.LongConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.MethodRefConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.NullConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.StringConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.UTF8Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public abstract class Constant {
    private ConstantPool pool;
    private byte tag;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_Utf8 = 1;

    static Constant nullConstant(ConstantPool pool, ClassFileDataInputStream stream) throws IOException {
        return new NullConstant(pool, 0, stream);
    }

    static Constant buildConstant(ConstantPool pool, ClassFileDataInputStream stream) throws IOException {
        return Constant.buildConstant(pool, stream.readU1(), stream);
    }

    private static Constant buildConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        switch (tag) {
            case 1: {
                return new UTF8Constant(pool, tag, stream);
            }
            case 3: {
                return new IntegerConstant(pool, tag, stream);
            }
            case 4: {
                return new FloatConstant(pool, tag, stream);
            }
            case 5: {
                return new LongConstant(pool, tag, stream);
            }
            case 6: {
                return new DoubleConstant(pool, tag, stream);
            }
            case 7: {
                return new ClassConstant(pool, tag, stream);
            }
            case 8: {
                return new StringConstant(pool, tag, stream);
            }
            case 9: {
                return new FieldRefConstant(pool, tag, stream);
            }
            case 10: {
                return new MethodRefConstant(pool, tag, stream);
            }
            case 11: {
                return new InterfaceMethodRefConstant(pool, tag, stream);
            }
            case 12: {
                return new NameAndTypeConstant(pool, tag, stream);
            }
        }
        throw new IOException("Invalid constant tag: " + tag);
    }

    Constant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        this.pool = pool;
        this.tag = tag;
        this.initialize(stream);
    }

    abstract void initialize(ClassFileDataInputStream var1) throws IOException;

    public String displayString() {
        StringWriter sw = new StringWriter(100);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        writer.print("tag: ");
        writer.print(this.tag);
        writer.print(" (");
        writer.print(this.description());
        writer.print(")");
    }

    public abstract String description();

    public void printFieldInitializationClauseOn(PrintWriter writer) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ConstantPool getPool() {
        return this.pool;
    }

    public byte getTag() {
        return this.tag;
    }

    public String utf8String(short index) {
        return this.pool.getUTF8String(index);
    }

    boolean consumesTwoPoolEntries() {
        return false;
    }

    public abstract Object value();

    public abstract void accept(Visitor var1);

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassTools.shortClassNameForObject(this));
        sb.append('(');
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    void toString(StringBuffer sb) {
        sb.append(this.value());
    }
}

