/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.buildtools.helper;

import org.eclipse.persistence.buildtools.helper.VersionException;

public class Version {
    private String identifier = "0.0";
    private Integer major = 0;
    private Integer minor = 0;
    private Integer micro = 0;
    private String qualifier = "";
    private int[] indexList = new int[]{0, 0, 0};

    private String validateIdentifier(String identifier) throws VersionException {
        String validated = identifier;
        boolean error = false;
        while (validated.startsWith(" ") || validated.startsWith("\t")) {
            validated = validated.substring(1);
        }
        while (validated.endsWith(" ") || validated.endsWith("\t")) {
            validated = validated.substring(0, validated.length() - 1);
        }
        if (validated.startsWith(".")) {
            throw new VersionException("Initial version tokenizer found (.): Invalid version string '" + validated + "'.");
        }
        if (validated.endsWith(".")) {
            throw new VersionException("Terminating version tokenizer found (.): Invalid version string '" + validated + "'.");
        }
        int index = 0;
        int subindex = 0;
        int count = 0;
        int maxindex = validated.lastIndexOf(".");
        while (!(error || (subindex = validated.substring(index).indexOf(".")) <= 0 && index >= maxindex)) {
            if (count > 2 && subindex > 0) {
                throw new VersionException("Maximum (4) tokens exceeded: Invalid version string '" + validated + "'.");
            }
            index += subindex;
            this.indexList[count] = index++;
            ++count;
        }
        return validated;
    }

    private void setMajor(Integer major) {
        this.major = major;
    }

    private void setMinor(Integer minor) {
        this.minor = minor;
    }

    private void setMicro(Integer micro) {
        this.micro = micro;
    }

    private void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    private void setAll(String identifier) throws VersionException {
        try {
            if (identifier != "") {
                if (this.indexList[0] > 0) {
                    this.setMajor(Integer.valueOf(identifier.substring(0, this.indexList[0])));
                    if (this.indexList[1] > 0) {
                        this.setMinor(Integer.valueOf(identifier.substring(this.indexList[0] + 1, this.indexList[1])));
                        if (this.indexList[2] > 0) {
                            this.setMicro(Integer.valueOf(identifier.substring(this.indexList[1] + 1, this.indexList[2])));
                            this.setQualifier(identifier.substring(this.indexList[2] + 1));
                        } else {
                            this.setMicro(Integer.valueOf(identifier.substring(this.indexList[1] + 1)));
                        }
                    } else {
                        this.setMinor(Integer.valueOf(identifier.substring(this.indexList[0] + 1)));
                    }
                } else {
                    this.setMajor(Integer.valueOf(identifier));
                }
            }
        }
        catch (NumberFormatException e) {
            throw new VersionException("Major.Minor.Micro tokens expected to be numeric. One or more is invalid. " + e.getMessage() + " in \"" + identifier + "\".", e);
        }
        String validIdentifier = this.getMajorStr() + "." + this.getMinorStr() + "." + this.getMicroStr();
        if (this.getQualifier() != null && this.getQualifier() != "") {
            validIdentifier = validIdentifier + "." + this.getQualifier();
        }
        this.identifier = validIdentifier;
    }

    public Version() {
    }

    public Version(String identifier) {
        this.setIdentifier(identifier);
    }

    public Integer getMajorInt() {
        return this.major;
    }

    public Integer getMinorInt() {
        return this.minor;
    }

    public Integer getMicroInt() {
        return this.micro;
    }

    public String getMajorStr() {
        return this.major.toString();
    }

    public String getMinorStr() {
        return this.minor.toString();
    }

    public String getMicroStr() {
        return this.micro.toString();
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.setAll(this.validateIdentifier(identifier));
    }

    public boolean gt(Version comp) {
        boolean result = false;
        if (this.major > comp.getMajorInt()) {
            result = true;
        } else if (this.major == comp.getMajorInt() && this.minor > comp.getMinorInt()) {
            result = true;
        } else if (this.major == comp.getMajorInt() && this.minor == comp.getMinorInt() && this.micro > comp.getMicroInt()) {
            result = true;
        } else if (this.major == comp.getMajorInt() && this.minor == comp.getMinorInt() && this.micro == comp.getMicroInt() && this.qualifier.compareTo(comp.getQualifier()) > 0) {
            result = true;
        }
        return result;
    }

    public boolean lt(Version comp) {
        boolean result = false;
        if (this.major < comp.getMajorInt()) {
            result = true;
        } else if (this.major == comp.getMajorInt() && this.minor < comp.getMinorInt()) {
            result = true;
        } else if (this.major == comp.getMajorInt() && this.minor == comp.getMinorInt() && this.micro < comp.getMicroInt()) {
            result = true;
        } else if (this.major == comp.getMajorInt() && this.minor == comp.getMinorInt() && this.micro == comp.getMicroInt() && this.qualifier.compareTo(comp.getQualifier()) < 0) {
            result = true;
        }
        return result;
    }

    public boolean eq(Version comp) {
        boolean result = false;
        if (this.major == comp.getMajorInt() && this.minor == comp.getMinorInt() && this.micro == comp.getMicroInt() && this.qualifier.compareTo(comp.getQualifier()) == 0) {
            result = true;
        }
        return result;
    }

    public boolean ge(Version comp) {
        boolean result = false;
        if (this.gt(comp) || this.eq(comp)) {
            result = true;
        }
        return result;
    }

    public boolean le(Version comp) {
        boolean result = false;
        if (this.lt(comp) || this.eq(comp)) {
            result = true;
        }
        return result;
    }

    public boolean empty() {
        boolean result = false;
        if (this.major == 0 && this.minor == 0 && this.micro == 0 && this.qualifier.compareTo("") == 0) {
            result = true;
        }
        return result;
    }
}

