/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.visit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.BaseDatabaseTypeVisitor;

class FunctionTypeVisitor
extends BaseDatabaseTypeVisitor {
    public String funcName;
    public String schema;
    public List<String> argData = new ArrayList<String>();
    public String returnArg;

    FunctionTypeVisitor() {
    }

    @Override
    public void beginVisit(FunctionType funcType) {
        this.funcName = funcType.getProcedureName();
        this.schema = funcType.getSchema();
        this.returnArg = funcType.getReturnArgument().getTypeName();
    }

    @Override
    public void beginVisit(ArgumentType argType) {
        if (argType.optional()) {
            this.argData.add(String.valueOf(argType.getArgumentName()) + "(opt) " + (Object)((Object)argType.getDirection()) + " " + argType.getEnclosedType());
        } else if (argType.getDirection() != ArgumentTypeDirection.RETURN) {
            this.argData.add(String.valueOf(argType.getArgumentName()) + " " + (Object)((Object)argType.getDirection()) + " " + argType.getEnclosedType());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FUNCTION ");
        if (this.schema != null) {
            sb.append(this.schema);
            sb.append(".");
        }
        sb.append(this.funcName);
        sb.append(" (");
        int i = 0;
        while (i < this.argData.size()) {
            String arg = this.argData.get(i);
            sb.append(arg);
            if (++i >= this.argData.size()) continue;
            sb.append(", ");
        }
        sb.append(") RETURN ");
        sb.append(this.returnArg);
        return sb.toString();
    }
}

