/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.sessions.CopyGroup;

public class AttributeItem
implements Serializable {
    private String attributeName;
    private AttributeGroup parent;
    private AttributeGroup group;
    protected AttributeGroup keyGroup;
    private Map<Object, AttributeGroup> subGroups;
    protected Map<Object, AttributeGroup> keyGroups;

    protected AttributeItem() {
    }

    public AttributeItem(AttributeGroup parent, String attributeName) {
        this.parent = parent;
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public AttributeGroup getGroup() {
        if (this.group == null) {
            return null;
        }
        return this.group;
    }

    public AttributeGroup getGroup(Class type) {
        if (this.subGroups == null || type == null) {
            return null;
        }
        AttributeGroup result = this.subGroups.get(type);
        while (result == null && !type.equals(ClassConstants.Object_Class)) {
            if ((type = type.getSuperclass()) == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("subclass_sought_not_a_managed_type", new Object[]{type.toString(), this.attributeName}));
            }
            result = this.subGroups.get(type);
        }
        return result;
    }

    public Map<Object, AttributeGroup> getGroups() {
        return this.subGroups;
    }

    public void setRootGroup(AttributeGroup group) {
        this.group = group;
        this.addSubGroup(group);
    }

    public void addSubGroup(AttributeGroup group) {
        if (group != null) {
            Object type;
            if (this.subGroups == null) {
                this.subGroups = new HashMap<Object, AttributeGroup>();
            }
            if (this.group == null) {
                this.group = group;
            }
            if ((type = group.getType()) == null) {
                type = group.getTypeName();
            }
            if (type == null && this.subGroups.containsKey(type = ClassConstants.Object_Class)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("only_one_root_subgraph"));
            }
            this.subGroups.put(type, group);
            if (AttributeItem.orderInheritance(group, this.subGroups)) {
                group.insertSubClass(this.group);
                this.group = group;
            }
        }
    }

    public static boolean orderInheritance(AttributeGroup group, Map<Object, AttributeGroup> subGroups) {
        Class type = group.getType();
        if (type != null) {
            AttributeGroup superClass = null;
            while (!type.equals(ClassConstants.Object_Class) && superClass == null) {
                type = type.getSuperclass();
                superClass = subGroups.get(type);
            }
            if (superClass != null) {
                superClass.insertSubClass(group);
            } else {
                return true;
            }
        }
        return false;
    }

    public AttributeGroup getKeyGroup() {
        if (this.keyGroups == null) {
            return null;
        }
        return this.keyGroups.get(ClassConstants.Object_Class);
    }

    public AttributeGroup getKeyGroup(Class type) {
        if (this.keyGroups == null || type == null) {
            return null;
        }
        AttributeGroup result = this.keyGroups.get(type);
        while (result == null && !type.equals(ClassConstants.Object_Class)) {
            if ((type = type.getSuperclass()) == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("subclass_sought_not_a_managed_type", new Object[]{type.toString(), this.attributeName}));
            }
            result = this.keyGroups.get(type);
        }
        return result;
    }

    public Map<Object, AttributeGroup> getKeyGroups() {
        return this.keyGroups;
    }

    public void addKeyGroup(AttributeGroup keyGroup) {
        if (keyGroup != null) {
            Object type;
            if (this.keyGroups == null) {
                this.keyGroups = new HashMap<Object, AttributeGroup>();
            }
            if (this.keyGroup == null) {
                this.keyGroup = keyGroup;
            }
            if ((type = keyGroup.getType()) == null) {
                type = keyGroup.getTypeName();
            }
            if (type == null && this.keyGroups.containsKey(type = ClassConstants.Object_Class)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("only_one_root_subgraph"));
            }
            this.keyGroups.put(type, keyGroup);
            if (AttributeItem.orderInheritance(keyGroup, this.keyGroups)) {
                keyGroup.insertSubClass(this.keyGroup);
                this.keyGroup = keyGroup;
            }
        }
    }

    public void addKeyGroups(Collection<AttributeGroup> keyGroups) {
        for (AttributeGroup group : keyGroups) {
            this.addKeyGroup(group);
        }
    }

    public AttributeItem clone(Map<AttributeGroup, AttributeGroup> cloneMap, AttributeGroup parentClone) {
        AttributeItem clone = new AttributeItem();
        clone.attributeName = this.attributeName;
        if (this.group != null) {
            clone.group = this.group.clone(cloneMap);
        }
        if (clone.keyGroup != null) {
            clone.keyGroup = this.keyGroup.clone(cloneMap);
        }
        clone.parent = parentClone;
        if (this.subGroups != null) {
            clone.subGroups = new HashMap<Object, AttributeGroup>();
            for (Map.Entry<Object, AttributeGroup> group : this.subGroups.entrySet()) {
                clone.subGroups.put(group.getKey(), group.getValue().clone(cloneMap));
            }
        }
        if (this.keyGroups != null) {
            clone.keyGroups = new HashMap<Object, AttributeGroup>();
            for (Map.Entry<Object, AttributeGroup> group : this.keyGroups.entrySet()) {
                clone.keyGroups.put(group.getKey(), group.getValue().clone(cloneMap));
            }
        }
        return clone;
    }

    public AttributeItem toCopyGroup(Map<AttributeGroup, CopyGroup> cloneMap, CopyGroup parentClone, Map copies) {
        AttributeItem clone = new AttributeItem();
        clone.attributeName = this.attributeName;
        if (this.group != null) {
            clone.group = this.group.toCopyGroup(cloneMap, copies);
        }
        if (clone.keyGroup != null) {
            clone.keyGroup = this.keyGroup.toCopyGroup(cloneMap, copies);
        }
        clone.parent = parentClone;
        if (this.subGroups != null) {
            clone.subGroups = new HashMap<Object, AttributeGroup>();
            for (Map.Entry<Object, AttributeGroup> group : this.subGroups.entrySet()) {
                clone.subGroups.put(group.getKey(), group.getValue().toCopyGroup(cloneMap, copies));
            }
        }
        if (this.keyGroups != null) {
            clone.keyGroups = new HashMap<Object, AttributeGroup>();
            for (Map.Entry<Object, AttributeGroup> group : this.keyGroups.entrySet()) {
                clone.keyGroups.put(group.getKey(), group.getValue().toCopyGroup(cloneMap, copies));
            }
        }
        return clone;
    }

    public AttributeItem toFetchGroup(Map<AttributeGroup, FetchGroup> cloneMap, FetchGroup parentClone) {
        AttributeItem clone = new AttributeItem();
        clone.attributeName = this.attributeName;
        if (this.group != null) {
            clone.group = this.group.toFetchGroup(cloneMap);
        }
        if (clone.keyGroup != null) {
            clone.keyGroup = this.keyGroup.toFetchGroup(cloneMap);
        }
        clone.parent = parentClone;
        if (this.subGroups != null) {
            clone.subGroups = new HashMap<Object, AttributeGroup>();
            for (Map.Entry<Object, AttributeGroup> group : this.subGroups.entrySet()) {
                clone.subGroups.put(group.getKey(), group.getValue().toFetchGroup(cloneMap));
            }
        }
        if (this.keyGroups != null) {
            clone.keyGroups = new HashMap<Object, AttributeGroup>();
            for (Map.Entry<Object, AttributeGroup> group : this.keyGroups.entrySet()) {
                clone.keyGroups.put(group.getKey(), group.getValue().toFetchGroup(cloneMap));
            }
        }
        return clone;
    }

    public AttributeItem toLoadGroup(Map<AttributeGroup, LoadGroup> cloneMap, LoadGroup parentClone, boolean loadOnly) {
        AttributeItem clone = new AttributeItem();
        clone.attributeName = this.attributeName;
        if (this.group != null) {
            clone.group = this.group.toLoadGroup(cloneMap, loadOnly);
        }
        if (clone.keyGroup != null) {
            clone.keyGroup = this.keyGroup.toLoadGroup(cloneMap, loadOnly);
        }
        clone.parent = parentClone;
        if (this.subGroups != null) {
            clone.subGroups = new HashMap<Object, AttributeGroup>();
            for (Map.Entry<Object, AttributeGroup> group : this.subGroups.entrySet()) {
                clone.subGroups.put(group.getKey(), group.getValue().toLoadGroup(cloneMap, loadOnly));
            }
        }
        if (this.keyGroups != null) {
            clone.keyGroups = new HashMap<Object, AttributeGroup>();
            for (Map.Entry<Object, AttributeGroup> group : this.keyGroups.entrySet()) {
                clone.keyGroups.put(group.getKey(), group.getValue().toLoadGroup(cloneMap, loadOnly));
            }
        }
        return clone;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        HashMap<Object, AttributeGroup> newMap = new HashMap<Object, AttributeGroup>();
        if (this.subGroups != null) {
            for (AttributeGroup entry : this.subGroups.values()) {
                entry.convertClassNamesToClasses(classLoader);
                newMap.put(entry.getType(), entry);
                entry.setAllSubclasses(newMap);
            }
        }
        this.subGroups = newMap;
        newMap = new HashMap();
        if (this.keyGroups != null) {
            for (AttributeGroup entry : this.keyGroups.values()) {
                entry.convertClassNamesToClasses(classLoader);
                newMap.put(entry.getType(), entry);
                entry.setAllSubclasses(newMap);
            }
        }
        this.keyGroups = newMap;
        for (AttributeGroup group : this.subGroups.values()) {
            if (!AttributeItem.orderInheritance(group, this.subGroups)) continue;
            group.insertSubClass(this.group);
            this.group = group;
        }
        for (AttributeGroup group : this.keyGroups.values()) {
            if (!AttributeItem.orderInheritance(group, this.keyGroups)) continue;
            group.insertSubClass(this.keyGroup);
            this.keyGroup = group;
        }
    }

    public AttributeGroup getParent() {
        return this.parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        AttributeGroup anotherGroup;
        if (this == obj) return true;
        if (obj == null) {
            return false;
        }
        AttributeItem anotherItem = null;
        try {
            anotherItem = (AttributeItem)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.subGroups != null) {
            if (anotherItem.subGroups == null) {
                return false;
            }
            if (this.subGroups.size() != anotherItem.subGroups.size()) return false;
            for (Map.Entry<Object, AttributeGroup> entry : this.subGroups.entrySet()) {
                anotherGroup = anotherItem.subGroups.get(entry.getKey());
                if (entry.getValue().equals(anotherGroup)) continue;
                return false;
            }
        } else if (anotherItem.subGroups != null) {
            return false;
        }
        if (this.keyGroups != null) {
            if (anotherItem.keyGroups == null) {
                return false;
            }
            if (this.keyGroups.size() != anotherItem.keyGroups.size()) return false;
            for (Map.Entry<Object, AttributeGroup> entry : this.keyGroups.entrySet()) {
                anotherGroup = anotherItem.keyGroups.get(entry.getKey());
                if (entry.getValue().equals(anotherGroup)) continue;
                return false;
            }
            return true;
        } else {
            if (anotherItem.keyGroups == null) return true;
            return false;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getAttributeName() + ")" + (this.subGroups != null ? " => " + this.subGroups.toString() : "") + (this.keyGroups != null ? " => " + this.keyGroups.toString() : "");
    }

    public String toStringNoClassName() {
        return String.valueOf(this.getAttributeName()) + (this.subGroups != null ? " => " + this.subGroups.toString() : "") + (this.keyGroups != null ? " => " + this.keyGroups.toString() : "");
    }

    public void addGroups(Collection<AttributeGroup> groups) {
        for (AttributeGroup group : groups) {
            this.addSubGroup(group);
        }
    }
}

