/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.Address;
import org.eclipse.persistence.testing.models.readonly.Country;

public class ReadOnlyClassDeleteTestCase
extends AutoVerifyTestCase {
    public Address address;

    public void reset() {
        this.getSession().getProject().setDefaultReadOnlyClasses(new Vector());
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        this.address = new Address();
        this.address.setStreetAddress("1212 Madison Street");
        this.address.setCity("Victoria");
        this.address.setZipCode("V3Z 3G1");
        Country aCountry = (Country)this.getSession().readObject(Country.class);
        this.address.setCountry(aCountry);
        this.beginTransaction();
        this.getDatabaseSession().writeObject((Object)this.address);
        this.commitTransaction();
    }

    protected void test() {
        Vector countries = this.getSession().readAllObjects(Country.class);
        Vector<Class<Country>> readOnlyClasses = new Vector<Class<Country>>();
        readOnlyClasses.addElement(Country.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.removeAllReadOnlyClasses();
        uow.addReadOnlyClasses(readOnlyClasses);
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("streetAddress").equal((Object)this.address.getStreet());
        Address readAddress = (Address)uow.readObject(Address.class, exp);
        uow.deleteObject((Object)readAddress);
        uow.commit();
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("streetAddress").equal((Object)this.address.getStreet());
        Address dbAddress = (Address)this.getSession().readObject(Address.class, exp);
        if (dbAddress != null) {
            throw new TestErrorException("The delete of a non-read-only object referring to a read-only object failed. We should be able to do this!");
        }
        ExpressionBuilder expBuilder2 = new ExpressionBuilder();
        Expression exp2 = expBuilder2.get("name").equal((Object)this.address.getCountry().getName());
        Country aCountry = (Country)this.getSession().readObject(Country.class, exp2);
        if (aCountry == null) {
            throw new TestErrorException("during the  delete of a non-read-only object referring to a read-only object, the read-only object was also deleted. This should not have happened!");
        }
    }
}

