/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import junit.framework.Test;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.transparentindirection.BidirectionalRelationshipSystem;
import org.eclipse.persistence.testing.models.transparentindirection.CustomIndirectContainerSystem;
import org.eclipse.persistence.testing.models.transparentindirection.Dog;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectListSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectMapSystem;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectSetSystem;
import org.eclipse.persistence.testing.tests.transparentindirection.BidirectionalRelationshipMaintenanceTest;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectListTestAPI;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectListTestDatabase;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectMapTestAPI;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectMapTestDatabase;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectSetTestAPI;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectSetTestDatabase;
import org.eclipse.persistence.testing.tests.transparentindirection.NullCollectionTest;
import org.eclipse.persistence.testing.tests.transparentindirection.NullDelegateInValueHolderTest;
import org.eclipse.persistence.testing.tests.transparentindirection.UpdateDogTest;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class TransparentIndirectionModel
extends TestModel {
    public TransparentIndirectionModel() {
        this.setDescription("Test Transparent Indirection");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new IndirectListSystem());
        this.addRequiredSystem(new IndirectMapSystem());
        this.addRequiredSystem(new IndirectSetSystem());
        this.addRequiredSystem(new CustomIndirectContainerSystem());
        this.addRequiredSystem(new BidirectionalRelationshipSystem());
    }

    public void addTests() {
        this.addTest((Test)new ZTestSuite(IndirectListTestAPI.class));
        this.addTest((Test)new ZTestSuite(IndirectMapTestAPI.class));
        this.addTest((Test)new ZTestSuite(IndirectSetTestAPI.class));
        this.addTest((Test)new ZTestSuite(IndirectListTestDatabase.class));
        this.addTest((Test)new ZTestSuite(IndirectMapTestDatabase.class));
        this.addTest((Test)new ZTestSuite(IndirectSetTestDatabase.class));
        this.addTest((Test)this.getCustomIndirectContainerTestSuite());
        this.addTest((Test)this.getBidirectionalRelationshipTestSuite());
        this.addTest((Test)this.getNullDelegateInValueHolderTestSuite());
    }

    public TestSuite getCustomIndirectContainerTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomIndirectContainerTestSuite");
        suite.setDescription("This suite tests custom IndirectContainers.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Dog.class, "Bart")));
        suite.addTest((Test)new UpdateDogTest());
        suite.addTest((Test)new NullCollectionTest());
        return suite;
    }

    public TestSuite getBidirectionalRelationshipTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BidirectionalRelationshipTestSuite");
        suite.setDescription("This suite tests bidirectional relationship maintenance.");
        suite.addTest((Test)new BidirectionalRelationshipMaintenanceTest());
        return suite;
    }

    public TestSuite getNullDelegateInValueHolderTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("NullDelegateInValueHolderTestSuite");
        suite.setDescription("This suite tests setting a ValueHolder in a transparent collection");
        suite.addTest((Test)new NullDelegateInValueHolderTest(IndirectList.class));
        suite.addTest((Test)new NullDelegateInValueHolderTest(IndirectSet.class));
        suite.addTest((Test)new NullDelegateInValueHolderTest(IndirectMap.class));
        return suite;
    }
}

