/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TogglingFastTableCreator
extends TableCreator {
    protected static Set fastTableCreators = new HashSet();
    protected static boolean useFastTableCreatorAfterInitialCreate = Boolean.getBoolean("eclipselink.test.toggle-fast-table-creator");

    public TogglingFastTableCreator() {
    }

    public TogglingFastTableCreator(Vector tableDefinitions) {
        super((List)tableDefinitions);
    }

    public void replaceTables(DatabaseSession session) {
        session.getSessionLog().log(1, "TogglingFastTableCreator: useFastTableCreatorAfterInitialCreate: " + useFastTableCreatorAfterInitialCreate);
        boolean isFirstCreate = !this.isFastTableCreator();
        session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " - isFirstCreate: " + isFirstCreate);
        session.getSessionLog().log(1, "TogglingFastTableCreator: Current fastTableCreators: " + fastTableCreators);
        if (useFastTableCreatorAfterInitialCreate && !isFirstCreate) {
            session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " - toggling true");
            String sequenceTableName = this.getSequenceTableName((Session)session);
            List tables = this.getTableDefinitions();
            for (TableDefinition table : tables) {
                if (table.getName().equals(sequenceTableName)) continue;
                SchemaManager schemaManager = new SchemaManager(session);
                AbstractSession abstarctSession = schemaManager.getSession();
                try {
                    abstarctSession.priviledgedExecuteNonSelectingCall((Call)new SQLCall("DELETE FROM " + table.getFullName()));
                }
                catch (DatabaseException ex) {}
            }
        } else {
            super.replaceTables(session);
        }
        if (useFastTableCreatorAfterInitialCreate) {
            this.setFastTableCreator();
            session.getSessionLog().log(1, "TogglingFastTableCreator: " + this.getTableCreatorName() + " added to fastTableCreators");
        }
    }

    public boolean resetFastTableCreator() {
        AbstractSessionLog.getLog().log(1, "TogglingFastTableCreator: removing table creator: " + this.getTableCreatorName());
        return fastTableCreators.remove(this.getTableCreatorName());
    }

    public boolean setFastTableCreator() {
        AbstractSessionLog.getLog().log(1, "TogglingFastTableCreator: adding table creator: " + this.getTableCreatorName());
        return fastTableCreators.add(this.getTableCreatorName());
    }

    public boolean isFastTableCreator() {
        return fastTableCreators.contains(this.getTableCreatorName());
    }

    public String getTableCreatorName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

