/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblem;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationProblemContainer;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.internal.ProblemReportAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ProblemsViewHelpAction;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTableCellRenderer;

final class ProblemsView {
    private ListValueModel applicationProblemsAdapter;
    private ListValueModel branchApplicationProblemsAdapter;
    private TableModelAdapter tableModel;
    private ListSelectionModel tableSelectionModel;
    private NavigatorSelectionModel navigatorSelectionModel;
    private Action problemReportAction;
    JPopupMenu popupMenu;
    private MouseListener popupMenuMouseListener;
    private KeyListener keyListener;
    private JPanel component;

    ProblemsView(ValueModel appProblemContainerHolder, NavigatorSelectionModel navigatorSelectionModel, WorkbenchContext context) {
        this.navigatorSelectionModel = navigatorSelectionModel;
        this.initialize(appProblemContainerHolder, context);
    }

    private void initialize(ValueModel appProblemContainerHolder, WorkbenchContext context) {
        if (appProblemContainerHolder == null) {
            throw new NullPointerException();
        }
        this.applicationProblemsAdapter = this.buildApplicationProblemsAdapter(appProblemContainerHolder);
        this.branchApplicationProblemsAdapter = this.buildBranchApplicationProblemsAdapter(appProblemContainerHolder);
        ResourceRepository resourceRepository = context.getApplicationContext().getResourceRepository();
        this.tableModel = new TableModelAdapter(this.branchApplicationProblemsAdapter, this.buildColumnAdapter(resourceRepository));
        this.tableSelectionModel = new DefaultListSelectionModel();
        this.tableSelectionModel.setSelectionMode(0);
        this.problemReportAction = new ProblemReportAction(appProblemContainerHolder, context);
        this.popupMenu = this.buildPopupMenu(context);
        this.popupMenuMouseListener = this.buildPopupMenuMouseListener();
        this.keyListener = this.buildKeyListener(context.getApplicationContext().getHelpManager());
        this.component = this.buildComponent(resourceRepository);
    }

    private ListValueModel buildApplicationProblemsAdapter(ValueModel appProblemContainerHolder) {
        return new ListAspectAdapter(appProblemContainerHolder, "applicationProblems"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((ApplicationProblemContainer)this.subject).applicationProblems();
            }

            @Override
            protected int sizeFromSubject() {
                return ((ApplicationProblemContainer)this.subject).applicationProblemsSize();
            }
        };
    }

    private ListValueModel buildBranchApplicationProblemsAdapter(ValueModel appProblemContainerHolder) {
        return new ListAspectAdapter(appProblemContainerHolder, "branchApplicationProblems"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((ApplicationProblemContainer)this.subject).branchApplicationProblems();
            }

            @Override
            protected int sizeFromSubject() {
                return ((ApplicationProblemContainer)this.subject).branchApplicationProblemsSize();
            }
        };
    }

    private ColumnAdapter buildColumnAdapter(ResourceRepository resourceRepository) {
        return new ProblemColumnAdapter(resourceRepository);
    }

    private JPopupMenu buildPopupMenu(WorkbenchContext context) {
        JPopupMenu result = new JPopupMenu();
        result.add(this.problemReportAction);
        result.add(new ProblemsViewHelpAction(context));
        return result;
    }

    private KeyListener buildKeyListener(final HelpManager helpManager) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!e.isConsumed() && e.getKeyCode() == 112) {
                    helpManager.showTopic("problemsPane");
                    e.consume();
                }
            }
        };
    }

    private JPanel buildComponent(ResourceRepository resourceRepository) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setMinimumSize(new Dimension(0, 0));
        JLabel label = new JLabel(resourceRepository.getString("PROBLEMS_LABEL"));
        label.setDisplayedMnemonic(resourceRepository.getMnemonic("PROBLEMS_LABEL"));
        label.setIcon(resourceRepository.getIcon("problems"));
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, panel.getBackground().brighter()), BorderFactory.createMatteBorder(0, 0, 1, 0, panel.getBackground().darker())), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        label.setLabelFor(panel);
        panel.add((Component)label, "First");
        JTable problemsTable = this.buildTable();
        JScrollPane scrollPane = new JScrollPane(problemsTable);
        scrollPane.getViewport().setBackground(problemsTable.getBackground());
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, "Center");
        panel.addMouseListener(this.popupMenuMouseListener);
        panel.addKeyListener(this.keyListener);
        return panel;
    }

    private JTable buildTable() {
        JTable table = new JTable(this.tableModel, null, this.tableSelectionModel);
        table.setDoubleBuffered(true);
        table.setRowHeight(20);
        TableColumn nodeColumn = table.getColumnModel().getColumn(0);
        nodeColumn.setCellRenderer(new DisplayableTableCellRenderer());
        nodeColumn.setPreferredWidth(100);
        table.getColumnModel().getColumn(1).setPreferredWidth(20);
        table.getColumnModel().getColumn(2).setPreferredWidth(500);
        table.addMouseListener(this.buildTableMouseListener());
        table.addMouseListener(this.popupMenuMouseListener);
        table.addKeyListener(this.keyListener);
        return table;
    }

    private MouseListener buildTableMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProblemsView.this.tableDoubleClicked();
                }
            }
        };
    }

    private MouseListener buildPopupMenuMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            private void handleMouseEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ProblemsView.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
    }

    Component getComponent() {
        return this.component;
    }

    Action getProblemReportAction() {
        return this.problemReportAction;
    }

    void toggle() {
        if (this.tableModel.getModel() == this.applicationProblemsAdapter) {
            this.tableModel.setModel(this.branchApplicationProblemsAdapter);
        } else {
            this.tableModel.setModel(this.applicationProblemsAdapter);
        }
    }

    void tableDoubleClicked() {
        int sel = this.tableSelectionModel.getMinSelectionIndex();
        ApplicationProblem ap = (ApplicationProblem)this.tableModel.getModel().getItem(sel);
        this.navigatorSelectionModel.setSelectedNode(ap.getSource());
    }

    void close() {
    }

    private static class ProblemColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        static final int COLUMN_COUNT = 3;
        static final int NODE_COLUMN = 0;
        static final int CODE_COLUMN = 1;
        static final int MESSAGE_COLUMN = 2;
        private static final String[] COLUMN_NAMES = new String[]{"PROBLEM_NODE", "PROBLEM_CODE", "PROBLEM_MESSAGE"};

        ProblemColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAMES[index]);
        }

        @Override
        public Class getColumnClass(int index) {
            return Object.class;
        }

        @Override
        public boolean isColumnEditable(int index) {
            return false;
        }

        @Override
        public PropertyValueModel[] cellModels(Object subject) {
            ApplicationProblem problem = (ApplicationProblem)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{new ReadOnlyPropertyValueModel(problem.getSource()), new ReadOnlyPropertyValueModel(problem.getMessageCode()), new ReadOnlyPropertyValueModel(problem.getMessage())};
            return result;
        }
    }
}

