/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;

public class DeleteSessionAction
extends AbstractEnablableFrameworkAction {
    public DeleteSessionAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeText("DELETE_SESSION");
        this.initializeMnemonic("DELETE_SESSION");
        this.initializeToolTipText("DELETE_SESSION.TOOL_TIP");
        this.initializeIcon("DELETE");
    }

    @Override
    protected void execute(ApplicationNode selectedNode) {
        SessionAdapter session = (SessionAdapter)selectedNode.getValue();
        TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)session.getParent();
        if (!this.canRemoveSessions(topLinkSessions, session)) {
            return;
        }
        if (session.isManaged()) {
            DatabaseSessionAdapter dbSession = (DatabaseSessionAdapter)session;
            dbSession.getBroker().unManage(session.getName());
        } else {
            topLinkSessions.removeSession(session);
        }
        this.navigatorSelectionModel().setSelectedNode((ApplicationNode)selectedNode.getParent());
    }

    protected boolean canRemoveSessions(TopLinkSessionsAdapter topLinkSessions, SessionAdapter session) {
        if (session.isManaged()) {
            return true;
        }
        String name = topLinkSessions.getName();
        int confirmation = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_MULTI", name), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_MULTI_TITLE"), 0);
        return confirmation == 0;
    }

    @Override
    public void execute() {
        super.execute();
    }

    @Override
    protected void updateEnabledState() {
        ApplicationNode[] nodes = this.selectedNodes();
        Vector<SessionAdapter> unmanagedSessions = new Vector<SessionAdapter>();
        if (nodes.length > 0) {
            for (int index = 0; index < nodes.length; ++index) {
                ApplicationNode node = nodes[index];
                SessionAdapter session = (SessionAdapter)node.getValue();
                if (!session.isManaged()) continue;
                unmanagedSessions.add(session);
            }
        }
        if (unmanagedSessions.size() > 0 && nodes.length == unmanagedSessions.size()) {
            this.initializeText("UNMANAGED_SESSION");
            this.initializeMnemonic("UNMANAGED_SESSION");
            this.initializeToolTipText("UNMANAGED_SESSION.TOOL_TIP");
            this.initializeIcon("REMOVE");
        } else {
            this.initializeText("DELETE_SESSION");
            this.initializeMnemonic("DELETE_SESSION");
            this.initializeToolTipText("DELETE_SESSION.TOOL_TIP");
            this.initializeIcon("DELETE");
        }
    }

    @Override
    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        throw new UnsupportedOperationException();
    }
}

