/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileIterator;

public class ClassDependencyGraph {
    private Collection nodes;
    private Map allNodes;

    public ClassDependencyGraph(String classpathEntry) {
        this(new ClassFileIterator(classpathEntry));
    }

    public ClassDependencyGraph(Iterator classFiles) {
        this.initialize(classFiles);
    }

    private void initialize(Iterator classFiles) {
        ArrayList<String> tempNames = new ArrayList<String>(500);
        this.allNodes = new HashMap(500);
        while (classFiles.hasNext()) {
            ClassFile classFile = (ClassFile)classFiles.next();
            tempNames.add(classFile.className());
            this.addClassDependencyNode(classFile);
        }
        this.nodes = new ArrayList(500);
        Iterator stream = tempNames.iterator();
        while (stream.hasNext()) {
            this.nodes.add(this.allNodes.get(stream.next()));
        }
        stream = this.nodes.iterator();
        while (stream.hasNext()) {
            ((Node)stream.next()).addReferencingNodesFrom(this.nodes);
        }
    }

    private void addClassDependencyNode(ClassFile classFile) {
        String className = classFile.className();
        Node node = (Node)this.allNodes.get(className);
        if (node == null) {
            node = new Node(className);
            this.allNodes.put(className, node);
        }
        node.initialize(classFile, this.allNodes);
    }

    public Iterator nodes() {
        return this.nodes.iterator();
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.nodes.size() + '/' + this.allNodes.size() + " nodes)";
    }

    public static class Node {
        private String className;
        private Map referencedNodes;
        private Map referencingNodes;

        Node(String className) {
            this.className = className;
            this.referencedNodes = new IdentityHashMap();
            this.referencingNodes = new IdentityHashMap();
        }

        void initialize(ClassFile classFile, Map allNodes) {
            if (!this.referencedNodes.isEmpty()) {
                throw new IllegalStateException();
            }
            String[] names = classFile.referencedClassNames();
            int i = names.length;
            while (i-- > 0) {
                String name = names[i];
                Node node = (Node)allNodes.get(name);
                if (node == null) {
                    node = new Node(name);
                    allNodes.put(name, node);
                }
                this.referencedNodes.put(node, node);
            }
        }

        void addReferencingNodesFrom(Collection nodes) {
            for (Node node : nodes) {
                node.addReferencingNodeTo(this);
            }
        }

        private void addReferencingNodeTo(Node node) {
            if (this.referencedNodes.containsKey(node)) {
                node.addReferencingNode(this);
            }
        }

        void addReferencingNode(Node node) {
            this.referencingNodes.put(node, node);
        }

        public String getClassName() {
            return this.className;
        }

        public Iterator referencedNodes() {
            return this.referencedNodes.keySet().iterator();
        }

        public Iterator referencingNodes() {
            return this.referencingNodes.keySet().iterator();
        }

        public String toString() {
            return ClassTools.toStringClassNameForObject(this) + "(" + this.className + ")";
        }
    }
}

