/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder;

import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder.DatabaseTypeBuilderTestSuite;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilderException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TransformsTestSuite {
    static DatabaseTypeBuilder dtBuilder = DatabaseTypeBuilderTestSuite.dtBuilder;
    static Properties transformProperties = null;
    static TreeSet<Object> expectedTransformsKeys = null;

    @BeforeClass
    public static void setUp() {
        dtBuilder = new DatabaseTypeBuilder();
        expectedTransformsKeys = new TreeSet();
        expectedTransformsKeys.add("BODY");
        expectedTransformsKeys.add("CONSTRAINTS");
        expectedTransformsKeys.add("CONSTRAINTS_AS_ALTER");
        expectedTransformsKeys.add("PRETTY");
        expectedTransformsKeys.add("REF_CONSTRAINTS");
        expectedTransformsKeys.add("SEGMENT_ATTRIBUTES");
        expectedTransformsKeys.add("SPECIFICATION");
        expectedTransformsKeys.add("SQLTERMINATOR");
        expectedTransformsKeys.add("STORAGE");
        expectedTransformsKeys.add("TABLESPACE");
        boolean worked = true;
        String msg = "";
        try {
            transformProperties = dtBuilder.getTransformProperties();
        }
        catch (DatabaseTypeBuilderException dtbe) {
            worked = false;
            msg = dtbe.getMessage();
        }
        if (!worked) {
            Assert.fail((String)msg);
        }
    }

    @Test
    public void testGetTransforms() {
        Assert.assertNotNull((String)"transforms properties should never be null", (Object)transformProperties);
    }

    @Test
    public void testTransformsNotEmpty() {
        Assert.assertFalse((String)"transforms properties should never be empty", (boolean)transformProperties.isEmpty());
    }

    @Test
    public void testTransformsKeys() {
        TreeSet<Object> transformsKeySet = new TreeSet<Object>(expectedTransformsKeys.comparator());
        transformsKeySet.addAll(transformProperties.keySet());
        Assert.assertTrue((boolean)expectedTransformsKeys.equals(transformsKeySet));
    }
}

