/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.advanced;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.XMLAttributes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.mappings.CascadeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsWriter;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitDefaults;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.AddressType;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Bungalow;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Confidant;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Customer;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Dealer;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Loner;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Name;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.ReadOnlyClass;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Shovel;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.ShovelDigger;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.ShovelOwner;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.ShovelProject;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.ShovelSections;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Violation;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.ViolationCode;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.additionalcriteria.Bolt;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.additionalcriteria.Nut;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.additionalcriteria.School;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.additionalcriteria.Student;
import org.eclipse.persistence.testing.tests.jpa.TestingProperties;

public class EntityMappingsAdvancedJUnitTestCase
extends JUnitTestCase {
    private static Integer employeeId;
    private static Integer extendedEmployeeId;
    private static long visa;
    private static long amex;
    private static long diners;
    private static long mastercard;
    private static long rbc;
    private static long scotia;
    private static long td;
    private static long cibc;
    private String m_persistenceUnit;

    public EntityMappingsAdvancedJUnitTestCase() {
    }

    public EntityMappingsAdvancedJUnitTestCase(String name) {
        super(name);
    }

    public EntityMappingsAdvancedJUnitTestCase(String name, String persistenceUnit) {
        super(name);
        this.m_persistenceUnit = persistenceUnit;
    }

    public static Test suite() {
        String ormTesting = TestingProperties.getProperty("orm.testing", "jpa");
        String persistenceUnit = ormTesting.equals("jpa") ? "default" : "extended-advanced";
        TestSuite suite = new TestSuite("Advanced Model - " + persistenceUnit);
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testSetup", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testCreateEmployee", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testReadEmployee", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testNamedNativeQueryOnAddress", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testNamedQueryOnEmployee", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testUpdateEmployee", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testRefreshNotManagedEmployee", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testRefreshRemovedEmployee", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testDeleteEmployee", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testUnidirectionalPersist", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testUnidirectionalUpdate", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testUnidirectionalFetchJoin", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testUnidirectionalTargetLocking_AddRemoveTarget", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testUnidirectionalTargetLocking_DeleteSource", persistenceUnit));
        suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testXMLEntityMappingsWriteOut", persistenceUnit));
        if (persistenceUnit.equals("extended-advanced")) {
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testSexObjectTypeConverterDefaultValue", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testExistenceCheckingSetting", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testReadOnlyClassSetting", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testEmployeeChangeTrackingPolicy", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testAddressChangeTrackingPolicy", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testPhoneNumberChangeTrackingPolicy", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testProjectChangeTrackingPolicy", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testJoinFetchSetting", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testEmployeeOptimisticLockingSettings", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testEmployeeCacheSettings", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testProjectOptimisticLockingSettings", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testExtendedEmployee", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testGiveExtendedEmployeeASexChange", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testNamedStoredProcedureQuery", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testNamedStoredProcedureQueryInOut", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testMethodBasedTransformationMapping", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testClassBasedTransformationMapping", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testClassInstanceConverter", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testProperty", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testAccessorMethods", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testIfMultipleBasicCollectionMappingsExistForEmployeeResponsibilites", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testAttributeTypeSpecifications", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testMockDynamicClassCRUD", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testEnumeratedPrimaryKeys", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testAdditionalCriteriaModelPopulate", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testAdditionalCriteria", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testAdditionalCriteriaWithParameterFromEM1", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testAdditionalCriteriaWithParameterFromEM2", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testAdditionalCriteriaWithParameterFromEMF", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testComplexAdditionalCriteria", persistenceUnit));
            suite.addTest((Test)new EntityMappingsAdvancedJUnitTestCase("testDeleteAll", persistenceUnit));
        }
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        AdvancedTableCreator atc = new AdvancedTableCreator();
        atc.replaceTables((DatabaseSession)session);
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
    }

    public void testAccessorMethods() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        String testSin = "123456";
        this.beginTransaction(em);
        try {
            Employee employee = ModelExamples.employeeExample1();
            employee.enterSIN(testSin);
            em.persist((Object)employee);
            Integer employeeId = employee.getId();
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.clear();
            Employee emp = (Employee)em.find(Employee.class, (Object)employeeId);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"The SIN value was not persisted.", (boolean)testSin.equals(emp.returnSIN()));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"The enterSIN accessor on Employee was not used to set the value", (emp.returnSinChangeCounter() == 1 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testAdditionalCriteriaModelPopulate() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            School school1 = new School();
            school1.setName("Ottawa Junior High");
            school1.addStudent(new Student("OttawaJRStud1"));
            school1.addStudent(new Student("OttawaJRStud2"));
            school1.addStudent(new Student("OttawaJRStud3"));
            em.persist((Object)school1);
            School school2 = new School();
            school2.setName("Ottawa Senior High");
            school2.addStudent(new Student("OttawaSRStud1"));
            school2.addStudent(new Student("OttawaSRStud2"));
            school2.addStudent(new Student("OttawaSRStud3"));
            school2.addStudent(new Student("OttawaSRStud4"));
            school2.addStudent(new Student("OttawaSRStud5"));
            em.persist((Object)school2);
            School school3 = new School();
            school3.setName("Toronto Junior High");
            school3.addStudent(new Student("TorontoJRStud1"));
            school3.addStudent(new Student("TorontoJRStud2"));
            school3.addStudent(new Student("TorontoJRStud3"));
            school3.addStudent(new Student("TorontoJRStud4"));
            school3.addStudent(new Student("TorontoJRStud5"));
            school3.addStudent(new Student("TorontoJRStud6"));
            school3.addStudent(new Student("TorontoJRStud7"));
            em.persist((Object)school3);
            School school4 = new School();
            school4.setName("Toronto Senior High");
            school4.addStudent(new Student("TorontoSRStud1"));
            school4.addStudent(new Student("TorontoSRStud2"));
            school4.addStudent(new Student("TorontoSRStud3"));
            school4.addStudent(new Student("TorontoSRStud4"));
            school4.addStudent(new Student("TorontoSRStud5"));
            school4.addStudent(new Student("TorontoSRStud6"));
            school4.addStudent(new Student("TorontoSRStud7"));
            school4.addStudent(new Student("TorontoSRStud8"));
            school4.addStudent(new Student("TorontoSRStud9"));
            school4.addStudent(new Student("TorontoSRStud10"));
            school4.addStudent(new Student("TorontoSRStud11"));
            em.persist((Object)school4);
            School school5 = new School();
            school5.setName("Montreal Senior High");
            school5.addStudent(new Student("MontrealSRStud1"));
            school5.addStudent(new Student("MontrealSRStud2"));
            school5.addStudent(new Student("MontrealSRStud3"));
            school5.addStudent(new Student("MontrealSRStud4"));
            school5.addStudent(new Student("MontrealSRStud5"));
            em.persist((Object)school5);
            Bolt bolt1 = new Bolt();
            Nut nut1 = new Nut();
            nut1.setColor("Grey");
            nut1.setSize(Integer.valueOf(8));
            bolt1.setNut(nut1);
            em.persist((Object)bolt1);
            Bolt bolt2 = new Bolt();
            Nut nut2 = new Nut();
            nut2.setColor("Black");
            nut2.setSize(Integer.valueOf(8));
            bolt2.setNut(nut2);
            em.persist((Object)bolt2);
            Bolt bolt3 = new Bolt();
            Nut nut3 = new Nut();
            nut3.setColor("Grey");
            nut3.setSize(Integer.valueOf(6));
            bolt3.setNut(nut3);
            em.persist((Object)bolt3);
            Bolt bolt4 = new Bolt();
            Nut nut4 = new Nut();
            nut4.setColor("Black");
            nut4.setSize(Integer.valueOf(6));
            bolt4.setNut(nut4);
            em.persist((Object)bolt4);
            Bolt bolt5 = new Bolt();
            Nut nut5 = new Nut();
            nut5.setColor("Grey");
            nut5.setSize(Integer.valueOf(2));
            bolt5.setNut(nut5);
            em.persist((Object)bolt5);
            Bolt bolt6 = new Bolt();
            Nut nut6 = new Nut();
            nut6.setColor("Grey");
            nut6.setSize(Integer.valueOf(8));
            bolt6.setNut(nut6);
            em.persist((Object)bolt6);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAdditionalCriteria() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            List schools = em.createNamedQuery("findJPQLXMLSchools").getResultList();
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)("Incorrect number of schools were returned [" + schools.size() + "], expected [2]"), (schools.size() == 2 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAdditionalCriteriaWithParameterFromEM1() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            em.setProperty("NAME", (Object)"Ottawa%");
            List students = em.createQuery("SELECT s from XMLStudent s").getResultList();
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)("Incorrect number of students were returned [" + students.size() + "], expected [8]"), (students.size() == 8 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAdditionalCriteriaWithParameterFromEM2() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            em.setProperty("NAME", (Object)"Toronto%");
            List students = em.createQuery("SELECT s from XMLStudent s").getResultList();
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)("Incorrect number of students were returned [" + students.size() + "], expected [18]"), (students.size() == 18 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAdditionalCriteriaWithParameterFromEMF() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            List students = em.createQuery("SELECT s from XMLStudent s").getResultList();
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)("Incorrect number of students were returned [" + students.size() + "], expected [5]"), (students.size() == 5 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testComplexAdditionalCriteria() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            em.setProperty("NUT_SIZE", (Object)8);
            em.setProperty("NUT_COLOR", (Object)"Grey");
            List bolts = em.createQuery("SELECT b from XMLBolt b").getResultList();
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)("Incorrect number of bolts were returned [" + bolts.size() + "], expected [2]"), (bolts.size() == 2 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testSexObjectTypeConverterDefaultValue() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor employeeDescriptor = session.getDescriptor(Employee.class);
        DirectToFieldMapping mapping = (DirectToFieldMapping)employeeDescriptor.getMappingForAttributeName("gender");
        EntityMappingsAdvancedJUnitTestCase.assertNotNull((String)"Gender mapping from Employee not found.", (Object)mapping);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"No object type converter found on the gender mapping.", (boolean)ObjectTypeConverter.class.isAssignableFrom(mapping.getConverter().getClass()));
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Default object value on the object type converter for gender was not set to Male.", (boolean)((ObjectTypeConverter)mapping.getConverter()).getDefaultAttributeValue().equals(Employee.Gender.Male.name()));
    }

    public void testExistenceCheckingSetting() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor employeeDescriptor = session.getDescriptor(Employee.class);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Employee existence checking was incorrect", (employeeDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 4 ? 1 : 0) != 0);
        ClassDescriptor projectDescriptor = session.getDescriptor(Project.class);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Project existence checking was incorrect", (projectDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 3 ? 1 : 0) != 0);
        ClassDescriptor smallProjectDescriptor = session.getDescriptor(SmallProject.class);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"SmallProject existence checking was incorrect", (smallProjectDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 2 ? 1 : 0) != 0);
        ClassDescriptor largeProjectDescriptor = session.getDescriptor(LargeProject.class);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"LargeProject existence checking was incorrect", (largeProjectDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 1 ? 1 : 0) != 0);
    }

    public void testIfMultipleBasicCollectionMappingsExistForEmployeeResponsibilites() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor employeeDescriptor = session.getDescriptor(Employee.class);
        int foundCount = 0;
        for (DatabaseMapping mapping : employeeDescriptor.getMappings()) {
            if (!mapping.isDirectCollectionMapping() || !mapping.getAttributeName().equals("responsibilities")) continue;
            ++foundCount;
        }
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"We found multiple mappings for Employee responsibilities", (foundCount == 2 ? 1 : 0) != 0);
    }

    public void testReadOnlyClassSetting() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(ReadOnlyClass.class);
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)("ReadOnlyClass descriptor was not found in the PU [" + this.m_persistenceUnit + "]"), (descriptor == null ? 1 : 0) != 0);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"ReadOnlyClass descriptor is not set to read only.", (boolean)descriptor.shouldBeReadOnly());
    }

    public void testEmployeeChangeTrackingPolicy() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)("Employee descriptor was not found in the PU [" + this.m_persistenceUnit + "]"), (descriptor == null ? 1 : 0) != 0);
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Employee descriptor has incorrect object change policy", (boolean)descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
    }

    public void testAddressChangeTrackingPolicy() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(Address.class);
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)("Address descriptor was not found in the PU [" + this.m_persistenceUnit + "]"), (descriptor == null ? 1 : 0) != 0);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Address descriptor has incorrect object change policy", (boolean)descriptor.getObjectChangePolicyInternal().isDeferredChangeDetectionPolicy());
    }

    public void testPhoneNumberChangeTrackingPolicy() {
        if (!JUnitTestCase.isWeavingEnabled((String)this.m_persistenceUnit)) {
            return;
        }
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(PhoneNumber.class);
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)("PhoneNumber descriptor was not found in the PU [" + this.m_persistenceUnit + "]"), (descriptor == null ? 1 : 0) != 0);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"PhoneNumber descriptor has incorrect object change policy", (boolean)descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy());
    }

    public void testProjectChangeTrackingPolicy() {
        if (!JUnitTestCase.isWeavingEnabled((String)this.m_persistenceUnit)) {
            return;
        }
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(Project.class);
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)("Project descriptor was not found in the PU [" + this.m_persistenceUnit + "]"), (descriptor == null ? 1 : 0) != 0);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Project descriptor has incorrect object change policy", (boolean)descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy());
    }

    public void testJoinFetchSetting() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        if (descriptor == null) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)("Employee descriptor was not found in the PU [" + this.m_persistenceUnit + "]"));
        } else if (((ForeignReferenceMapping)descriptor.getMappingForAttributeName("address")).getJoinFetch() != 2) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)"join-fetch setting from XML was not read correctly for Employee's address.");
        }
    }

    public void testEmployeeOptimisticLockingSettings() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        if (descriptor == null) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)("Employee descriptor was not found in the PU [" + this.m_persistenceUnit + "]"));
        } else {
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Incorrect optimistic locking policy set on the Employee descriptor.", (boolean)descriptor.usesVersionLocking());
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Incorrect cascade option set on the optimistic locking poluicy.", (boolean)descriptor.getOptimisticLockingPolicy().isCascaded());
        }
    }

    public void testEmployeeCacheSettings() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        if (descriptor == null) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)("A descriptor for the Employee alias was not found in the PU [" + this.m_persistenceUnit + "]"));
        } else {
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Incorrect cache type() setting.", (boolean)descriptor.getIdentityMapClass().equals(ClassConstants.SoftCacheWeakIdentityMap_Class));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Incorrect cache size() setting.", (descriptor.getIdentityMapSize() == 730 ? 1 : 0) != 0);
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Incorrect cache isolated() setting.", (boolean)descriptor.isIsolated());
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Incorrect cache alwaysRefresh() setting.", (boolean)descriptor.shouldAlwaysRefreshCache());
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Incorrect disable hits setting.", (boolean)descriptor.shouldDisableCacheHits());
            CacheInvalidationPolicy policy = descriptor.getCacheInvalidationPolicy();
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Incorrect cache expiry() policy setting.", (boolean)(policy instanceof TimeToLiveCacheInvalidationPolicy));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Incorrect cache expiry() setting.", (((TimeToLiveCacheInvalidationPolicy)policy).getTimeToLive() == 1000L ? 1 : 0) != 0);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Incorrect cache coordinationType() settting.", (descriptor.getCacheSynchronizationType() == 2 ? 1 : 0) != 0);
        }
    }

    public void testProjectOptimisticLockingSettings() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = session.getDescriptor(Project.class);
        if (descriptor == null) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)("Project descriptor was not found in the PU [" + this.m_persistenceUnit + "]"));
        } else {
            OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
            if (policy instanceof SelectedFieldsLockingPolicy) {
                List lockFields = ((SelectedFieldsLockingPolicy)policy).getLockFields();
                if (lockFields.isEmpty() || lockFields.size() > 1) {
                    EntityMappingsAdvancedJUnitTestCase.fail((String)"Invalid amount of lock fields were set on Project's selected fields locking policy.");
                } else {
                    DatabaseField lockField = (DatabaseField)lockFields.get(0);
                    EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Incorrect lock field was set on Project's selected fields locking policy.", (boolean)lockField.getName().equals("VERSION"));
                }
            } else {
                EntityMappingsAdvancedJUnitTestCase.fail((String)"A SelectedFieldsLockingPolicy was not set on the Project descriptor.");
            }
        }
    }

    public void testCreateEmployee() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Employee employee = ModelExamples.employeeExample1();
            ArrayList<Project> projects = new ArrayList<Project>();
            projects.add(ModelExamples.projectExample1());
            projects.add(ModelExamples.projectExample2());
            employee.setProjects(projects);
            em.persist((Object)employee);
            employeeId = employee.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testExtendedEmployee() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Address address = new Address();
            address.setCity("Nepean");
            address.setCountry("Canada");
            address.setPostalCode("K2J 6T3");
            address.setProvince("oNtArIo");
            address.setStreet("321 Crestway");
            Employee employee = new Employee();
            employee.setGivenName("Boy");
            employee.setFamilyName("Pelletier");
            employee.setMale();
            employee.addVisa(visa);
            employee.addAmex(amex);
            employee.addDinersClub(diners);
            employee.addMastercard(mastercard);
            employee.addRoyalBankCreditLine(rbc);
            employee.addScotiabankCreditLine(scotia);
            employee.addTorontoDominionCreditLine(td);
            employee.addCanadianImperialCreditLine(cibc);
            employee.setAddress(address);
            employee.setSalary(20000);
            employee.setPeriod(new EmploymentPeriod());
            employee.getPeriod().setStartDate((Date)new java.sql.Date(System.currentTimeMillis() - 1000000L));
            employee.getPeriod().setEndDate((Date)new java.sql.Date(System.currentTimeMillis() + 1000000L));
            employee.addResponsibility("A very important responsibility");
            em.persist((Object)employee);
            extendedEmployeeId = employee.getId();
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.clear();
            Employee emp = (Employee)em.find(Employee.class, (Object)extendedEmployeeId);
            EntityMappingsAdvancedJUnitTestCase.assertNotNull((String)"The employee was not found", (Object)emp);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"The address province value was not converted", (boolean)emp.getAddress().getProvince().equals("Ontario"));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Gender was not persisted correctly.", (boolean)emp.isMale());
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Visa card did not persist correctly.", (boolean)emp.hasVisa(visa));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Amex card did not persist correctly.", (boolean)emp.hasAmex(amex));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Diners Club card did not persist correctly.", (boolean)emp.hasDinersClub(diners));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Mastercard card did not persist correctly.", (boolean)emp.hasMastercard(mastercard));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"RBC credit line did not persist correctly.", (boolean)emp.hasRoyalBankCreditLine(rbc));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Scotia credit line did not persist correctly.", (boolean)emp.hasScotiabankCreditLine(scotia));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"TD credit line did not persist correctly.", (boolean)emp.hasTorontoDominionCreditLine(td));
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"CIBC credit line did not persist correctly.", (boolean)emp.hasCanadianImperialCreditLine(cibc));
            boolean found = false;
            for (String responsibility : emp.getResponsibilities()) {
                if (!responsibility.equals("A very important responsibility")) continue;
                found = true;
                break;
            }
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"The new responsibility was not added.", (boolean)found);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testGiveExtendedEmployeeASexChange() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Employee maleEmp = (Employee)em.find(Employee.class, (Object)extendedEmployeeId);
            maleEmp.setFemale();
            maleEmp.setGivenName("Girl");
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.clear();
            Employee girlEmp = (Employee)em.find(Employee.class, (Object)extendedEmployeeId);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"The extended employee's change didn't occur.", (boolean)girlEmp.isFemale());
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testDeleteEmployee() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            em.remove(em.find(Employee.class, (Object)employeeId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Error deleting Employee", (em.find(Employee.class, (Object)employeeId) == null ? 1 : 0) != 0);
    }

    public void testNamedNativeQueryOnAddress() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Address address1 = ModelExamples.addressExample1();
            em.persist((Object)address1);
            Address address2 = ModelExamples.addressExample2();
            em.persist((Object)address2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        Query query = em.createNamedQuery("findAllXMLAddresses");
        List addresses = query.getResultList();
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Error executing named native query 'findAllXMLAddresses'", (addresses != null ? 1 : 0) != 0);
    }

    public void testNamedQueryOnEmployee() {
        Query query = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit).createNamedQuery("findAllXMLEmployeesByFirstName");
        query.setParameter("firstname", (Object)"Brady");
        Employee employee = (Employee)query.getSingleResult();
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Error executing named query 'findAllXMLEmployeesByFirstName'", (employee != null ? 1 : 0) != 0);
    }

    public void testReadEmployee() {
        Employee employee = (Employee)EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit).find(Employee.class, (Object)employeeId);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Error reading Employee", (employee.getId().intValue() == employeeId.intValue() ? 1 : 0) != 0);
    }

    public void testUpdateEmployee() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        int version = 0;
        try {
            Employee employee = (Employee)em.find(Employee.class, (Object)employeeId);
            version = employee.getVersion();
            employee.setSalary(50000);
            em.merge((Object)employee);
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.clear();
            Employee emp = (Employee)em.find(Employee.class, (Object)employeeId);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Error updating Employee", (emp.getSalary() == 50000 ? 1 : 0) != 0);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Version field not updated", (emp.getVersion() == version + 1 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testRefreshNotManagedEmployee() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setGivenName("NotManaged");
            em.refresh((Object)emp);
            EntityMappingsAdvancedJUnitTestCase.fail((String)"entityManager.refresh(notManagedObject) didn't throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshRemovedEmployee() {
        Employee emp;
        String firstName = "testRefreshRemovedEmployee";
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List result = em.createQuery("SELECT OBJECT(e) FROM XMLEmployee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            emp = (Employee)result.get(0);
        } else {
            emp = new Employee();
            emp.setGivenName(firstName);
            this.beginTransaction(em);
            try {
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw e;
            }
        }
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            if (EntityMappingsAdvancedJUnitTestCase.getServerSession((String)this.m_persistenceUnit).getPlatform().isSymfoware()) {
                em.createNativeQuery("DELETE FROM CMP3_XML_EMPLOYEE WHERE F_NAME = '" + firstName + "'").executeUpdate();
            } else {
                em.createQuery("DELETE FROM XMLEmployee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            }
            em.refresh((Object)emp);
            EntityMappingsAdvancedJUnitTestCase.fail((String)"entityManager.refresh(removedObject) didn't throw exception");
        }
        catch (EntityNotFoundException entityNotFoundException) {
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testContainsRemovedEmployee() {
        Employee emp;
        String firstName = "testContainsRemovedEmployee";
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List result = em.createQuery("SELECT OBJECT(e) FROM XMLEmployee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            emp = (Employee)result.get(0);
        } else {
            emp = new Employee();
            emp.setGivenName(firstName);
            this.beginTransaction(em);
            try {
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw e;
            }
        }
        boolean containsRemoved = true;
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            containsRemoved = em.contains((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"entityManager.contains(removedObject)==true ", (boolean)containsRemoved);
    }

    public void testSubString() {
        String firstName = "testSubString";
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List result = em.createQuery("SELECT OBJECT(e) FROM XMLEmployee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            Employee emp = (Employee)result.get(0);
        } else {
            Employee emp = new Employee();
            emp.setGivenName(firstName);
            this.beginTransaction(em);
            try {
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw e;
            }
        }
        int firstIndex = 1;
        int lastIndex = firstName.length();
        List employees = em.createQuery("SELECT object(e) FROM XMLEmployee e where e.firstName = substring(:p1, :p2, :p3)").setParameter("p1", (Object)firstName).setParameter("p2", (Object)new Integer(firstIndex)).setParameter("p3", (Object)new Integer(lastIndex)).getResultList();
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM XMLEmployee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"employees.isEmpty()==true ", (boolean)employees.isEmpty());
    }

    public void testNamedStoredProcedureQuery() {
        if (!EntityMappingsAdvancedJUnitTestCase.supportsStoredProcedures((String)this.m_persistenceUnit)) {
            return;
        }
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            em.clear();
            Query aQuery = em.createNamedQuery("SProcXMLAddress").setParameter("ADDRESS_ID", (Object)address1.getId());
            Address address2 = (Address)aQuery.getSingleResult();
            EntityMappingsAdvancedJUnitTestCase.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Address not found using stored procedure", (address1.getId().intValue() == address2.getId().intValue() ? 1 : 0) != 0);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Address.street data returned doesn't match persisted address.street", (boolean)address1.getStreet().equals(address2.getStreet()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQueryInOut() {
        if (!EntityMappingsAdvancedJUnitTestCase.supportsStoredProcedures((String)this.m_persistenceUnit)) {
            return;
        }
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            em.clear();
            Query aQuery = em.createNamedQuery("SProcXMLInOut").setParameter("ADDRESS_ID", (Object)address1.getId());
            Address address2 = (Address)aQuery.getSingleResult();
            EntityMappingsAdvancedJUnitTestCase.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Address not found using stored procedure", (address1.getId().intValue() == address2.getId().intValue() ? 1 : 0) != 0);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Address.street data returned doesn't match persisted address.street", (boolean)address1.getStreet().equals(address2.getStreet()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testMethodBasedTransformationMapping() {
        this.internalTestTransformationMapping("normalHours");
    }

    public void testClassBasedTransformationMapping() {
        this.internalTestTransformationMapping("overtimeHours");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestTransformationMapping(String attributeName) {
        int startHour = 8;
        int startMin = 30;
        int startSec = 15;
        int endHour = 17;
        int endMin = 15;
        int endSec = 45;
        String firstName = attributeName;
        Employee employee = new Employee();
        employee.setGivenName(firstName);
        if (attributeName.equals("normalHours")) {
            employee.setStartTime(Helper.timeFromHourMinuteSecond((int)startHour, (int)startMin, (int)startSec));
            employee.setEndTime(Helper.timeFromHourMinuteSecond((int)endHour, (int)endMin, (int)endSec));
        } else if (attributeName.equals("overtimeHours")) {
            employee.setStartOvertime(Helper.timeFromHourMinuteSecond((int)startHour, (int)startMin, (int)startSec));
            employee.setEndOvertime(Helper.timeFromHourMinuteSecond((int)endHour, (int)endMin, (int)endSec));
        } else {
            throw new RuntimeException("Unknown attributeName");
        }
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        int id = employee.getId();
        EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        employee = (Employee)em.find(Employee.class, (Object)id);
        Calendar calendarStart = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        if (attributeName.equals("normalHours")) {
            calendarStart.setTime(employee.getStartTime());
            calendarEnd.setTime(employee.getEndTime());
        } else if (attributeName.equals("overtimeHours")) {
            calendarStart.setTime(employee.getStartOvertime());
            calendarEnd.setTime(employee.getEndOvertime());
        }
        String errorMsg = "";
        if (calendarStart.get(11) != startHour || calendarStart.get(12) != startMin || calendarStart.get(13) != startSec) {
            if (attributeName.equals("normalHours")) {
                errorMsg = "startTime = " + employee.getStartTime().toString() + " is wrong";
            } else if (attributeName.equals("overtimeHours")) {
                errorMsg = "startOvertime = " + employee.getStartOvertime().toString() + " is wrong";
            }
        }
        if (calendarEnd.get(11) != endHour || calendarEnd.get(12) != endMin || calendarEnd.get(13) != endSec) {
            if (errorMsg.length() > 0) {
                errorMsg = errorMsg + "; ";
            }
            if (attributeName.equals("normalHours")) {
                errorMsg = "endTime = " + employee.getEndTime().toString() + " is wrong";
            } else if (attributeName.equals("overtimeHours")) {
                errorMsg = "endOvertime = " + employee.getEndOvertime().toString() + " is wrong";
            }
        }
        this.beginTransaction(em);
        try {
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        if (errorMsg.length() > 0) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)errorMsg);
        }
    }

    public void testClassInstanceConverter() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        Address add = new Address();
        add.setCity("St. Louis");
        add.setType((AddressType)new Bungalow());
        em.persist((Object)add);
        this.commitTransaction(em);
        int assignedSequenceNumber = add.getId();
        em.clear();
        EntityMappingsAdvancedJUnitTestCase.getServerSession((String)this.m_persistenceUnit).getIdentityMapAccessor().initializeAllIdentityMaps();
        add = (Address)em.find(Address.class, (Object)assignedSequenceNumber);
        EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Did not correctly persist a mapping using a class-instance converter", (boolean)(add.getType() instanceof Bungalow));
        this.beginTransaction(em);
        em.remove((Object)add);
        this.commitTransaction(em);
    }

    public void testProperty() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        ClassDescriptor descriptor = ((EntityManagerImpl)em).getServerSession().getDescriptorForAlias("XMLEmployee");
        ClassDescriptor aggregateDescriptor = ((EntityManagerImpl)em).getServerSession().getDescriptor(EmploymentPeriod.class);
        em.close();
        String errorMsg = "";
        if (descriptor == null) {
            errorMsg = errorMsg + " Descriptor for XMLEmployee alias was not found;";
        }
        if (aggregateDescriptor == null) {
            errorMsg = errorMsg + " Descriptor for EmploymentPeriod.class was not found;";
        }
        if (errorMsg.length() > 0) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)errorMsg);
        }
        errorMsg = errorMsg + this.verifyPropertyValue(descriptor, "entityName", String.class, (Object)"XMLEmployee");
        errorMsg = errorMsg + this.verifyPropertyValue(descriptor, "entityIntegerProperty", Integer.class, (Object)new Integer(1));
        errorMsg = errorMsg + this.verifyPropertyValue(descriptor, "ToBeOverriddenByXml", Boolean.class, (Object)Boolean.TRUE);
        errorMsg = errorMsg + this.verifyPropertyValue(descriptor, "ToBeProcessed", Boolean.class, (Object)Boolean.TRUE);
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            errorMsg = errorMsg + this.verifyPropertyValue(mapping, "attributeName", String.class, (Object)mapping.getAttributeName());
        }
        DatabaseMapping mapping = descriptor.getMappingForAttributeName("lastName");
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "BooleanProperty", Boolean.class, (Object)Boolean.TRUE);
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "ByteProperty", Byte.class, (Object)new Byte(1));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "CharacterProperty", Character.class, (Object)new Character('A'));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "DoubleProperty", Double.class, (Object)new Double(1.0));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "FloatProperty", Float.class, (Object)new Float(1.0f));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "IntegerProperty", Integer.class, (Object)new Integer(1));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "LongProperty", Long.class, (Object)new Long(1L));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "ShortProperty", Short.class, (Object)new Short(1));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "BigDecimalProperty", BigDecimal.class, (Object)BigDecimal.ONE);
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "BigIntegerProperty", BigInteger.class, (Object)BigInteger.ONE);
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "TimeProperty", Time.class, (Object)Helper.timeFromString((String)"13:59:59"));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "TimeStampProperty", Timestamp.class, (Object)Helper.timestampFromString((String)"2008-04-10 13:59:59"));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "DateProperty", java.sql.Date.class, (Object)Helper.dateFromString((String)"2008-04-10"));
        errorMsg = errorMsg + this.verifyPropertyValue(mapping, "ToBeIgnored", null, null);
        errorMsg = errorMsg + this.verifyPropertyValue(aggregateDescriptor, "embeddableClassName", String.class, (Object)"EmploymentPeriod");
        errorMsg = errorMsg + this.verifyPropertyValue(aggregateDescriptor, "ToBeOverriddenByXml", Boolean.class, (Object)Boolean.TRUE);
        if ((errorMsg = errorMsg + this.verifyPropertyValue(aggregateDescriptor, "ToBeProcessed", Boolean.class, (Object)Boolean.TRUE)).length() > 0) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)errorMsg);
        }
    }

    protected String verifyPropertyValue(ClassDescriptor descriptor, String propertyName, Class expectedPropertyValueType, Object expectedPropertyValue) {
        return this.verifyPropertyValue(propertyName, descriptor.getProperty(propertyName), expectedPropertyValueType, expectedPropertyValue, Helper.getShortClassName((Class)descriptor.getJavaClass()) + " descriptor");
    }

    protected String verifyPropertyValue(DatabaseMapping mapping, String propertyName, Class expectedPropertyValueType, Object expectedPropertyValue) {
        return this.verifyPropertyValue(propertyName, mapping.getProperty((Object)propertyName), expectedPropertyValueType, expectedPropertyValue, mapping.getAttributeName() + " attribute");
    }

    protected String verifyPropertyValue(String propertyName, Object propertyValue, Class expectedPropertyValueType, Object expectedPropertyValue, String masterName) {
        String errorMsg = "";
        String errorPrefix = " property " + propertyName + " for " + masterName;
        if (expectedPropertyValueType == null) {
            if (propertyValue != null) {
                errorMsg = errorPrefix + " value is " + propertyValue.toString() + " , was expected to be null.";
            }
            return errorMsg;
        }
        if (propertyValue == null) {
            errorMsg = errorPrefix + " is missing;";
        } else if (!expectedPropertyValueType.isInstance(propertyValue)) {
            errorMsg = errorPrefix + " is instance of " + propertyValue.getClass().getName() + ", " + expectedPropertyValueType.getName() + " was expected;";
        } else if (propertyValue.getClass().isArray()) {
            if (Array.getLength(propertyValue) != Array.getLength(expectedPropertyValue)) {
                errorMsg = errorPrefix + " has array value of size " + Array.getLength(propertyValue) + ", " + Array.getLength(expectedPropertyValue) + " was expected;";
            } else {
                for (int i = 0; i < Array.getLength(propertyValue); ++i) {
                    if (Array.get(propertyValue, i).equals(Array.get(expectedPropertyValue, i))) continue;
                    errorMsg = errorPrefix + " has array with " + i + "th element value " + Array.get(propertyValue, i).toString() + ", " + Array.get(expectedPropertyValue, i).toString() + " was expected;";
                }
            }
        } else if (!propertyValue.equals(expectedPropertyValue)) {
            errorMsg = errorPrefix + " has value " + propertyValue.toString() + ", " + expectedPropertyValue.toString() + " was expected;";
        }
        return errorMsg;
    }

    public void testUnidirectionalPersist() {
        String lastName = "testUnidirectionalPersist";
        List<Employee> employeesPersisted = this.persistEmployeesWithUnidirectionalMappings(lastName);
        EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List employeesRead = em.createQuery("SELECT OBJECT(e) FROM XMLEmployee e WHERE e.lastName = '" + lastName + "'").getResultList();
        ServerSession session = EntityMappingsAdvancedJUnitTestCase.isOnServer() ? EntityMappingsAdvancedJUnitTestCase.getServerSession() : ((EntityManagerImpl)em).getServerSession();
        this.closeEntityManager(em);
        if (employeesPersisted.size() != employeesRead.size()) {
            this.deleteEmployeesWithUnidirectionalMappings(lastName);
            EntityMappingsAdvancedJUnitTestCase.fail((String)("Persisted " + employeesPersisted.size() + " employees, but read back " + employeesRead.size()));
        }
        String errorMsg = "";
        for (int i = 0; i < employeesPersisted.size(); ++i) {
            for (int j = 0; j < employeesRead.size(); ++j) {
                if (!employeesPersisted.get(i).getFirstName().equals(((Employee)employeesRead.get(j)).getFirstName()) || session.compareObjects((Object)employeesPersisted.get(i), employeesRead.get(j))) continue;
                errorMsg = errorMsg + "Employee " + employeesPersisted.get(i).getFirstName() + "  was not persisted correctly.";
            }
        }
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnidirectionalUpdate() {
        String lastName = "testUnidirectionalUpdate";
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List<Employee> employeesPersisted = this.persistEmployeesWithUnidirectionalMappings(lastName, em);
        this.beginTransaction(em);
        try {
            employeesPersisted.get(0).addDealer(new Dealer("New", lastName));
            employeesPersisted.get(1).getDealers().remove(1);
            employeesPersisted.get(1).addDealer((Dealer)employeesPersisted.get(0).getDealers().remove(0));
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List employeesRead = em.createQuery("SELECT OBJECT(e) FROM XMLEmployee e WHERE e.lastName = '" + lastName + "'").getResultList();
        ServerSession session = EntityMappingsAdvancedJUnitTestCase.isOnServer() ? EntityMappingsAdvancedJUnitTestCase.getServerSession() : ((EntityManagerImpl)em).getServerSession();
        if (employeesPersisted.size() != employeesRead.size()) {
            this.deleteEmployeesWithUnidirectionalMappings(lastName);
            EntityMappingsAdvancedJUnitTestCase.fail((String)("Updated " + employeesPersisted.size() + " employees, but read back " + employeesRead.size()));
        }
        this.beginTransaction(em);
        String errorMsg = "";
        try {
            for (int i = 0; i < employeesPersisted.size(); ++i) {
                for (int j = 0; j < employeesRead.size(); ++j) {
                    Employee emp1 = (Employee)em.find(Employee.class, (Object)employeesPersisted.get(i).getId());
                    Employee emp2 = (Employee)em.find(Employee.class, (Object)((Employee)employeesRead.get(j)).getId());
                    if (!emp1.getFirstName().equals(emp2.getFirstName()) || session.compareObjects((Object)emp1, (Object)emp2)) continue;
                    errorMsg = errorMsg + "Employee " + emp1.getFirstName() + "  was not updated correctly.";
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)errorMsg);
        }
    }

    public void testUnidirectionalFetchJoin() {
        String lastName = "testUnidirectionalFetchJoin";
        this.persistEmployeesWithUnidirectionalMappings(lastName);
        EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List employeesRead = em.createQuery("SELECT OBJECT(e) FROM XMLEmployee e WHERE e.lastName = '" + lastName + "'").getResultList();
        this.closeEntityManager(em);
        EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List employeesReadWithFetchJoin = em.createQuery("SELECT e FROM XMLEmployee e JOIN FETCH e.dealers WHERE e.lastName = '" + lastName + "'").getResultList();
        ServerSession session = EntityMappingsAdvancedJUnitTestCase.isOnServer() ? EntityMappingsAdvancedJUnitTestCase.getServerSession() : ((EntityManagerImpl)em).getServerSession();
        this.closeEntityManager(em);
        ArrayList employeesControl = new ArrayList();
        for (int i = 0; i < employeesRead.size(); ++i) {
            int nDialers = ((Employee)employeesRead.get(i)).getDealers().size();
            for (int j = 0; j < nDialers; ++j) {
                employeesControl.add(employeesRead.get(i));
            }
        }
        String errorMsg = JoinedAttributeTestHelper.compareCollections(employeesControl, (Collection)employeesReadWithFetchJoin, (ClassDescriptor)session.getClassDescriptor(Employee.class), (AbstractSession)session);
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnidirectionalTargetLocking_AddRemoveTarget() {
        Dealer dealer3;
        Dealer dealer;
        String lastName = "testUnidirectionalTargetLocking_ART";
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List<Employee> employeesPersisted = this.persistEmployeesWithUnidirectionalMappings(lastName, em);
        this.beginTransaction(em);
        try {
            Employee emp1 = (Employee)em.find(Employee.class, (Object)employeesPersisted.get(1).getId());
            dealer = (Dealer)emp1.getDealers().remove(1);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
        String errorMsg = "";
        int version2 = this.getVersion(em, dealer);
        if (version2 != 2) {
            errorMsg = errorMsg + "In the cache the removed dealer's version is " + version2 + " (2 was expected); ";
        }
        this.beginTransaction(em);
        try {
            Dealer dealer2 = (Dealer)em.find(Dealer.class, (Object)dealer.getId());
            em.refresh((Object)dealer2);
            version2 = this.getVersion(em, dealer2);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        if (version2 != 2) {
            errorMsg = errorMsg + "In the db the removed dealer's version is " + version2 + " (2 was expected); ";
        }
        this.beginTransaction(em);
        try {
            Employee emp2 = (Employee)em.find(Employee.class, (Object)employeesPersisted.get(1).getId());
            dealer3 = (Dealer)em.find(Dealer.class, (Object)dealer.getId());
            emp2.getDealers().add(dealer3);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
        int version3 = this.getVersion(em, dealer3);
        if (version3 != 3) {
            errorMsg = errorMsg + "In the cache the added dealer's version is " + version3 + " (3 was expected); ";
        }
        this.beginTransaction(em);
        try {
            Dealer dealer4 = (Dealer)em.find(Dealer.class, (Object)dealer3.getId());
            em.refresh((Object)dealer4);
            version3 = this.getVersion(em, dealer4);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        if (version3 != 3) {
            errorMsg = errorMsg + "In the db the added dealer's version is " + version3 + " (3 was expected)";
        }
        this.closeEntityManager(em);
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnidirectionalTargetLocking_DeleteSource() {
        String lastName = "testUnidirectionalTargetLocking_DS";
        List<Employee> persistedEmployees = this.persistEmployeesWithUnidirectionalMappings(lastName);
        ArrayList<Integer> dealersIds = new ArrayList<Integer>();
        for (int i = 0; i < persistedEmployees.size(); ++i) {
            Employee emp = persistedEmployees.get(i);
            for (int j = 0; j < emp.getDealers().size(); ++j) {
                dealersIds.add(((Dealer)emp.getDealers().get(j)).getId());
            }
        }
        EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        List readEmployees = em.createQuery("SELECT OBJECT(e) FROM XMLEmployee e WHERE e.lastName = '" + lastName + "'").getResultList();
        ((Employee)readEmployees.get(1)).getDealers().size();
        try {
            for (Employee emp : readEmployees) {
                em.remove((Object)emp);
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
        this.beginTransaction(em);
        String errorMsg = "";
        try {
            for (int i = 0; i < dealersIds.size(); ++i) {
                Dealer dealer = (Dealer)em.find(Dealer.class, dealersIds.get(i));
                int version2 = this.getVersion(em, dealer);
                if (version2 != 2) {
                    errorMsg = errorMsg + "In the cache dealer " + dealer.getFirstName() + "'s version is " + version2 + " (2 was expected); ";
                }
                em.refresh((Object)dealer);
                version2 = this.getVersion(em, dealer);
                if (version2 == 2) continue;
                errorMsg = errorMsg + "In the db dealer " + dealer.getFirstName() + "'s version is " + version2 + " (2 was expected); ";
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        this.closeEntityManager(em);
        this.deleteEmployeesWithUnidirectionalMappings(lastName);
        if (errorMsg.length() > 0) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)errorMsg);
        }
    }

    protected int getVersion(EntityManager em, Dealer dealer) {
        Vector<Integer> pk = new Vector<Integer>(1);
        pk.add(dealer.getId());
        if (EntityMappingsAdvancedJUnitTestCase.isOnServer()) {
            return (Integer)EntityMappingsAdvancedJUnitTestCase.getServerSession().getDescriptor(Dealer.class).getOptimisticLockingPolicy().getWriteLockValue((Object)dealer, pk, (AbstractSession)EntityMappingsAdvancedJUnitTestCase.getServerSession());
        }
        return (Integer)((EntityManagerImpl)em).getServerSession().getDescriptor(Dealer.class).getOptimisticLockingPolicy().getWriteLockValue((Object)dealer, pk, (AbstractSession)((EntityManagerImpl)em).getServerSession());
    }

    protected List<Employee> createEmployeesWithUnidirectionalMappings(String lastName) {
        int n = 2;
        ArrayList<Employee> employees = new ArrayList<Employee>(n);
        for (int i = 0; i < n; ++i) {
            Employee emp = new Employee();
            emp.setGivenName(Integer.toString(i + 1));
            emp.setFamilyName(lastName);
            employees.add(emp);
            for (int j = 0; j < n; ++j) {
                Dealer dealer = new Dealer();
                dealer.setFirstName(emp.getFirstName() + "_" + Integer.toString(j + 1));
                dealer.setLastName(lastName);
                emp.addDealer(dealer);
                for (int k = 0; k < n; ++k) {
                    Customer customer = new Customer();
                    customer.setFirstName(dealer.getFirstName() + "_" + Integer.toString(k + 1));
                    customer.setLastName(lastName);
                    dealer.addCustomer(customer);
                }
            }
        }
        return employees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Employee> persistEmployeesWithUnidirectionalMappings(String lastName) {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            List<Employee> list = this.persistEmployeesWithUnidirectionalMappings(lastName, em);
            return list;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Employee> persistEmployeesWithUnidirectionalMappings(String lastName, EntityManager em) {
        List<Employee> employees = this.createEmployeesWithUnidirectionalMappings(lastName);
        this.beginTransaction(em);
        try {
            for (int i = 0; i < employees.size(); ++i) {
                em.persist((Object)employees.get(i));
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        return employees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEmployeesWithUnidirectionalMappings(String lastName) {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM XMLAdvancedCustomer c WHERE c.lastName = '" + lastName + "'").executeUpdate();
            em.createQuery("DELETE FROM XMLDealer d WHERE d.lastName = '" + lastName + "'").executeUpdate();
            Query q = em.createQuery("SELECT e FROM XMLEmployee e WHERE e.lastName = '" + lastName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        }
    }

    public void testAttributeTypeSpecifications() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            this.beginTransaction(em);
            Loner loner = new Loner();
            Name name = new Name();
            name.firstName = "Joe";
            name.lastName = "Schmo";
            loner.setName((Object)name);
            Confidant confidant = new Confidant();
            loner.addConfidant(confidant);
            loner.addCharacteristic((Object)"Keeps to himself");
            loner.addCharacteristic((Object)"Shy's away from conversation");
            em.persist((Object)loner);
            Object lonerId = loner.getId();
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.clear();
            Loner refreshedLoner = (Loner)em.find(Loner.class, lonerId);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Loner objects didn't match", (boolean)EntityMappingsAdvancedJUnitTestCase.getServerSession((String)this.m_persistenceUnit).compareObjects((Object)loner, (Object)refreshedLoner));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testMockDynamicClassCRUD() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            this.beginTransaction(em);
            Shovel shovel = new Shovel();
            shovel.setMy("cost", (Object)9.99);
            ShovelSections shovelSections = new ShovelSections();
            shovelSections.setMaterial("handle", (Object)ShovelSections.MaterialType.Plastic);
            shovelSections.setMaterial("shaft", (Object)ShovelSections.MaterialType.Wood);
            shovelSections.setMaterial("scoop", (Object)ShovelSections.MaterialType.Plastic);
            shovel.setMy("sections", (Object)shovelSections);
            ShovelOwner shovelOwner = new ShovelOwner();
            shovelOwner.set("name", (Object)"Mr. Shovel");
            shovel.setMy("owner", (Object)shovelOwner);
            ShovelDigger shovelDigger1 = new ShovelDigger();
            shovelDigger1.set("name", (Object)"Digging Plebe 1");
            shovelDigger1.setX("shovel", (Object)shovel);
            ShovelDigger shovelDigger2 = new ShovelDigger();
            shovelDigger2.set("name", (Object)"Digging Plebe 2");
            shovelDigger2.setX("shovel", (Object)shovel);
            ArrayList<ShovelDigger> operators = new ArrayList<ShovelDigger>();
            operators.add(shovelDigger1);
            operators.add(shovelDigger2);
            shovel.setMy("operators", operators);
            ShovelProject shovelProject = new ShovelProject();
            shovelProject.set("description", (Object)"One lousy shovelling project");
            ArrayList<Shovel> shovels = new ArrayList<Shovel>();
            shovels.add(shovel);
            shovelProject.set("shovels", shovels);
            ArrayList<ShovelProject> projects = new ArrayList<ShovelProject>();
            projects.add(shovelProject);
            shovel.setMy("projects", projects);
            em.persist((Object)shovel);
            Object shovelId = shovel.getMy("id");
            Object shovelOwnerId = shovelOwner.get("id");
            Object shovelDigger1Id = shovelDigger1.get("id");
            Object shovelDigger2Id = shovelDigger2.get("id");
            Object shovelProjectId = shovelProject.get("id");
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.clear();
            Shovel refreshedShovel = (Shovel)em.find(Shovel.class, shovelId);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Shovel didn't match after write/read", (boolean)EntityMappingsAdvancedJUnitTestCase.getServerSession((String)this.m_persistenceUnit).compareObjects((Object)shovel, (Object)refreshedShovel));
            this.beginTransaction(em);
            em.merge((Object)refreshedShovel);
            refreshedShovel.setMy("cost", (Object)7.99);
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.clear();
            Shovel refreshedUpdatedShovel = (Shovel)em.find(Shovel.class, shovelId);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Shovel didn't match after update", (boolean)EntityMappingsAdvancedJUnitTestCase.getServerSession((String)this.m_persistenceUnit).compareObjects((Object)refreshedShovel, (Object)refreshedUpdatedShovel));
            this.beginTransaction(em);
            em.merge((Object)refreshedUpdatedShovel);
            em.remove((Object)refreshedUpdatedShovel);
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.assertNull((String)"Shovel wasn't removed", (Object)em.find(Shovel.class, shovelId));
            EntityMappingsAdvancedJUnitTestCase.assertNull((String)"Shovel owner wasn't removed", (Object)em.find(ShovelOwner.class, shovelOwnerId));
            EntityMappingsAdvancedJUnitTestCase.assertNull((String)"Shovel digger 1 wasn't removed", (Object)em.find(ShovelDigger.class, shovelDigger1Id));
            EntityMappingsAdvancedJUnitTestCase.assertNull((String)"Shovel digger 2 wasn't removed", (Object)em.find(ShovelDigger.class, shovelDigger2Id));
            EntityMappingsAdvancedJUnitTestCase.assertNotNull((String)"Shovel project was removed", (Object)em.find(ShovelProject.class, shovelProjectId));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnumeratedPrimaryKeys() {
        EntityManager em = EntityMappingsAdvancedJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        try {
            this.beginTransaction(em);
            ViolationCode codeA = new ViolationCode();
            codeA.setId(ViolationCode.ViolationCodeId.A);
            codeA.setDescription("Violation A");
            em.persist((Object)codeA);
            ViolationCode codeB = new ViolationCode();
            codeB.setId(ViolationCode.ViolationCodeId.B);
            codeB.setDescription("Violation B");
            em.persist((Object)codeB);
            ViolationCode codeC = new ViolationCode();
            codeC.setId(ViolationCode.ViolationCodeId.C);
            codeC.setDescription("Violation C");
            em.persist((Object)codeC);
            ViolationCode codeD = new ViolationCode();
            codeD.setId(ViolationCode.ViolationCodeId.D);
            codeD.setDescription("Violation D");
            em.persist((Object)codeD);
            Violation violation = new Violation();
            violation.setId(Violation.ViolationID.V1);
            violation.getViolationCodes().add(codeA);
            violation.getViolationCodes().add(codeC);
            violation.getViolationCodes().add(codeD);
            em.persist((Object)violation);
            this.commitTransaction(em);
            EntityMappingsAdvancedJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.clear();
            Violation refreshedViolation = (Violation)em.find(Violation.class, (Object)violation.getId());
            EntityMappingsAdvancedJUnitTestCase.assertNotNull((String)"Unable to read back the violation", (Object)refreshedViolation);
            EntityMappingsAdvancedJUnitTestCase.assertTrue((String)"Violation object did not match after refresh", (boolean)EntityMappingsAdvancedJUnitTestCase.getServerSession((String)this.m_persistenceUnit).compareObjects((Object)violation, (Object)refreshedViolation));
        }
        catch (Exception e) {
            EntityMappingsAdvancedJUnitTestCase.fail((String)("An error occurred: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testXMLEntityMappingsWriteOut() {
        try {
            XMLEntityMappings mappings = new XMLEntityMappings();
            mappings.setPersistenceUnitMetadata(new XMLPersistenceUnitMetadata());
            mappings.getPersistenceUnitMetadata().setPersistenceUnitDefaults(new XMLPersistenceUnitDefaults());
            XMLPersistenceUnitMetadata persistenceUnitMetadata = new XMLPersistenceUnitMetadata();
            persistenceUnitMetadata.setPersistenceUnitDefaults(new XMLPersistenceUnitDefaults());
            mappings.setPersistenceUnitMetadata(persistenceUnitMetadata);
            EntityAccessor entity = new EntityAccessor();
            mappings.setEntities(new ArrayList());
            entity.setAttributes(new XMLAttributes());
            entity.getAttributes().setBasicCollections(new ArrayList());
            entity.getAttributes().getBasicCollections().add(new BasicCollectionAccessor());
            entity.getAttributes().setOneToManys(new ArrayList());
            OneToManyAccessor oneToMany = new OneToManyAccessor();
            oneToMany.setCascade(new CascadeMetadata());
            entity.getAttributes().getOneToManys().add(oneToMany);
            entity.getAttributes().setBasics(new ArrayList());
            entity.getAttributes().getBasics().add(new BasicAccessor());
            mappings.getEntities().add(entity);
            XMLEntityMappingsWriter writer = new XMLEntityMappingsWriter();
            FileOutputStream fileOut = new FileOutputStream("XMLWriteOutTest.xml");
            XMLEntityMappingsWriter.write((XMLEntityMappings)mappings, (OutputStream)fileOut);
            fileOut.close();
            FileInputStream fileIn = new FileInputStream(fileOut.getFD());
            BufferedReader in = new BufferedReader(new InputStreamReader(fileIn));
            HashSet<String> readStrings = new HashSet<String>();
            while (in.ready()) {
                readStrings.add(in.readLine());
            }
            in.close();
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found cascade on delete element", (boolean)readStrings.contains("<cascade-on-delete"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found non cacheable element", (boolean)readStrings.contains("<noncacheable"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found private owned element", (boolean)readStrings.contains("<private-owned"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found xml mapping metadata complete element", (boolean)readStrings.contains("<xml-mapping-metadata-complete"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found exclude default mappings element", (boolean)readStrings.contains("<exclude-default-mappings"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found delimeted identifiers element", (boolean)readStrings.contains("<delimited-identifiers"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found exclude default listeners element", (boolean)readStrings.contains("<exclude-default-listeners"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found exclude superclass listeners element", (boolean)readStrings.contains("<exclude-superclass-listeners"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found return update element", (boolean)readStrings.contains("<return-update"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found cascade all element", (boolean)readStrings.contains("<cascade-all"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found cascade persist element", (boolean)readStrings.contains("<cascade-persist"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found cascade merge element", (boolean)readStrings.contains("<cascade-merge"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found cascade remove element", (boolean)readStrings.contains("<cascade-remove"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found cascade refresh element", (boolean)readStrings.contains("<cascade-refresh"));
            EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"Found cascade detach element", (boolean)readStrings.contains("<cascade-detach"));
        }
        catch (Exception e) {
            e.printStackTrace();
            EntityMappingsAdvancedJUnitTestCase.fail((String)("An error occurred: " + e.getMessage()));
        }
    }

    public void testDeleteAll() {
        Map descriptors = EntityMappingsAdvancedJUnitTestCase.getServerSession((String)this.m_persistenceUnit).getDescriptors();
        ClassDescriptor descriptor = (ClassDescriptor)descriptors.get(Department.class);
        OneToManyMapping mapping = (OneToManyMapping)descriptor.getMappingForAttributeName("equipment");
        EntityMappingsAdvancedJUnitTestCase.assertFalse((String)"<delete-all> xml did not work correctly", (boolean)mapping.mustDeleteReferenceObjectsOneByOne());
    }

    static {
        visa = 1234567890L;
        amex = 1987654321L;
        diners = 1192837465L;
        mastercard = 1647382910L;
        rbc = 4783L;
        scotia = 8732L;
        td = 839362L;
        cibc = 948274L;
    }
}

