/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class NativeUpdateObjectInvalidationTest
extends ConfigurableCacheSyncDistributedTest {
    protected Employee employee;

    public NativeUpdateObjectInvalidationTest() {
        this.setDescription("Update the employee with raw SQL, and use invalidation API to invalidate.");
    }

    @Override
    public void setup() {
        super.setup();
        this.employee = new Employee();
        this.employee.setFirstName("George");
        this.employee.setLastName("Alpha");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.employee);
        uow.commit();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression expression = employees.get("firstName").equal((Object)this.employee.getFirstName());
        expression = expression.and(employees.get("lastName").equal((Object)this.employee.getLastName()));
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().firstElement();
        Object result = server.getDistributedSession().readObject(Employee.class, expression);
        NativeUpdateObjectInvalidationTest.assertNotNull((Object)result);
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        DataModifyQuery query = new DataModifyQuery("update EMPLOYEE set F_NAME = 'Beta' where L_NAME = 'Alpha'");
        if (this.getSession().isSessionBroker()) {
            query.setSessionName(((Session)((SessionBroker)this.getSession()).getSessionsByName().values().iterator().next()).getName());
        }
        uow.executeQuery((DatabaseQuery)query);
        uow.commit();
        this.getSession().getIdentityMapAccessor().invalidateObject((Object)this.employee, true);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void verify() {
        if (this.isObjectValidOnDistributedServer(this.employee)) {
            throw new TestErrorException("Employee should have been invalidated in the distributed cache, descriptor was set to: INVALIDATE_CHANGED_OBJECTS");
        }
    }
}

