/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.employee;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.tests.dynamic.DynamicEmployeeEntityComparator;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.testing.tests.dynamic.employee.DynamicEmployeeSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmployeeQueriesTestSuite {
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;
    static DynamicEmployeeSystem deSystem = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        if (8 == DynamicTestingHelper.logLevel) {
            session.dontLogMessages();
        } else {
            session.setLogLevel(DynamicTestingHelper.logLevel);
        }
        dynamicHelper = new DynamicHelper(session);
        deSystem = DynamicEmployeeSystem.buildProject(dynamicHelper);
        deSystem.populate(dynamicHelper);
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE D_SALARY");
        session.executeNonSelectingSQL("DROP TABLE D_PROJ_EMP");
        session.executeNonSelectingSQL("DROP TABLE D_PROJECT");
        session.executeNonSelectingSQL("DROP TABLE D_PHONE");
        session.executeNonSelectingSQL("DROP TABLE D_EMPLOYEE");
        session.executeNonSelectingSQL("DROP TABLE D_ADDRESS");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @Test
    public void findAllEmployees() {
        ReadAllQuery query = dynamicHelper.newReadAllQuery("Employee");
        query.addAscendingOrdering("id");
        List emps = (List)session.executeQuery((DatabaseQuery)query);
        this.assertSame(deSystem.employees(), emps);
    }

    @Test
    public void findAllEmployeesWithAddressJoin() {
        ReadAllQuery query = dynamicHelper.newReadAllQuery("Employee");
        query.addJoinedAttribute("address");
        query.addAscendingOrdering("lastName");
        query.addAscendingOrdering("firstName");
        List emps = (List)session.executeQuery((DatabaseQuery)query);
        Assert.assertNotNull((Object)emps);
    }

    @Test
    public void findLowestEmployeeById() {
        ReportQuery query = dynamicHelper.newReportQuery("Employee", new ExpressionBuilder());
        query.addMinimum("id");
        query.setShouldReturnSingleValue(true);
        int minId = ((Number)session.executeQuery((DatabaseQuery)query)).intValue();
        Assert.assertTrue((minId > 0 ? 1 : 0) != 0);
    }

    @Test
    public void findAllMaleEmployees() throws Exception {
        ReadAllQuery query = dynamicHelper.newReadAllQuery("Employee");
        ExpressionBuilder eb = query.getExpressionBuilder();
        query.setSelectionCriteria(eb.get("gender").equal((Object)"Male"));
        List emps = (List)session.executeQuery((DatabaseQuery)query);
        Assert.assertNotNull((Object)emps);
    }

    public void assertSame(DynamicEntity[] employees, List<DynamicEntity> dbEmps) {
        Assert.assertEquals((String)"Incorrect quantity of employees", (long)employees.length, (long)dbEmps.size());
        DynamicEmployeeEntityComparator dEmpComparator = new DynamicEmployeeEntityComparator();
        Collections.sort(dbEmps, dEmpComparator);
        List<DynamicEntity> sampleEmps = Arrays.asList(employees);
        Collections.sort(sampleEmps, dEmpComparator);
        for (int index = 0; index < employees.length; ++index) {
            DynamicEntity emp = sampleEmps.get(index);
            DynamicEntity dbEmp = dbEmps.get(index);
            Assert.assertEquals((String)("First name does not match on employees[" + index + "]"), (Object)emp.get("firstName"), (Object)dbEmp.get("firstName"));
            Assert.assertEquals((String)("Last name does not match on employees[" + index + "]"), (Object)emp.get("lastName"), (Object)dbEmp.get("lastName"));
            Assert.assertEquals((String)("Salary does not match on employees[" + index + "]"), (Object)emp.get("salary"), (Object)dbEmp.get("salary"));
        }
    }
}

