/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class IncorrectPartialAttributeTest
extends TestCase {
    protected boolean correctException = true;

    public IncorrectPartialAttributeTest() {
        this.setDescription("Ensure the proper exception is thrown when a query with a partial attribute that doesn't exist is run.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.dontMaintainCache();
        query.addPartialAttribute("nonExistant");
        try {
            this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (QueryException exception) {
            if (exception.getErrorCode() == 6120) {
                this.correctException = true;
            }
            this.correctException = false;
            throw exception;
        }
    }

    public void verify() {
        if (!this.correctException) {
            throw new TestErrorException("Specifying non-existant partial attributes does not result is the correct exception.");
        }
    }
}

