/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.driver;

import java.util.ArrayList;
import org.eclipse.persistence.tools.db.driver.AbstractWorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.CatalogStrategy;
import org.eclipse.persistence.tools.db.driver.FoldingStrategy;
import org.eclipse.persistence.tools.db.driver.LowerCaseFoldingStrategy;
import org.eclipse.persistence.tools.db.driver.SimpleCatalogStrategy;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapterFactory;
import org.eclipse.persistence.tools.gen.db.Database;

class PostgreSQL
extends AbstractWorkbenchDriverAdapter {
    private static final String PUBLIC_SCHEMA_NAME = "public";
    private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[]{'_'};
    private static final char[] EXTENDED_REGULAR_NAME_PART_CHARACTERS = new char[]{'$'};

    PostgreSQL(Database database) {
        super(database);
    }

    @Override
    CatalogStrategy buildCatalogStrategy() {
        return new SimpleCatalogStrategy();
    }

    @Override
    FoldingStrategy buildFoldingStrategy() {
        return LowerCaseFoldingStrategy.instance();
    }

    @Override
    void addDefaultCatalogNamesTo(ArrayList<String> names) {
        names.add(this.buildDefaultCatalogName());
    }

    private String buildDefaultCatalogName() {
        throw new UnsupportedOperationException("PostgresSQL not yet supported!");
    }

    @Override
    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        super.addDefaultSchemaNamesTo(names);
        names.add(PUBLIC_SCHEMA_NAME);
    }

    @Override
    char[] getExtendedRegularNameStartCharacters() {
        return EXTENDED_REGULAR_NAME_START_CHARACTERS;
    }

    @Override
    char[] getExtendedRegularNamePartCharacters() {
        return EXTENDED_REGULAR_NAME_PART_CHARACTERS;
    }

    static class Factory
    implements WorkbenchDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"postgres"};

        Factory() {
        }

        @Override
        public String[] getSupportedVendors() {
            return VENDORS;
        }

        @Override
        public WorkbenchDriverAdapter buildAdapter(Database database) {
            return new PostgreSQL(database);
        }
    }
}

