/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAccessMethods;
import org.eclipse.persistence.tools.mapping.orm.ExternalNonTransientMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalProperty;
import org.eclipse.persistence.tools.mapping.orm.dom.AccessMethods;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.Mapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Property;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

abstract class NonTransientMapping
extends Mapping
implements ExternalNonTransientMapping {
    static final String ACCESS = "access";

    NonTransientMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public final void addAccessMethods(String getMethodName, String setMethodName) {
        AccessMethods accessMethods = this.buildAccessMethods();
        accessMethods.addSelf();
        accessMethods.setGetMethod(getMethodName);
        accessMethods.setSetMethod(setMethodName);
    }

    @Override
    public final void addProperty(int index, String name, String value) {
        Property property = this.buildProperty(index);
        property.addSelf();
        property.setName(name);
        property.setValue(value);
    }

    private AccessMethods buildAccessMethods() {
        return new AccessMethods(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private Property buildProperty(int index) {
        return new Property(this, index);
    }

    @Override
    public final ExternalAccessMethods getAccessMethods() {
        Element element = this.getChild("access-methods");
        if (element == null) {
            return null;
        }
        return this.buildAccessMethods();
    }

    @Override
    public final AccessType getAccessType() {
        return this.getEnumAttribute(ACCESS, AccessType.class);
    }

    @Override
    public final ExternalProperty getProperty(int index) {
        Element element = this.getChild("property", index);
        if (element == null) {
            return null;
        }
        return this.buildProperty(index);
    }

    @Override
    public final ListIterable<ExternalProperty> properties() {
        int count = this.propertiesSize();
        ArrayList<Property> properties = new ArrayList<Property>(count);
        int index = count;
        while (--index >= 0) {
            Property associationOverride = this.buildProperty(index);
            properties.add(0, associationOverride);
        }
        return new ListListIterable(properties);
    }

    @Override
    public final int propertiesSize() {
        return this.getChildrenSize("property");
    }

    @Override
    public final void removeAccessMethods() {
        this.removeChild("access-methods");
    }

    @Override
    public final void removeProperty(int index) {
        Property property = this.buildProperty(index);
        property.removeSelf();
    }

    @Override
    public final void setAccessType(AccessType type) {
        this.setAttribute(ACCESS, (Enum<?>)type);
    }
}

