/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ByteArrayTools;
import org.eclipse.persistence.tools.utility.CharArrayTools;
import org.eclipse.persistence.tools.utility.StringTools;
import org.eclipse.persistence.tools.utility.tests.StringToolsTests;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class CharArrayToolsTests
extends TestCase {
    public void testCenter() {
        TestTools.assertEquals("fred", CharArrayTools.center((char[])"fred".toCharArray(), (int)4));
        TestTools.assertEquals(" fred ", CharArrayTools.center((char[])"fred".toCharArray(), (int)6));
        TestTools.assertEquals(" fred  ", CharArrayTools.center((char[])"fred".toCharArray(), (int)7));
        TestTools.assertEquals("re", CharArrayTools.center((char[])"fred".toCharArray(), (int)2));
        TestTools.assertEquals("fre", CharArrayTools.center((char[])"fred".toCharArray(), (int)3));
    }

    public void testPad() {
        TestTools.assertEquals("fred", CharArrayTools.pad((char[])new char[]{'f', 'r', 'e', 'd'}, (int)4));
        TestTools.assertEquals("fred  ", CharArrayTools.pad((char[])new char[]{'f', 'r', 'e', 'd'}, (int)6));
        boolean exThrown = false;
        try {
            TestTools.assertEquals("fr", CharArrayTools.pad((char[])new char[]{'f', 'r', 'e', 'd'}, (int)2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        CharArrayToolsTests.assertTrue((boolean)exThrown);
    }

    public void testFit() {
        TestTools.assertEquals("fred", CharArrayTools.fit((char[])new char[]{'f', 'r', 'e', 'd'}, (int)4));
        TestTools.assertEquals("fred  ", CharArrayTools.fit((char[])new char[]{'f', 'r', 'e', 'd'}, (int)6));
        TestTools.assertEquals("fr", CharArrayTools.fit((char[])new char[]{'f', 'r', 'e', 'd'}, (int)2));
    }

    public void testZeroPad() {
        TestTools.assertEquals("1234", CharArrayTools.zeroPad((char[])new char[]{'1', '2', '3', '4'}, (int)4));
        TestTools.assertEquals("001234", CharArrayTools.zeroPad((char[])new char[]{'1', '2', '3', '4'}, (int)6));
        boolean exThrown = false;
        try {
            TestTools.assertEquals("12", CharArrayTools.zeroPad((char[])new char[]{'1', '2', '3', '4'}, (int)2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exThrown = true;
        }
        CharArrayToolsTests.assertTrue((boolean)exThrown);
    }

    public void testZeroFit() {
        TestTools.assertEquals("1234", CharArrayTools.zeroFit((char[])new char[]{'1', '2', '3', '4'}, (int)4));
        TestTools.assertEquals("001234", CharArrayTools.zeroFit((char[])new char[]{'1', '2', '3', '4'}, (int)6));
        TestTools.assertEquals("34", CharArrayTools.zeroFit((char[])new char[]{'1', '2', '3', '4'}, (int)2));
    }

    public void testSeparate() {
        this.verifySeparate("012345", '-', 22, "012345");
        this.verifySeparate("012345", '-', 6, "012345");
        this.verifySeparate("012345", '-', 5, "01234-5");
        this.verifySeparate("012345", '-', 4, "0123-45");
        this.verifySeparate("012345", '-', 3, "012-345");
        this.verifySeparate("012345", '-', 2, "01-23-45");
        this.verifySeparate("012345", '-', 1, "0-1-2-3-4-5");
    }

    private void verifySeparate(String string, char separator, int segmentLength, String expected) {
        TestTools.assertEquals(expected, CharArrayTools.separate((char[])string.toCharArray(), (char)separator, (int)segmentLength));
    }

    public void testRemoveFirstOccurrence() {
        this.verifyRemoveFirstOccurrence("Emplo&yee", '&', "Employee");
        this.verifyRemoveFirstOccurrence("Emplo&yee&", '&', "Employee&");
        this.verifyRemoveFirstOccurrence("Employee &Foo", '&', "Employee Foo");
        this.verifyRemoveFirstOccurrence("Employee&", '&', "Employee");
        this.verifyRemoveFirstOccurrence("&Employee", '&', "Employee");
    }

    private void verifyRemoveFirstOccurrence(String string, char charToRemove, String expectedString) {
        TestTools.assertEquals(expectedString, CharArrayTools.removeFirstOccurrence((char[])string.toCharArray(), (char)charToRemove));
    }

    public void testRemoveAllOccurrences() {
        this.verifyRemoveAllOccurrences("Employee Fred", ' ', "EmployeeFred");
        this.verifyRemoveAllOccurrences(" Employee ", ' ', "Employee");
        this.verifyRemoveAllOccurrences("Employee   Foo", ' ', "EmployeeFoo");
        this.verifyRemoveAllOccurrences(" Emp loyee   Foo", ' ', "EmployeeFoo");
    }

    private void verifyRemoveAllOccurrences(String string, char charToRemove, String expectedString) {
        TestTools.assertEquals(expectedString, CharArrayTools.removeAllOccurrences((char[])string.toCharArray(), (char)charToRemove));
    }

    public void testRemoveAllWhitespace() {
        this.verifyRemoveAllWhitespace("Employee Fred\t", "EmployeeFred");
        this.verifyRemoveAllWhitespace("\tEmployee\n", "Employee");
        this.verifyRemoveAllWhitespace("Employee \t Foo", "EmployeeFoo");
        this.verifyRemoveAllWhitespace(" Emp\tloyee \n Foo", "EmployeeFoo");
    }

    private void verifyRemoveAllWhitespace(String string, String expectedString) {
        TestTools.assertEquals(expectedString, CharArrayTools.removeAllWhitespace((char[])string.toCharArray()));
    }

    public void testCompressWhitespace() {
        this.verifyCompressWhitespace("Employee      Fred\t", "Employee Fred ");
        this.verifyCompressWhitespace("\tEmployee  \n", " Employee ");
        this.verifyCompressWhitespace("Employee \t Foo", "Employee Foo");
        this.verifyCompressWhitespace(" Emp\tloyee \n Foo ", " Emp loyee Foo ");
    }

    private void verifyCompressWhitespace(String string, String expectedString) {
        TestTools.assertEquals(expectedString, CharArrayTools.compressWhitespace((char[])string.toCharArray()));
    }

    public void testCapitalize() {
        this.verifyCapitalize("Oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalize("Oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyCapitalize("   ", new char[]{' ', ' ', ' '});
        this.verifyCapitalize("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyCapitalize("", new char[0]);
        this.verifyCapitalize("A", new char[]{'a'});
        this.verifyCapitalize("\u00c9cole", new char[]{'\u00e9', 'c', 'o', 'l', 'e'});
    }

    private void verifyCapitalize(String expected, char[] string) {
        TestTools.assertEquals(expected, CharArrayTools.capitalize((char[])string));
    }

    public void testUnapitalize() {
        this.verifyUncapitalize("oracle", new char[]{'O', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalize("oracle", new char[]{'o', 'r', 'a', 'c', 'l', 'e'});
        this.verifyUncapitalize("   ", new char[]{' ', ' ', ' '});
        this.verifyUncapitalize("ORACLE", new char[]{'O', 'R', 'A', 'C', 'L', 'E'});
        this.verifyUncapitalize("", new char[0]);
        this.verifyUncapitalize("a", new char[]{'A'});
        this.verifyUncapitalize("\u00e9cole", new char[]{'\u00c9', 'c', 'o', 'l', 'e'});
    }

    private void verifyUncapitalize(String expected, char[] string) {
        TestTools.assertEquals(expected, CharArrayTools.uncapitalize((char[])string));
    }

    public void testIsBlank() {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isBlank(null));
        this.verifyIsBlank("");
        this.verifyIsBlank("      \t\t   ");
        this.verifyIsBlank("      ");
        this.verifyIsBlank("      \t\t   " + StringTools.CR);
    }

    private void verifyIsBlank(String string) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isBlank((char[])string.toCharArray()));
    }

    public void testEqualsIgnoreCase() {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.equalsIgnoreCase(null, null));
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.equalsIgnoreCase(null, (char[])"asdf".toCharArray()));
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.equalsIgnoreCase((char[])"asdf".toCharArray(), null));
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.equalsIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdf".toCharArray()));
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.equalsIgnoreCase((char[])"asdf".toCharArray(), (char[])"ASDF".toCharArray()));
    }

    public void testStartsWithIgnoreCase() {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"as".toCharArray()));
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"aS".toCharArray()));
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"".toCharArray()));
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"A".toCharArray()));
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"ASDF".toCharArray()));
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdf".toCharArray()));
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"bsdf".toCharArray()));
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"g".toCharArray()));
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdg".toCharArray()));
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdfg".toCharArray()));
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.startsWithIgnoreCase((char[])"asdf".toCharArray(), (char[])"asdfgggggg".toCharArray()));
    }

    public void testIsUppercase() {
        this.verifyIsUppercase("FOO");
        this.verifyIsUppercase("FOO2");
        this.verifyIsUppercase("F O O");
        this.denyIsUppercase("Foo");
        this.denyIsUppercase("");
    }

    private void verifyIsUppercase(String s) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isUppercase((char[])s.toCharArray()));
    }

    private void denyIsUppercase(String s) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isUppercase((char[])s.toCharArray()));
    }

    public void testIsLowercase() {
        this.verifyIsLowercase("foo");
        this.verifyIsLowercase("foo2");
        this.verifyIsLowercase("f o o");
        this.denyIsLowercase("Foo");
        this.denyIsLowercase("");
    }

    private void verifyIsLowercase(String s) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isLowercase((char[])s.toCharArray()));
    }

    private void denyIsLowercase(String s) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isLowercase((char[])s.toCharArray()));
    }

    public void testConvertHexStringToByteArray_empty() throws Exception {
        char[] s = CharArrayTools.EMPTY_CHAR_ARRAY;
        byte[] byteArray = CharArrayTools.convertHexStringToByteArray((char[])s);
        CharArrayToolsTests.assertEquals((int)0, (int)byteArray.length);
        CharArrayToolsTests.assertTrue((boolean)Arrays.equals(ByteArrayTools.EMPTY_BYTE_ARRAY, byteArray));
    }

    public void testConvertHexStringToByteArray_oddLength() throws Exception {
        String s = "CAFEE";
        boolean exCaught = false;
        try {
            byte[] byteArray = CharArrayTools.convertHexStringToByteArray((char[])s.toCharArray());
            CharArrayToolsTests.fail((String)("bogus byte array: " + Arrays.toString(byteArray)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        CharArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testConvertHexStringToByteArray_illegalCharacter1() throws Exception {
        this.verifyConvertHexStringToByteArray_illegalCharacter("CAFEX0CAFE");
    }

    public void testConvertHexStringToByteArray_illegalCharacter2() throws Exception {
        this.verifyConvertHexStringToByteArray_illegalCharacter("CAFE0XCAFE");
    }

    private void verifyConvertHexStringToByteArray_illegalCharacter(String s) throws Exception {
        boolean exCaught = false;
        try {
            byte[] byteArray = CharArrayTools.convertHexStringToByteArray((char[])s.toCharArray());
            CharArrayToolsTests.fail((String)("bogus byte array: " + Arrays.toString(byteArray)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        CharArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testConvertHexStringToByteArray_ok() throws Exception {
        String s = "74657374";
        TestTools.assertEquals("test", CharArrayTools.convertHexStringToByteArray((char[])s.toCharArray()));
    }

    public void testConvertHexStringToByteArray_negative() throws Exception {
        String s = this.getHexCafe();
        TestTools.assertEquals("caf\u00e9", CharArrayTools.convertHexStringToByteArray((char[])s.toCharArray()));
    }

    public void testConvertHexStringToByteArray_lowercase() throws Exception {
        String s = this.getHexCafe().toLowerCase();
        TestTools.assertEquals("caf\u00e9", CharArrayTools.convertHexStringToByteArray((char[])s.toCharArray()));
    }

    private String getHexCafe() {
        return StringToolsTests.getHexCafe();
    }

    public void testIsQuoted() {
        this.denyIsQuoted("foo");
        this.verifyIsQuoted("\"foo\"");
        this.denyIsQuoted("");
        this.verifyIsQuoted("\"\"");
        this.denyIsQuoted("\"");
        this.denyIsQuoted(" ");
        this.denyIsQuoted("''");
        this.denyIsQuoted("'foo'");
    }

    private void verifyIsQuoted(String s) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isQuoted((char[])s.toCharArray()));
    }

    private void denyIsQuoted(String s) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isQuoted((char[])s.toCharArray()));
    }

    public void testIsParenthetical() {
        this.denyIsParenthetical("foo");
        this.verifyIsParenthetical("(foo)");
        this.denyIsParenthetical("");
        this.verifyIsParenthetical("()");
        this.denyIsParenthetical("(");
        this.denyIsParenthetical(" ");
        this.denyIsParenthetical("''");
        this.denyIsParenthetical("'foo'");
    }

    private void verifyIsParenthetical(String s) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isParenthetical((char[])s.toCharArray()));
    }

    private void denyIsParenthetical(String s) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isParenthetical((char[])s.toCharArray()));
    }

    public void testIsBracketed() {
        this.denyIsBracketed("foo");
        this.verifyIsBracketed("[foo]");
        this.denyIsBracketed("");
        this.verifyIsBracketed("[]");
        this.denyIsBracketed("[");
        this.denyIsBracketed(" ");
        this.denyIsBracketed("''");
        this.denyIsBracketed("'foo'");
    }

    private void verifyIsBracketed(String s) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isBracketed((char[])s.toCharArray()));
    }

    private void denyIsBracketed(String s) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isBracketed((char[])s.toCharArray()));
    }

    public void testIsBraced() {
        this.denyIsBraced("foo");
        this.verifyIsBraced("{foo}");
        this.denyIsBraced("");
        this.verifyIsBraced("{}");
        this.denyIsBraced("{");
        this.denyIsBraced(" ");
        this.denyIsBraced("''");
        this.denyIsBraced("'foo'");
    }

    private void verifyIsBraced(String s) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isBraced((char[])s.toCharArray()));
    }

    private void denyIsBraced(String s) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isBraced((char[])s.toCharArray()));
    }

    public void testIsChevroned() {
        this.denyIsChevroned("foo");
        this.verifyIsChevroned("<foo>");
        this.denyIsChevroned("");
        this.verifyIsChevroned("<>");
        this.denyIsChevroned("{");
        this.denyIsChevroned(" ");
        this.denyIsChevroned("''");
        this.denyIsChevroned("'foo'");
    }

    private void verifyIsChevroned(String s) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isChevroned((char[])s.toCharArray()));
    }

    private void denyIsChevroned(String s) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isChevroned((char[])s.toCharArray()));
    }

    public void testIsDelimited() {
        this.denyIsDelimited("foo", '?');
        this.verifyIsDelimited("?foo?", '?');
        this.denyIsDelimited("", '?');
        this.verifyIsDelimited("\"\"", '\"');
        this.verifyIsDelimited("?xx?", '?');
        this.denyIsDelimited("?xx]", '?');
        this.denyIsDelimited("\"", '\"');
        this.denyIsDelimited(" ", ' ');
        this.denyIsDelimited("''", '\"');
        this.denyIsDelimited("'foo'", '?');
    }

    private void verifyIsDelimited(String s, char c) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isDelimited((char[])s.toCharArray(), (char)c));
    }

    private void denyIsDelimited(String s, char c) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isDelimited((char[])s.toCharArray(), (char)c));
    }

    public void testIsDelimited2() {
        this.denyIsDelimited2("foo", '[', ']');
        this.verifyIsDelimited2("{foo}", '{', '}');
        this.denyIsDelimited2("", '[', ']');
        this.verifyIsDelimited2("[]", '[', ']');
        this.verifyIsDelimited2("[xx]", '[', ']');
        this.denyIsDelimited2("?xx]", '[', ']');
        this.denyIsDelimited2("\"", '[', ']');
        this.denyIsDelimited2(" ", '[', ']');
        this.denyIsDelimited2("''", '[', ']');
        this.denyIsDelimited2("'foo'", '[', ']');
    }

    private void verifyIsDelimited2(String s, char start, char end) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isDelimited((char[])s.toCharArray(), (char)start, (char)end));
    }

    private void denyIsDelimited2(String s, char start, char end) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isDelimited((char[])s.toCharArray(), (char)start, (char)end));
    }

    public void testUndelimit() {
        this.verifyUndelimit("\"foo\"", "foo");
        this.verifyUndelimit("\"\"", "");
        this.verifyUndelimit("'foo'", "foo");
        this.verifyUndelimit("\"fo\"\"o\"", "fo\"o");
        this.verifyUndelimit("\"foo\"\"\"", "foo\"");
        this.verifyUndelimit("\"\"\"foo\"", "\"foo");
        this.verifyUndelimit("[foo]", "foo");
        this.verifyUndelimit("\"\"\"", "\"");
        this.verifyUndelimit("\"foo\"bar\"", "foo\"");
        this.verifyUndelimit("\"foo\"\"", "foo\"");
    }

    private void verifyUndelimit(String s, String expected) {
        TestTools.assertEquals(expected, CharArrayTools.undelimit((char[])s.toCharArray()));
    }

    public void testUndelimitInt() {
        this.verifyUndelimitInt("\"foo\"", 2, "o");
        this.verifyUndelimitInt("\"\"foo\"\"", 2, "foo");
        this.verifyUndelimitInt("'foo'", 2, "o");
    }

    private void verifyUndelimitInt(String s, int count, String expected) {
        TestTools.assertEquals(expected, CharArrayTools.undelimit((char[])s.toCharArray(), (int)count));
    }

    public void testUndelimitIntException() {
        this.denyUndelimitInt("\"\"", 2);
        this.denyUndelimitInt("'o'", 2);
    }

    private void denyUndelimitInt(String s, int count) {
        boolean exCaught = false;
        try {
            char[] bogus = CharArrayTools.undelimit((char[])s.toCharArray(), (int)count);
            CharArrayToolsTests.fail((String)("invalid string: " + new String(bogus)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        CharArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testConvertToJavaStringLiteral() {
        this.verifyConvertToJavaStringLiteral("", "\"\"");
        this.verifyConvertToJavaStringLiteral("\"\"", "\"\\\"\\\"\"");
        this.verifyConvertToJavaStringLiteral("'foo'", "\"'foo'\"");
        this.verifyConvertToJavaStringLiteral("foo\bbar", "\"foo\\bbar\"");
        this.verifyConvertToJavaStringLiteral("foo\n\tbar", "\"foo\\n\\tbar\"");
        this.verifyConvertToJavaStringLiteral("foo\"bar", "\"foo\\\"bar\"");
        this.verifyConvertToJavaStringLiteral("foo\\bar", "\"foo\\\\bar\"");
    }

    private void verifyConvertToJavaStringLiteral(String s, String expected) {
        TestTools.assertEquals(expected, CharArrayTools.convertToJavaStringLiteral((char[])s.toCharArray()));
    }

    public void testConvertToXmlAttributeValue() {
        this.verifyConvertToXmlAttributeValue("", "\"\"");
        this.verifyConvertToXmlAttributeValue("\"", "'\"'");
        this.verifyConvertToXmlAttributeValue("\"\"", "'\"\"'");
        this.verifyConvertToXmlAttributeValue("'", "\"'\"");
        this.verifyConvertToXmlAttributeValue("''", "\"''\"");
        this.verifyConvertToXmlAttributeValue("\"'\"", "\"&quot;'&quot;\"");
        this.verifyConvertToXmlAttributeValue("\"''\"", "\"&quot;''&quot;\"");
        this.verifyConvertToXmlAttributeValue("'foo'", "\"'foo'\"");
        this.verifyConvertToXmlAttributeValue("\"foo\"", "'\"foo\"'");
        this.verifyConvertToXmlAttributeValue("\"foo\" 'bar'", "\"&quot;foo&quot; 'bar'\"");
        this.verifyConvertToXmlAttributeValue("foo & bar", "\"foo &amp; bar\"");
        this.verifyConvertToXmlAttributeValue("\"foo & bar\"", "'\"foo &amp; bar\"'");
        this.verifyConvertToXmlAttributeValue("foo <<< bar", "\"foo &lt;&lt;&lt; bar\"");
        this.verifyConvertToXmlAttributeValue("\"foo <<< bar\"", "'\"foo &lt;&lt;&lt; bar\"'");
    }

    private void verifyConvertToXmlAttributeValue(String s, String expected) {
        TestTools.assertEquals(expected, CharArrayTools.convertToXmlAttributeValue((char[])s.toCharArray()));
    }

    public void testConvertToXmlElementText() {
        this.verifyConvertToXmlElementText("", "");
        this.verifyConvertToXmlElementText("\"", "\"");
        this.verifyConvertToXmlElementText("\"\"", "\"\"");
        this.verifyConvertToXmlElementText("'", "'");
        this.verifyConvertToXmlElementText("''", "''");
        this.verifyConvertToXmlElementText("\"'\"", "\"'\"");
        this.verifyConvertToXmlElementText("\"''\"", "\"''\"");
        this.verifyConvertToXmlElementText("'foo'", "'foo'");
        this.verifyConvertToXmlElementText("foo & bar", "foo &amp; bar");
        this.verifyConvertToXmlElementText("foo &", "foo &amp;");
        this.verifyConvertToXmlElementText("& bar", "&amp; bar");
        this.verifyConvertToXmlElementText("\"foo & bar\"", "\"foo &amp; bar\"");
        this.verifyConvertToXmlElementText("foo <<< bar", "foo &lt;&lt;&lt; bar");
        this.verifyConvertToXmlElementText("\"foo <<< bar\"", "\"foo &lt;&lt;&lt; bar\"");
    }

    private void verifyConvertToXmlElementText(String s, String expected) {
        TestTools.assertEquals(expected, CharArrayTools.convertToXmlElementText((char[])s.toCharArray()));
    }

    public void testConvertToXmlElementCDATA() {
        String START = "<![CDATA[";
        String END = "]]>";
        this.verifyConvertToXmlElementCDATA("", String.valueOf(START) + END);
        this.verifyConvertToXmlElementCDATA("\"", String.valueOf(START) + "\"" + END);
        this.verifyConvertToXmlElementCDATA("\"\"", String.valueOf(START) + "\"\"" + END);
        this.verifyConvertToXmlElementCDATA("'", String.valueOf(START) + "'" + END);
        this.verifyConvertToXmlElementCDATA("''", String.valueOf(START) + "''" + END);
        this.verifyConvertToXmlElementCDATA("\"'\"", String.valueOf(START) + "\"'\"" + END);
        this.verifyConvertToXmlElementCDATA("\"''\"", String.valueOf(START) + "\"''\"" + END);
        this.verifyConvertToXmlElementCDATA("'foo'", String.valueOf(START) + "'foo'" + END);
        this.verifyConvertToXmlElementCDATA("foo & bar", String.valueOf(START) + "foo & bar" + END);
        this.verifyConvertToXmlElementCDATA("foo &", String.valueOf(START) + "foo &" + END);
        this.verifyConvertToXmlElementCDATA("& bar", String.valueOf(START) + "& bar" + END);
        this.verifyConvertToXmlElementCDATA("\"foo & bar\"", String.valueOf(START) + "\"foo & bar\"" + END);
        this.verifyConvertToXmlElementCDATA("foo <<< bar", String.valueOf(START) + "foo <<< bar" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <<< bar\"", String.valueOf(START) + "\"foo <<< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <&< bar\"", String.valueOf(START) + "\"foo <&< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <]< bar\"", String.valueOf(START) + "\"foo <]< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <]]< bar\"", String.valueOf(START) + "\"foo <]]< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("\"foo <]]>< bar\"", String.valueOf(START) + "\"foo <]]&gt;< bar\"" + END);
        this.verifyConvertToXmlElementCDATA("foo <]", String.valueOf(START) + "foo <]" + END);
        this.verifyConvertToXmlElementCDATA("foo <]]", String.valueOf(START) + "foo <]]" + END);
        this.verifyConvertToXmlElementCDATA("foo <]]>", String.valueOf(START) + "foo <]]&gt;" + END);
        this.verifyConvertToXmlElementCDATA("]foo", String.valueOf(START) + "]foo" + END);
        this.verifyConvertToXmlElementCDATA("]]foo", String.valueOf(START) + "]]foo" + END);
        this.verifyConvertToXmlElementCDATA("]]>foo", String.valueOf(START) + "]]&gt;foo" + END);
    }

    private void verifyConvertToXmlElementCDATA(String s, String expected) {
        TestTools.assertEquals(expected, CharArrayTools.convertToXmlElementCDATA((char[])s.toCharArray()));
    }
}

