/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.transformer;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.io.FileTools;
import org.eclipse.persistence.tools.utility.transformer.XMLStringEncoder;

public class XMLStringEncoderTests
extends TestCase {
    public XMLStringEncoderTests(String name) {
        super(name);
    }

    public void testEncodeNoCharacterSequences() {
        XMLStringEncoder encoder = new XMLStringEncoder(FileTools.INVALID_FILENAME_CHARACTERS);
        String s = "foo";
        XMLStringEncoderTests.assertEquals((String)s, (String)((String)encoder.transform((Object)s)));
        s = "123foo123";
        XMLStringEncoderTests.assertEquals((String)s, (String)((String)encoder.transform((Object)s)));
    }

    public void testEncodeCharacterSequences() {
        XMLStringEncoder encoder = new XMLStringEncoder(FileTools.INVALID_FILENAME_CHARACTERS);
        String s = "?foo?";
        String expected = "&#x3f;foo&#x3f;";
        XMLStringEncoderTests.assertEquals((String)expected, (String)((String)encoder.transform((Object)s)));
        s = "?foo&123";
        expected = "&#x3f;foo&#x26;123";
        XMLStringEncoderTests.assertEquals((String)expected, (String)((String)encoder.transform((Object)s)));
    }
}

