/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.collection.Stack;

public class LinkedStack<E>
implements Stack<E>,
Cloneable,
Serializable {
    private LinkedList<E> elements;
    private static final long serialVersionUID = 1L;

    public LinkedStack() {
        this.elements = new LinkedList();
    }

    public LinkedStack(Collection<? extends E> collection) {
        this.elements = new LinkedList<E>(collection);
    }

    @Override
    public void push(E element) {
        this.elements.addLast(element);
    }

    @Override
    public E pop() {
        try {
            return this.elements.removeLast();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new EmptyStackException();
        }
    }

    @Override
    public E peek() {
        try {
            return this.elements.getLast();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new EmptyStackException();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public LinkedStack<E> clone() {
        try {
            LinkedList list;
            LinkedStack clone = (LinkedStack)super.clone();
            clone.elements = list = (LinkedList)this.elements.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.elements.toString();
    }
}

