/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.CommandExecutor;

public abstract class AbstractSafeCommandExecutor<E extends CommandExecutor>
implements CommandExecutor {
    protected final E commandExecutor;
    protected final ExceptionHandler exceptionHandler;

    protected AbstractSafeCommandExecutor(E commandExecutor) {
        this(commandExecutor, ExceptionHandler.Null.instance());
    }

    protected AbstractSafeCommandExecutor(E commandExecutor, ExceptionHandler exceptionHandler) {
        if (commandExecutor == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.commandExecutor = commandExecutor;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void execute(Command command) {
        try {
            this.commandExecutor.execute(command);
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.commandExecutor);
    }
}

