/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.command.Command;

public class ThreadLocalCommand
implements Command {
    protected final ThreadLocal<Command> threadLocal;
    protected final Command defaultCommand;

    public ThreadLocalCommand() {
        this(Command.Null.instance());
    }

    public ThreadLocalCommand(Command defaultCommand) {
        if (defaultCommand == null) {
            throw new NullPointerException();
        }
        this.defaultCommand = defaultCommand;
        this.threadLocal = this.buildThreadLocal();
    }

    protected ThreadLocal<Command> buildThreadLocal() {
        return new ThreadLocal<Command>();
    }

    @Override
    public void execute() {
        this.get().execute();
    }

    protected Command get() {
        Command command = this.threadLocal.get();
        return command != null ? command : this.defaultCommand;
    }

    public void set(Command command) {
        this.threadLocal.set(command);
    }

    public String toString() {
        return this.get().toString();
    }
}

