/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value.swing;

import javax.swing.AbstractSpinnerModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;

public class SpinnerModelAdapter
extends AbstractSpinnerModel {
    protected final SpinnerModel delegate;
    protected final ChangeListener delegateListener;
    protected final ModifiablePropertyValueModel<Object> valueHolder;
    protected final PropertyChangeListener valueListener;

    public SpinnerModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, SpinnerModel delegate) {
        if (valueHolder == null || delegate == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.delegate = delegate;
        this.valueListener = this.buildValueListener();
        this.delegateListener = this.buildDelegateListener();
    }

    public SpinnerModelAdapter(ModifiablePropertyValueModel<Object> valueHolder) {
        this(valueHolder, new SpinnerNumberModel());
    }

    protected PropertyChangeListener buildValueListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildValueListener_());
    }

    protected PropertyChangeListener buildValueListener_() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                SpinnerModelAdapter.this.valueChanged(event);
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
    }

    protected ChangeListener buildDelegateListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SpinnerModelAdapter.this.fireStateChanged();
            }

            public String toString() {
                return "delegate listener";
            }
        };
    }

    @Override
    public Object getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(Object value) {
        this.delegate.setValue(value);
        this.valueHolder.setValue(value);
    }

    @Override
    public Object getNextValue() {
        return this.delegate.getNextValue();
    }

    @Override
    public Object getPreviousValue() {
        return this.delegate.getPreviousValue();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList.getListenerCount(ChangeListener.class) == 0) {
            this.delegate.addChangeListener(this.delegateListener);
            this.engageValueHolder();
        }
        super.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.listenerList.getListenerCount(ChangeListener.class) == 0) {
            this.disengageValueHolder();
            this.delegate.removeChangeListener(this.delegateListener);
        }
    }

    protected void valueChanged(PropertyChangeEvent event) {
        this.synchronizeDelegate(event.getNewValue());
    }

    protected void synchronizeDelegate(Object value) {
        if (!this.delegate.getValue().equals(value)) {
            this.delegate.setValue(value);
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueListener);
        this.synchronizeDelegate(this.valueHolder.getValue());
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.valueHolder);
    }
}

