/*******************************************************************************
 * Copyright (c) 1998, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.relational.handles;

import org.eclipse.persistence.tools.db.relational.ELModel;
import org.eclipse.persistence.tools.db.relational.ELTable;
import org.eclipse.persistence.tools.utility.node.Node;

/**
 * MWTableHandle is used to handle a reference to a MWTable via a table name.
 *
 * @version 2.5
 */
@SuppressWarnings("nls")
public final class MWTableHandle extends MWHandle {

	/**
	 * This is the actual table.
	 * It is built from the table name, below.
	 */
	private volatile ELTable table;

	/**
	 * The table name is transient. It is used only to hold its value
	 * until postProjectBuild() is called and we can resolve
	 * the actual table. We do not keep it in synch with the table
	 * itself because we cannot know when the table has been renamed etc.
	 */
	private volatile String tableName;

	// ********** constructors **********

	/**
 	 * default constructor - for TopLink use only
 	 */
	@SuppressWarnings("unused")
	private MWTableHandle() {
		super();
	}

	public MWTableHandle(ELModel parent, NodeReferenceScrubber scrubber) {
		super(parent, scrubber);
	}

	public MWTableHandle(ELModel parent, ELTable table, NodeReferenceScrubber scrubber) {
		super(parent, scrubber);
		this.table = table;
	}


	// ********** instance methods **********

	public ELTable getTable() {
		return this.table;
	}

	public void setTable(ELTable table) {
		this.table = table;
	}

	@Override
	protected Node node() {
		return getTable();
	}

	public MWTableHandle setScrubber(NodeReferenceScrubber scrubber) {
		this.setScrubberInternal(scrubber);
		return this;
	}

	@Override
	public void toString(StringBuffer sb) {
		if (this.table == null) {
			sb.append("null");
		} else {
			this.table.toString(sb);
		}
	}
}